@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-danger btn-sm" id="deleteall"><i class="fa fa-trash-alt"></i> Delete
                    selected</button>

                <!-- Large modal -->
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target=".service"><i
                        class="fa fa-plus"></i> Register
                    service</button>

                <div class="modal fade service" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">

                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Register new service</h5>
                                <button type="button" class="close btn btn-outline-secondary" data-dismiss="modal"
                                    aria-label="Close" title="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>

                            <form action="{{ route('service.store') }}" method="post" class="was-validated">
                                @csrf
                                <div class="modal-body">
                                    <label for="name">Service name</label>
                                    <input type="text" name="name" class="form-control" id="name" required>

                                    <label for="price">Price</label>
                                    <input type="number" name="price" class="form-control" id="price" required>

                                    <label for="location">Location</label>
                                    <select name="location" id="location" class="form-control" required>
                                        <option disabled selected value="">-- Select location --</option>
                                        @foreach ($sellings as $selling)
                                            <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="modal-footer">
                                    <button class="btn btn-primary btn-block"> <i class="fa fa-paper-plane"></i>
                                        Save</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle shadow-sm" id="example1">
                    <thead class="thead-dark">
                        <tr>
                            <th class="text-center" style="width: 1%;"><input type="checkbox" id="checkall"></th>
                            <th class="text-center" style="width: 5%;">#</th>
                            <th class="text-center">Service</th>
                            <th class="text-center">Price</th>
                            <th class="text-center">Location</th>
                            <th class="text-center" style="width: 25%">Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @forelse ($services as $service)
                            <tr>
                                <td class="text-center">
                                    <input type="checkbox" class="selected" id="{{ $service->id }}">
                                </td>
                                <td class="text-center">{{ $loop->iteration }}</td>
                                <td class="text-center">
                                    <span class="fw-bold">{{ $service->product }}</span>
                                </td>
                                <td class="text-center"> {{ number_format($service->unit[0]->selling) }} </td>
                                <td class="text-center">
                                    <span class="badge badge-primary px-3 py-2">
                                        {{ $service->location->name }}
                                    </span>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <!-- View Modal Trigger -->
                                        <button type="button" class="btn btn-secondary btn-sm" data-toggle="modal"
                                            data-target="#view-{{ $service->id }}" title="View Products">
                                            <i class="fa fa-eye"></i> View
                                        </button>

                                        <!-- View Modal -->
                                        <div class="modal fade" id="view-{{ $service->id }}" tabindex="-1" role="dialog"
                                            aria-labelledby="viewLabel{{ $service->id }}" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="card">
                                                        <div class="card-header bg-light">
                                                            <button class="btn btn-danger eliminate">
                                                                <i class="fa fa-trash-alt"></i> Delete selected
                                                            </button>
                                                        </div>
                                                        <div class="card-body">
                                                            <table class="table table-bordered table-hover small mb-0">
                                                                <thead class="thead-light">
                                                                    <tr>
                                                                        <th><input type="checkbox" class="chooseall"></th>
                                                                        <th>Product</th>
                                                                        <th>Qty</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    @forelse ($service->serviceProduct as $item)
                                                                        <tr>
                                                                            <td><input type="checkbox"
                                                                                    id="{{ $item->id }}"
                                                                                    class="item"></td>
                                                                            <td>{{ $item->product }}</td>
                                                                            <td>{{ $item->qty }}
                                                                                {{ $item->unit->name }}</td>
                                                                        </tr>
                                                                    @empty
                                                                        <tr>
                                                                            <td colspan="3" class="text-center py-5">
                                                                                <div
                                                                                    class="d-flex flex-column align-items-center">
                                                                                    <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png"
                                                                                        alt="No Data"
                                                                                        style="width: 80px; opacity: 0.5;">
                                                                                    <h5
                                                                                        class="mt-3 text-secondary font-weight-bold">
                                                                                        No Products Found</h5>
                                                                                    <p class="text-muted mb-0">You
                                                                                        haven't
                                                                                        assigned any product yet.<br>
                                                                                        <span class="small">Click
                                                                                            <strong>Assign
                                                                                                product(s)</strong>
                                                                                            to get
                                                                                            started.</span>
                                                                                    </p>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                    @endforelse
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Assign Products -->
                                        <a href="{{ route('service.product.view', $service->id) }}"
                                            class="btn btn-warning btn-sm" title="Assign Products">
                                            <i class="fa-solid fa-plus"></i> Add
                                        </a>

                                        <!-- Edit Modal Trigger -->
                                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                            data-target="#edit-{{ $service->id }}" title="Edit Service">
                                            <i class="fa-solid fa-pen-to-square"></i> Edit
                                        </button>

                                        <!-- Edit Modal -->
                                        <div class="modal fade" id="edit-{{ $service->id }}" tabindex="-1"
                                            role="dialog" aria-labelledby="editLabel{{ $service->product_id }}"
                                            aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <form action="{{ route('service.update', $service->id) }}"
                                                        method="POST">
                                                        @csrf
                                                        @method('PUT')

                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Update service details</h5>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <label for="service">Service</label>
                                                            <input type="text" name="name"
                                                                class="form-control mb-2" value="{{ $service->product }}"
                                                                id="service" required>
                                                            <label for="price">Price</label>
                                                            <input type="number" name="price"
                                                                class="form-control mb-2"
                                                                value="{{ $service->unit[0]->selling }}" id="price"
                                                                required>
                                                            <label for="location">Location</label>
                                                            <select name="location" id="location" class="form-control"
                                                                required>
                                                                <option value="{{ $service->location_id }}">
                                                                    -- {{ $service->location->name }} --
                                                                </option>
                                                                @foreach ($sellings as $selling)
                                                                    <option value="{{ $selling->location_id }}">
                                                                        -- {{ $selling->location->name }} --
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button class="btn btn-primary btn-block">Update</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Delete Button -->
                                        <button class="btn btn-danger btn-sm delete" id="{{ $service->id }}"
                                            title="Delete Service">
                                            <i class="fa fa-trash-alt"></i> Delete
                                            <form action="{{ route('service.delete', $service->id) }}" method="GET"
                                                id="deleteform{{ $service->id }}">
                                            </form>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png"
                                            alt="No Service" style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Services Found</h5>
                                        <p class="text-muted mb-0">You haven't added any services yet.<br>
                                            <span class="small">Click <strong>Register Service</strong> to get
                                                started.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                    <tfoot class="thead-light">
                        <tr>
                            <th><input type="checkbox" id="checkall"></th>
                            <th>#</th>
                            <th>Service</th>
                            <th>Price</th>
                            <th>Location</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    @section('scripts')
        <script>
            $(document).ready(function() {
                $("#example1").DataTable();

                $("#checkall").on("click", function() {
                    if ($(this).is(':checked', true)) {
                        $(".selected").prop('checked', true);
                    } else {
                        $(".selected").prop('checked', false);
                    }
                });

                $("#deleteall").on("click", function() {
                    var selected = [];
                    $(".selected:checked").each(function() {
                        selected.push($(this).attr("id"));
                    });

                    if (selected.length == 0) {

                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'Select atleast one item!!',
                        });

                    } else {

                        Swal.fire({
                            title: 'Are you sure?',
                            text: "You won't be able to revert this!",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: 'Yes, delete!'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajax({
                                    url: "{{ route('services.bulk.delete') }}",
                                    method: "GET",
                                    data: {
                                        'ids': selected
                                    },
                                    success: function(data) {
                                        window.location.reload(true);
                                    }
                                });

                                $(document).ready(function() {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Success!',
                                        text: '{{ session('success') }}',
                                        background: '#e6ffed',
                                        showConfirmButton: false,
                                        timer: 2500,
                                        timerProgressBar: true,
                                        position: 'top-end',
                                        toast: true,
                                        customClass: {
                                            popup: 'swal2-border-radius'
                                        }
                                    });
                                });
                            }
                        });
                    }
                });

                $(".delete").on("click", function() {
                    var id = $(this).attr("id");

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.getElementById("deleteform" + id).submit();
                        }
                    })
                });

                $(".chooseall").on("click", function() {
                    if ($(this).is(':checked', true)) {
                        $(".item").prop('checked', true);
                    } else {
                        $(".item").prop('checked', false);
                    }
                });

                $(".eliminate").on("click", function() {
                    var chosen = [];
                    $(".item:checked").each(function() {
                        chosen.push($(this).attr("id"));
                    });

                    if (chosen.length == 0) {

                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'Select atleast one item!!',
                        });

                    } else {

                        Swal.fire({
                            title: 'Are you sure?',
                            text: "You won't be able to revert this!",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: 'Yes, delete!'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajax({
                                    url: "{{ route('service.product.bulk.delete') }}",
                                    method: "GET",
                                    data: {
                                        'ids': chosen
                                    },
                                    success: function(data) {
                                        window.location.reload(true);
                                    }
                                });

                                $(document).ready(function() {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Success!',
                                        text: '{{ session('success') }}',
                                        background: '#e6ffed',
                                        showConfirmButton: false,
                                        timer: 2500,
                                        timerProgressBar: true,
                                        position: 'top-end',
                                        toast: true,
                                        customClass: {
                                            popup: 'swal2-border-radius'
                                        }
                                    });
                                });
                            }
                        });
                    }
                });
            });
        </script>
    @endsection

@endsection
