@extends('layouts.master')

@section('content')
    <div class="card table-responsive">
        <div class="card-header">
            <form action="{{ route('settlement.report') }}" method="get" class="was-validated">
                <table>
                    <tbody>
                        <tr>
                            <td>
                                <select name="area" id="area" class="form-control" style="text-align: center" required>
                                    <option disabled selected value="">-- Choose Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->id }}">-- {{ $selling->location->name }} --</option>
                                    @endforeach
                                </select>
                            </td>

                            <td>
                                <select name="type" id="type" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected value="">-- Select Duration --</option>
                                    <option value="today">-- Today --</option>
                                    <option value="set date">-- Set Date --</option>
                                </select>
                            </td>

                            <td><input type="date" name="start" id="start" class="form-control"
                                    style="text-align: center; display:none" required></td>
                            <td><input type="date" name="end" id="end" class="form-control"
                                    style="text-align: center; display:none" required></td>

                            <td> <button type="submit" id="search" class="btn btn-primary">
                                    <i class="fa-solid fa-search"></i> Search</button></td>
                        </tr>
                    </tbody>
                </table>
            </form>
        </div>

        <div class="card-body">
            <table id="example1" class="table table-striped table-bordered table-hover text-center table-sm">
                <thead class="thead-dark">
                    <tr>
                        <th style="width: 25%">Heading</th>
                        <th>Description</th>
                    </tr>
                </thead>

                <tbody id="tbody">
                    <tr>
                        <td style="font-weight: bold; font-size: 1.2em">Total Sales (Credit & Cash)</td>
                        <td style="font-size: 1.2em; font-weight: bold">{{ number_format($totalSale) }}</td>
                    </tr>

                    <tr class="bg-light">
                        <td style="font-weight: bold; font-size: 1.2em">Cash Sales</td> {{--  --}}
                        <td style="font-size: 1.2em; font-weight: bold">- {{ number_format($totalCashSale) }}</td>
                    </tr>

                    <tr>
                        <td style="font-weight: bold; font-size: 1.2em">-- Credit Sales --</td> {{-- DIFFERENCE BETWEEN TOTAL SALES & CREDITT SALE --}}
                        <td style="font-size: 1.2em; font-weight: bold">
                            <a href="#" data-toggle="modal" data-target="#creditSalesModal">
                                -- {{ number_format($totalSale - $totalCashSale) }} --
                            </a>

                            <!-- Modal -->
                            <div class="modal fade" id="creditSalesModal" tabindex="-1" role="dialog"
                                aria-labelledby="creditSalesModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-lg" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="creditSalesModalLabel">Customers With Pending Debts
                                            </h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <table class="table table-stripped table-hover">
                                                <thead class="thead-dark">
                                                    <th style="width: 5%" class="text-center">#</th>
                                                    <th class="text-center">Customer</th>
                                                    <th style="width: 13%" class="text-center">Amount</th>
                                                </thead>

                                                <tbody>
                                                    @foreach ($pendingDebts as $debt)
                                                        @php
                                                            $totalPendingDebt += $debt->net; // Accumulate the total pending debt
                                                        @endphp
                                                        <tr>
                                                            <td class="text-center">{{ $loop->iteration }}</td>
                                                            <td>{{ $debt->customer->name }}</td>
                                                            <td class="text-right">
                                                                {{ number_format($debt->net, 2) }}
                                                            </td>
                                                            <!-- Display the correct field -->
                                                        </tr>
                                                    @endforeach
                                                </tbody>

                                                @if ($pendingDebts->count() > 0)
                                                    <tfoot>
                                                        <tr>
                                                            <td colspan="2" class="text-right font-weight-bold">Total
                                                            </td>
                                                            <td class="text-right font-weight-bold">
                                                                {{ number_format($totalPendingDebt, 2) }}</td>
                                                        </tr>
                                                    </tfoot>
                                                @endif

                                            </table>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-dismiss="modal">Close</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <td style="font-weight: bold; font-size: 1.2em">Cash Sales</td>
                        <td style="font-size: 1.2em; font-weight: bold">{{ number_format($totalCashSale) }}</td>
                    </tr>

                    <tr class="bg-light">
                        <td style="font-weight: bold; font-size: 1.2em">Expenses</td>
                        <td style="font-size: 1.2em; font-weight: bold">- {{ number_format($totalExpenses) }}</td>
                    </tr>

                    <tr>
                        <td style="font-weight: bold; font-size: 1.2em">Net Sales</td> {{-- DIFFERENCE BETWEEN CASH SALES & EXPENES --}}
                        <td style="font-size: 1.2em; font-weight: bold">+
                            {{ number_format($totalCashSale - $totalExpenses) }}</td>
                    </tr>

                    <tr class="bg-light">
                        <td style="font-weight: bold; font-size: 1.2em">-- Credit Collection --</td>
                        {{-- IF CLICKED DISPLAY THE CUSTOMER WHO PAID FOR THAT PARTICULAR DURATION --}}
                        <td style="font-size: 1.2em; font-weight: bold">
                            <a href="#" data-toggle="modal" data-target="#netSalesModal">
                                -- {{ number_format($totalCollection) }} --
                            </a>

                            <!-- Modal -->
                            <div class="modal fade" id="netSalesModal" tabindex="-1" role="dialog"
                                aria-labelledby="netSalesModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-lg" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="netSalesModalLabel">Credit Collection</h5>
                                            <button type="button" class="close" data-dismiss="modal"
                                                aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>

                                        <div class="modal-body">
                                            @php
                                                // Initialize an array to hold the total amounts per account
                                                $accountTotals = [];
                                            @endphp

                                            <table class="table table-stripped table-hover">
                                                <thead class="thead-dark">
                                                    <th style="width: 5%" class="text-center">#</th>
                                                    <th class="text-center">Customer</th>
                                                    <th style="width: 40%" class="text-center">Amount</th>
                                                </thead>

                                                <tbody>
                                                    @foreach ($paidDebts as $paid)
                                                        @php
                                                            // Accumulate the total paid debt
                                                            $totalPaidDebt += $paid->paid;

                                                            // Accumulate the total for each account
                                                            if ($paid->account != null) {
                                                                if (!isset($accountTotals[$paid->account->id])) {
                                                                    $accountTotals[$paid->account->id] = [
                                                                        'name' => $paid->account->name,
                                                                        'type' => $paid->account->type,
                                                                        'total' => 0,
                                                                    ];
                                                                }
                                                                $accountTotals[$paid->account->id]['total'] +=
                                                                    $paid->paid;
                                                            }
                                                        @endphp

                                                        <tr>
                                                            <td class="text-center">{{ $loop->iteration }}</td>
                                                            <td>{{ $paid->customer->name }}</td>
                                                            <td class="text-right">
                                                                {{ number_format($paid->paid, 2) }} -
                                                                {{ $paid->account ? $paid->account->type : 'N/A' }}
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>

                                                @if ($paidDebts->count() > 0)
                                                    <tfoot>
                                                        <tr>
                                                            <td colspan="2" class="text-right font-weight-bold">Total
                                                            </td>
                                                            <td class="text-right font-weight-bold">
                                                                {{ number_format($totalPaidDebt, 2) }}</td>
                                                        </tr>
                                                    </tfoot>
                                                @endif
                                            </table>

                                            <!-- Second Table: Account-wise Totals -->
                                            <table class="table table-stripped table-hover">
                                                <thead class="thead-dark">
                                                    <th style="width: 5%" class="text-center">#</th>
                                                    <th class="text-center">Account</th>
                                                    <th style="width: 13%" class="text-center">Amount</th>
                                                </thead>

                                                <tbody>
                                                    @foreach ($accountTotals as $index => $account)
                                                        <tr>
                                                            <td class="text-center">{{ $loop->iteration }}</td>
                                                            <td> {{ $account['type'] }} - {{ $account['name'] }}</td>
                                                            <td class="text-right">
                                                                {{ number_format($account['total'], 2) }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>

                                                @if ($paidDebts->count() > 0)
                                                    <tfoot>
                                                        <tr>
                                                            <td colspan="2" class="text-right font-weight-bold">Total
                                                            </td>
                                                            <td class="text-right font-weight-bold">
                                                                {{ number_format($totalPaidDebt, 2) }}</td>
                                                        </tr>
                                                    </tfoot>
                                                @endif
                                            </table>
                                        </div>

                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-dismiss="modal">Close</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td> {{-- IF CLICKED DISPLAY THE THE CUSTOMER DEBTS  --}}
                    </tr>

                    <tr class="bg-green">
                        <td style="font-weight: bold; font-size: 1.2em">Final Balance</td>
                        <td style="font-size: 1.2em; font-weight: bold">
                            {{ number_format($totalCollection + ($totalCashSale - $totalExpenses)) }}</td>
                    </tr>
                </tbody>

                <tfoot>
                    <th colspan="2">
                        
                    </th>
                </tfoot>
            </table>
        </div>
        <div class="card-footer text-center">
            <button type="button" id="downloadPDF" class="btn btn-primary">
                <i class="fa fa-file-pdf"></i> Download PDF </button>
        </div>
    </div>

@section('scripts')
    <script>
        //global variable
        var type = "";
        var start = "";
        var end = "";

        $("#start").on("change", function() {
            start = $(this).val();
        });

        $("#end").on("change", function() {
            end = $(this).val();
        });

        $("#type").on("change", function() {
            type = $(this).val();

            if (type == "today") {
                $("#start").attr("required", false).fadeOut("slow");
                $("#end").attr("required", false).fadeOut("slow");

            } else if (type == "set date") {
                $("#start").attr("required", true).fadeIn("slow");
                $("#end").attr("required", false).fadeOut("slow");

            } else if (type == "set duration") {
                $("#start").attr("required", true).fadeIn("slow");
                $("#end").attr("required", true).fadeIn("slow");
            }
        });

        document.getElementById('downloadPDF').addEventListener('click', function() {
            const {
                jsPDF
            } = window.jspdf;
            const doc = new jsPDF();

            // Capture the table content
            html2canvas(document.querySelector("#example1")).then(canvas => {
                const imgData = canvas.toDataURL('image/png');
                const imgWidth = 190; // Set the width of the image
                const pageHeight = doc.internal.pageSize.height;
                const imgHeight = canvas.height * imgWidth / canvas.width;
                let position = 0;

                // Add image (table content) to PDF
                doc.addImage(imgData, 'PNG', 10, position, imgWidth, imgHeight);
                doc.save('table.pdf');
            });
        });
    </script>
@endsection

@endsection
