<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'PT Sans', sans-serif;
        }

        @page {
            size: 2.8in 11in;
            margin-top: 0cm;
            margin-left: 0cm;
            margin-right: 0cm;
        }

        table {
            width: 100%;
        }

        tr {
            width: 100%;

        }

        h1 {
            text-align: center;
            vertical-align: middle;
        }

        #logo {
            width: 60%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            padding: 5px;
            margin: 2px;
            display: block;
            margin: 0 auto;
        }

        header {
            width: 100%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            vertical-align: middle;
        }

        .items thead {
            text-align: center;
        }

        .center-align {
            text-align: center;
        }

        .bill-details td {
            font-size: 12px;
        }

        .receipt {
            font-size: medium;
        }

        .items .heading {
            font-size: 12.5px;
            text-transform: uppercase;
            border-top: 1px solid black;
            margin-bottom: 4px;
            border-bottom: 1px solid black;
            vertical-align: middle;
        }

        .items thead tr th:first-child,
        .items tbody tr td:first-child {
            width: 47%;
            min-width: 47%;
            max-width: 47%;
            word-break: break-all;
            text-align: left;
        }

        .items td {
            font-size: 12px;
            text-align: right;
            vertical-align: bottom;
        }

        .price::before {
            {{-- content: "\20B9"; --}} font-family: Arial;
            text-align: right;
        }

        .sum-up {
            text-align: right !important;
        }

        .total {
            font-size: 13px;
            border-top: 1px dashed black !important;
            border-bottom: 1px dashed black !important;
        }

        .total.text,
        .total.price {
            text-align: right;
        }

        {{-- .total.price::before {
            content: "\20B9";
        } --}}

        .line {
            border-top: 1px solid black !important;
        }

        .heading.rate {
            width: 20%;
        }

        .heading.amount {
            width: 25%;
        }

        .heading.qty {
            width: 5%
        }

        p {
            padding: 1px;
            margin: 0;
        }

        section,
        footer {
            font-size: 12px;
        }
    </style>
</head>

<body>

    <header>
        <div id="logo" class="media" data-src="logo.png" src="./logo.png"></div>

    </header>

    @php
        $profile = App\Models\BusinessProfile::all();
       // $sale = App\Models\Sale::find($id);
    @endphp

    <center>
        @foreach ($profile as $data)
            <h3>{{ $data->name }} </h3>
            <h4>{{ $data->address }} ({{ $data->phone }}) </h4>
        @endforeach

        {{--  <h4>{{ $sale->created_at }}</h4>
        <h4>Reciept #: 00{{ $sale->id }}</h4>
        <h4>{{ $sale->customer }}</h4>  --}}
    </center>

    @php
        //$sale = App\Models\Sale::find($id);
        //$items = App\Models\SoldItem::where('sale_id', $id)->get();
        $sum = 0;
    @endphp

    <table class="items">
        <thead>
            <tr>
                <th class="heading name">Item</th>
                <th class="heading qty">Qty</th>
                <th class="heading rate">@ (Tshs)</th>
                <th class="heading amount">Amount</th>
            </tr>
        </thead>

        <tbody id="tbody">

            @foreach ($sales as $sale)
                @php
                    $sum += $sale->amount;
                @endphp

                <tr>
                    <td>{{ $sale->product }}</td>
                    <td>{{ $sale->qty }} ({{ $sale->unit }})</td>
                    <td>{{ $sale->price }}</td>
                    <td>{{ $sale->amount }}</td>
                </tr>
            @endforeach

            <tr>
                <td colspan="3" class="sum-up line">Sub total</td>
                <td class="line price">{{ $sum }}</td>
            </tr>
            <tr>
                <td colspan="3" class="sum-up">Disc</td>
                @if ($sale->discount)
                    <td class="price">-{{ $sale->discount }}</td>
                @else
                    <td class="price">-0</td>
                @endif

            </tr>
            <tr>
                <td colspan="3" class="sum-up">Net</td>
                <td class="price">{{ $sale->net }}</td>
            </tr>

        </tbody>
    </table>
    <section>

        <p style="text-align:center">
            Thank you for your visit!
        </p>
    </section>
    <footer style="text-align:center">
        <p>Powered by DukaMax business software</p>
        <p>www.dukamax.online</p>
    </footer>
</body>

<script>
   window.print();
</script>

</html>
