@extends('layouts.master')

@section('content')

    <form action="{{ route('fetch.balance.stock.report') }}" onsubmit="showSpinner()" method="get" class="was-validated">
        <div class="card">
            <div class="card-header">
                <table>
                    <thead>
                        <th> <select name="location" id="location" class="form-control text-center" required>
                                <option disabled selected value="">-- Choose Location --</option>
                                @foreach ($sellings as $selling)
                                    <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                    </option>
                                    @foreach ($selling->storage as $storage)
                                        <option value="{{ $storage->location_id }}">-- {{ $storage->location->name }} --
                                        </option>
                                    @endforeach
                                @endforeach
                            </select></th>
                        <th>
                            <button type="submit" id="search" class="btn btn-primary">
                                <i class="fa-solid fa-search"></i> Search
                            </button>
                        </th>
                    </thead>
                </table>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="example1" class="table table-bordered table-hover table-striped align-middle text-center">
                        <thead class="thead-dark">
                            <tr>
                                <th style="width: 5%">#</th>
                                <th style="width: 40%">Product</th>
                                <th style="width: 25%">Category</th>
                                @if (!$area)
                                    <th style="width: 30%">Location</th>
                                @else
                                    <th style="width: 30%">{{ $area->name }}</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $products = $products ?? collect(); // Ensure $products is a collection
                            @endphp

                            @foreach ($products as $product)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td class="text-left">
                                        <strong>{{ $product->product }}</strong>
                                        @if (!empty($product->description))
                                            <br><small class="text-muted">{{ $product->description }}</small>
                                        @endif
                                    </td>
                                    <td>{{ $product->category->name ?? '-' }}</td>
                                    <td>
                                        @php
                                            $stock = $product->stock->where('location_id', $locationId)->first();
                                            $display = '0';

                                            if ($stock && $product->unit) {
                                                $units = $product->unit
                                                    ->where('location_id', $locationId)
                                                    ->where('unit_id', '!=', null)
                                                    ->sortByDesc('unit_cont');

                                                // Safely cast stock qty to float
                                                $qty = is_numeric($stock->qty) ? floatval($stock->qty) : 0.0;

                                                $answer = $units
                                                    ->flatMap(function ($unit) use (&$qty) {
                                                        // Safely cast unit_cont to float
                                                        $current_cont = is_numeric($unit->unit_cont)
                                                            ? floatval($unit->unit_cont)
                                                            : 0.0;

                                                        if ($current_cont > 0 && $qty > 0) {
                                                            // Use floor for whole number of units
                                                            $current_qty = floor($qty / $current_cont);

                                                            // Calculate remainder with fmod for floats
                                                            $qty = fmod($qty, $current_cont);

                                                            return $current_qty
                                                                ? [$current_qty . ' ' . $unit->unit->name]
                                                                : [];
                                                        }

                                                        return [];
                                                    })
                                                    ->implode(', ');

                                                $display = $answer ?: '0';
                                            }
                                        @endphp
                                        <span class="badge bg-info text-dark px-3 py-2">{{ $display }}</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Product</th>
                                <th>Category</th>
                                @if (!$area)
                                    <th>Location</th>
                                @else
                                    <th>{{ $area->name }}</th>
                                @endif
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </form>

@section('scripts')
    <script>
        $(function() {

            $("#example1").DataTable({
                "pageLength": 250,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

            $("#type").on("change", function() {
                var change = $(this).val();

                if (change == "opening & closing") {
                    $("#start").fadeIn("slow");
                    $("#end").fadeIn("slow");
                } else {
                    $("#start").fadeOut("slow");
                    $("#end").fadeOut("slow");
                }
            });

        });
    </script>
@endsection

@endsection
