@extends('layouts.master')

@section('content')

    <form action="{{ route('store.stock.transfer') }}" method="post">
        @csrf

        <div class="card table-responsive">
            <div class="card-header">
                <table>
                    <tbody>
                        <td>
                            <input type="date" name="date" value="{{ date('Y-m-d') }}" class="form-control">
                        </td>

                        <td>
                            @if ($sellingCount > 1)
                                <select name="area" id="area" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected value="">-- Choose Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                        </option>
                                    @endforeach
                                </select>
                            @else
                                <input type="hidden" name="area" id="area" class="form-control"
                                    value="{{ $sellings[0]->location_id }}">

                                <input type="text" name="area-copy" id="area-copy" class="form-control"
                                    value="{{ $sellings[0]->location->name }}" style="text-align: center" readonly>
                            @endif
                        </td>
                    </tbody>
                </table>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover align-middle shadow-sm" style="background: #fff;">
                        <thead class="thead-dark text-center" style="background: #007bff; color: #fff;">
                            <tr>
                                <th style="width: 3%">#</th>
                                <th style="width: 15%">From</th>
                                <th>Product</th>
                                <th style="width: 10%">Batch.No</th>
                                <th style="width: 10%">Unit</th>
                                <th style="width: 15%">To</th>
                                <th style="width: 10%">Qty</th>
                                <th>
                                    <button type="button" class="btn btn-success btn-sm" id="addRow" title="Add Row">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </th>
                            </tr>
                        </thead>
                        <tbody id="tbody">
                            <!-- Dynamic rows will be appended here -->
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="9" class="text-center">
                                    <center>
                                        <button type="submit" class="btn btn-primary"><i class="fas fa-paper-plane"></i>
                                            Save transfer</button>
                                    </center>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </form>

@section('scripts')
    <script>
        $(document).ready(function() {
            var ajaxResponse = []; // store AJAX response globally
            var index = 1;

            // Add Row
            $("#addRow").on("click", function() {
                let tr = `
                                <tr id="tr${index}" class="text-center">
                                    <td>${index}</td>
                                    <td>
                                        <select name="from[]" id="from_location${index}" class="form-control location" required>
                                            <option disabled selected value="">-- Select Location --</option>
                                            @foreach ($sellings as $selling)
                                                <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --</option>
                                                @foreach ($selling->storage as $storage)
                                                    <option value="{{ $storage->location_id }}">-- {{ $storage->location->name }} --</option>
                                                @endforeach
                                            @endforeach
                                        </select>
                                    </td>
                                    <td>
                                        <input type="hidden" name="product_id[]" id="product_id${index}" class="form-control product_id">
                                        <input type="text" name="product_name[]" id="search${index}" class="form-control search" placeholder="Search by product name or barcode.." required>
                                        <div id="list${index}" style="display:none; position:absolute; z-index:10; width:27%; border-radius:0 0 0.5rem 0.5rem; box-shadow:0 4px 12px rgba(0,0,0,0.12);" class="bg-white border border-primary">
                                            <ol id="results${index}" class="list-group list-group-flush"></ol>
                                        </div>
                                    </td>
                                     <td  style="min-width: 10%;">
                                        <input type="text" name="batch_no[]" id="batch${index}" class="form-control batch" readonly>
                                    </td>
                                    <td>
                                        <select name="unit_id[]" id="unit${index}" class="form-control unit" required></select>
                                        <input type="hidden" name="cont[]" id="cont${index}" class="form-control cont" readonly>
                                        <input type="hidden" name="price[]" id="price${index}" class="form-control price" readonly>
                                    </td>
                                    <td>
                                        <select name="to[]" id="to_location${index}" class="form-control" required>
                                            <option disabled selected value="">-- Select Location --</option>
                                              @foreach ($sellings as $selling)
                                                   <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --</option>
                                                @foreach ($selling->storage as $storage)
                                                    <option value="{{ $storage->location_id }}">-- {{ $storage->location->name }} --</option>
                                                @endforeach
                                            @endforeach
                                        </select>
                                    </td>
                                    <td>
                                        <input type="number" name="qty[]" id="qty${index}" class="form-control qty" min="1" value="1" required>
                                    </td>
                                    <td>
                                        <button type="button" id="${index}" class="btn btn-danger removeRow"><i class="fas fa-trash-alt"></i></button>
                                    </td>
                                </tr>
                            `;
                $("#tbody").append(tr);
                index++;
            });

            // Remove row
            $(document).on("click", ".removeRow", function() {
                $(this).closest("tr").remove();
            });

            // Search products
            $(document).on("keyup", ".search", function() {
                let query = $(this).val();
                let rowId = $(this).attr('id').replace("search", "");
                let locationId = $("#from_location" + rowId).val();

                if (!query) return;

                $.ajax({
                    url: "{{ route('get.location.product') }}",
                    method: "GET",
                    data: {
                        query,
                        locationId
                    },
                    success: function(data) {
                        ajaxResponse = data; // store response globally
                        let resultsContainer = $("#results" + rowId);
                        resultsContainer.empty();
                        $("#list" + rowId).fadeIn("slow");

                        if (data.length === 0) {
                            resultsContainer.append(
                                '<li><button type="button" class="btn btn-outline-secondary form-control items">No suggestions..</button></li>'
                            );
                            return;
                        }

                        data.forEach((product, i) => {
                            let resultsContainer = $("#results" + rowId);

                            let batchSelectHtml = '';
                            if (product.batches && product.batches.length > 0) {
                                // products with batches
                                batchSelectHtml = `<select style="width: 30%" class="batch-select form-control" data-index="${i}" data-row="${rowId}">
                                <option value="" disabled selected>-- Batch --</option>`;
                                product.batches.forEach(batch => {
                                    batchSelectHtml +=
                                        `<option value="${batch.batch_no}" data-qty="${batch.qty}" data-exp="${batch.exp}">${batch.batch_no} | Stock: ${batch.qty} ${product.unit[0]?.name ?? ''}</option>`;
                                });
                                batchSelectHtml += `</select>`;
                            }

                            // Every product gets a clickable button
                            resultsContainer.append(`
                                                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                                                            <button type="button" class="btn btn-link items" 
                                                                                    data-index="${i}" 
                                                                                    data-row="${rowId}">
                                                                                ${product.product} | Stock: ${product.totalQty} ${product.unit[0]?.name ?? ''}
                                                                            </button>
                                                                            ${batchSelectHtml}
                                                                        </li>
                                                                    `);
                        });
                    }

                });
            });

            // Click on product item
            $(document).on("click", ".items", function() {
                let rowId = $(this).data("row");
                let productIndex = $(this).data("index");
                let product = ajaxResponse[productIndex];

                // Fill product info
                $("#search" + rowId).val(product.product);
                $("#id" + rowId).val(product.id);

                // Fill units
                let unitSelect = $("#unit" + rowId);
                unitSelect.empty().append('<option value="">-- Unit --</option>');
                if (product.unit?.length > 0) {
                    product.unit.forEach((val, i) => {
                        unitSelect.append(
                            `<option value="${val.id}" ${i === 0 ? "selected" : ""}>${val.name}</option>`
                        );
                    });
                    $("#cont" + rowId).val(product.unit[0].unit_cont);
                    $("#price" + rowId).val(product.unit[0].selling);
                }

                // Batch
                $("#batch" + rowId).val("Null"); // no batch selected

                $("#list" + rowId).fadeOut("slow");
            });

            // Handle batch selection
            $(document).on("change", ".batch-select", function() {
                let rowId = $(this).data("row");
                let productIndex = $(this).data("index");
                let product = ajaxResponse[productIndex];
                let selectedBatch = $(this).find("option:selected");

                if (!selectedBatch.val()) return;

                // 1️⃣ Hide search results
                $("#list" + rowId).fadeOut("slow");

                // 2️⃣ Populate fields with selected batch details
                $("#search" + rowId).val(product.product);
                $("#product_id" + rowId).val(product.id);
                $("#batch" + rowId).val(selectedBatch.val());

                // Populate units
                let unitSelect = $("#unit" + rowId);
                unitSelect.empty().append('<option value="">-- Unit --</option>');
                if (product.unit?.length > 0) {
                    product.unit.forEach((val, i) => {
                        unitSelect.append(
                            `<option value="${val.id}" ${i === 0 ? "selected" : ""}>${val.name}</option>`
                        );
                    });
                    $("#cont" + rowId).val(product.unit[0].unit_cont);
                    $("#price" + rowId).val(product.unit[0].selling);
                }

                // Hide the batch select dropdown
                $(this).addClass("d-none");
            });


            // Unit change
            $(document).on("change", ".unit", function() {
                let rowId = $(this).attr("id").replace("unit", "");
                let unitId = $(this).val();
                let productId = $("#id" + rowId).val();
                let locationId = $("#location" + rowId).val();

                $.ajax({
                    url: "{{ route('unit.details') }}",
                    method: "GET",
                    data: {
                        unitId,
                        productId,
                        locationId
                    },
                    success: function(data) {
                        $("#cont" + rowId).val(data.unit_cont);
                        $("#price" + rowId).val(data.selling);
                    }
                });
            });
        });
    </script>
@endsection

@endsection
