@extends('layouts.master')

@section('content')

    <form action="{{ route('fetch.stock.value.report') }}" onsubmit="showSpinner()" method="get" class="was-validated">
        <div class="card">

            <div class="card-header">
                <table>
                    <tbody>
                        <tr>
                            <td>
                                <select name="location" id="location" class="form-control" style="text-align: center" required>
                                    <option disabled selected value="">-- Choose Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                        </option>
                                        @foreach ($selling->storage as $storage)
                                            <option value="{{ $storage->location_id }}">
                                                -- {{ $storage->location->name }} --
                                            </option>
                                        @endforeach
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <button type="submit" id="search" class="btn btn-primary">
                                    <i class="fa-solid fa-search"></i> Search
                                </button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="example1" class="table table-bordered table-striped table-hover align-middle text-center">
                        <thead class="thead-dark">
                            <tr>
                                <th>#</th>
                                <th>Product</th>
                                <th>Buying Price</th>
                                @if ($area == '')
                                    <th>Location</th>
                                @else
                                    <th>{{ $area->name }}</th>
                                @endif
                                <th>Buying Value</th>
                                <th>Selling Price</th>
                                @if ($area == '')
                                    <th>Location</th>
                                @else
                                    <th>{{ $area->name }}</th>
                                @endif
                                <th>Selling Value</th>
                                <th>Profit Value</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $total_buying_value = 0;
                                $total_selling_value = 0;
                                $profit_value = 0;
                            @endphp

                            @foreach ($products as $product)
                                @php
                                    $stock = App\Models\Stock::where('product_id', $product->id)
                                        ->where('location_id', $locationId)
                                        ->first();

                                    $unit = App\Models\UnitAssigned::where('product_id', $product->id)
                                        ->whereNotNull('unit_id')
                                        ->where('location_id', $locationId)
                                        ->first();

                                    // --- Sanitize all numeric values ---
                                    $stock_qty = $stock && is_numeric($stock->qty) ? floatval($stock->qty) : 0.0;
                                    $unit_cont =
                                        $unit && is_numeric($unit->unit_cont) ? floatval($unit->unit_cont) : 0.0;
                                    $buying = is_numeric($product->buying) ? floatval($product->buying) : 0.0;
                                    $selling = $unit && is_numeric($unit->selling) ? floatval($unit->selling) : 0.0;

                                    // --- Calculations ---
                                    $buying_value = $buying * $unit_cont * $stock_qty;
                                    $selling_value = $selling * $unit_cont * $stock_qty;

                                    $total_buying_value += $buying_value;
                                    $total_selling_value += $selling_value;
                                    $profit_value += $selling_value - $buying_value;
                                @endphp

                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td class="text-left">
                                        <strong>{{ $product->product }}</strong>
                                        @if ($product->category)
                                            <br><small class="text-muted">{{ $product->category->name }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-info">{{ number_format($product->buying, 2) }}</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary">
                                            {{ $unit ? $unit->unit->name : '-' }} ({{ $stock_qty }})
                                        </span>
                                    </td>
                                    <td>
                                        <span class="text-primary fw-bold">{{ number_format($buying_value, 2) }}</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-success">
                                            {{ $unit ? number_format($unit->selling, 2) : '-' }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary">
                                            {{ $unit ? $unit->unit->name : '-' }} ({{ $stock_qty }})
                                        </span>
                                    </td>
                                    <td>
                                        <span class="text-success fw-bold">{{ number_format($selling_value, 2) }}</span>
                                    </td>
                                    <td>
                                        <span
                                            class="fw-bold {{ $selling_value - $buying_value < 0 ? 'bg-warning text-dark px-2 rounded' : 'text-success' }}">
                                            {{ number_format($selling_value - $buying_value, 2) }}
                                        </span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="bg-light">
                            <tr>
                                <th colspan="4" class="text-end">Total Capital:</th>
                                <th>
                                    <h5 class="text-primary mb-0">{{ number_format($total_buying_value, 2) }}</h5>
                                </th>
                                <th colspan="2" class="text-end">Total Sales:</th>
                                <th>
                                    <h5 class="text-success mb-0">{{ number_format($total_selling_value, 2) }}</h5>
                                </th>
                                <th>
                                    <h5 class="mb-0 {{ $profit_value < 0 ? 'text-warning' : 'text-success' }}">
                                        {{ number_format($profit_value, 2) }}
                                    </h5>
                                </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </form>

@section('scripts')
    <script>
        $(function() {

            $("#example1").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

            $("#type").on("change", function() {
                var change = $(this).val();

                if (change == "opening & closing") {
                    $("#start").fadeIn("slow");
                    $("#end").fadeIn("slow");
                } else {
                    $("#start").fadeOut("slow");
                    $("#end").fadeOut("slow");
                }
            });

        });
    </script>
@endsection

@endsection
