@extends('layouts.master')

@section('content')
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        /* ===== Table Area Container ===== */
        #table-area {
            width: 100%;
            height: 600px;
            position: relative;
            border: 1px solid #ccc;
            background: linear-gradient(135deg, #f9f9f9, #e9ecef);
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }

        /* ===== Table Wrapper ===== */
        .table-wrapper {
            position: absolute;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
            cursor: pointer;
            transition: transform 0.3s ease;
        }

        .table-wrapper:hover {
            transform: scale(1.08);
            z-index: 5;
        }

        /* ===== Table Core (Inner Circle) ===== */
        .table-core {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            color: white;
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.2);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .table-wrapper:hover .table-core {
            transform: scale(1.05);
            box-shadow: 0 12px 25px rgba(0, 0, 0, 0.3);
        }

        /* ===== Table Name ===== */
        .table-name {
            font-weight: bold;
            font-size: 0.95rem;
            text-align: center;
            margin-top: 15px;
            color: #333;
            text-shadow: 0 1px 2px rgba(255, 255, 255, 0.6);
        }

        /* ===== Chairs (Icons) ===== */
        .chair {
            position: absolute;
            font-size: 22px;
            color: rgba(0, 0, 0, 0.55);
            text-shadow: 0 1px 2px rgba(255, 255, 255, 0.3);
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .table-wrapper:hover .chair {
            color: rgba(0, 0, 0, 0.8);
            transform: scale(1.15);
        }

        .chair-top {
            top: -25px;
            left: 50%;
            transform: translateX(-50%);
        }

        .chair-bottom {
            bottom: 5px;
            left: 50%;
            transform: translateX(-50%) rotate(180deg);
        }

        .chair-left {
            left: -18px;
            top: 50%;
            transform: translateY(-50%) rotate(-90deg);
        }

        .chair-right {
            right: -18px;
            top: 50%;
            transform: translateY(-50%) rotate(90deg);
        }

        /* ===== Delete Button ===== */
        .delete-table-btn {
            position: absolute;
            top: -12px;
            right: -12px;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            background: white;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }

        .delete-table-btn:hover {
            transform: scale(1.1);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
        }

        /* ===== Wall and Plant Styling ===== */
        .wall.horizontal {
            width: 150px;
            height: 10px;
            background-color: #7f8c8d;
            border-radius: 5px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.2);
        }

        .wall.vertical {
            width: 10px;
            height: 150px;
            background-color: #7f8c8d;
            border-radius: 5px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.2);
        }

        .plant {
            font-size: 26px;
            color: green;
            filter: drop-shadow(0 2px 4px rgba(0, 0, 0, 0.3));
        }

        /* ===== Area Labels ===== */
        .area-label {
            font-weight: bold;
            font-size: 16px;
            background-color: #fff8dc;
            padding: 4px 8px;
            border-radius: 6px;
            border: 1px solid #ccc;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
        }

        /* ===== Card Body Styling ===== */
        .card-body.table-responsive {
            background: linear-gradient(135deg, #141e30, #243b55);
            /* luxury dark gradient */
            border-radius: 16px;
            padding: 25px;
            position: relative;
            overflow: hidden;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.25);
            color: #fff;
        }

        /* Soft glowing overlay */
        .card-body.table-responsive::before {
            content: "";
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.06) 20%, transparent 70%);
            animation: rotateOverlay 40s linear infinite;
            z-index: 0;
        }

        @keyframes rotateOverlay {
            from {
                transform: rotate(0deg);
            }

            to {
                transform: rotate(360deg);
            }
        }

        /* Badge Styling */
        .card-body .badge {
            border-radius: 30px;
            font-size: 0.9rem;
            font-weight: 600;
            padding: 10px 18px;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.25);
            transition: all 0.3s ease-in-out;
            position: relative;
            z-index: 1;
        }

        .card-body .badge:hover {
            transform: translateY(-3px) scale(1.05);
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.4);
        }
    </style>

    <div class="card">
        <div class="card-header">
            <div class="btn-group">
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target=".table">
                    <i class="fa-solid fa-plus"></i> Register New table
                </button>
            </div>

            <div class="modal fade table" tabindex="-1" role="dialog">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Register new table</h5>
                            <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                        </div>
                        <form action="{{ route('table.store') }}" method="post" class="was-validated">
                            @csrf
                            <div class="modal-body">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Table Name</th>
                                            <th>Location</th>
                                            <th><button id="addRow" type="button" class="btn btn-success btn-sm"><i
                                                        class="fa fa-plus"></i></button></th>
                                        </tr>
                                    </thead>
                                    <tbody id="tbody"></tbody>
                                </table>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Register</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body table-responsive">
            <div class="mb-3 d-flex align-items-center gap-3">
                <span class="badge bg-primary px-3 py-2">
                    <i class="fas fa-circle me-1"></i> Free
                </span>
                <span class="badge bg-warning px-3 py-2">
                    <i class="fas fa-circle me-1"></i> Reserved
                </span>
                <span class="badge bg-danger text-dark px-3 py-2">
                    <i class="fas fa-circle me-1"></i> Occupied
                </span>
            </div>

            <div id="table-area">
                <div class="d-flex flex-wrap gap-3 position-relative" style="min-height:500px;">
                    @foreach ($tables as $table)
                        @php
                            $bgClass = match ($table->flag) {
                                'free' => 'bg-primary text-success', // Free
                                'reserved' => 'bg-warning text-warning', // Reserved
                                'occupied' => 'bg-danger text-danger', // Occupied
                                default => '',
                            };
                        @endphp

                        <div class="table-wrapper" data-id="{{ $table->id }}"
                            style="left: {{ $table->pos_x }}px; top: {{ $table->pos_y }}px;">

                            <!-- Chairs -->
                            <div class="chair chair-top"><i class="fas fa-chair"></i></div>
                            <div class="chair chair-bottom"><i class="fas fa-chair"></i></div>
                            <div class="chair chair-left"><i class="fas fa-chair"></i></div>
                            <div class="chair chair-right"><i class="fas fa-chair"></i></div>

                            <!-- Circular Table Core (Colored) -->
                            <div class="table-core {{ $bgClass }}">
                                <i class="fas fa-utensils fa-lg"></i>
                            </div>

                            <!-- Table Name -->
                            <div class="table-name fw-bold mt-2">{{ $table->name }}</div>

                            <!-- Delete Button -->
                            <button class="btn btn-light btn-sm delete-table-btn shadow" data-id="{{ $table->id }}">
                                <i class="fa fa-trash-alt text-danger"></i>
                            </button>
                        </div>
                    @endforeach
                </div>

                @foreach ($walls as $wall)
                    <div class="wall {{ $wall->orientation }}" data-id="{{ $wall->id }}"
                        style="left: {{ $wall->pos_x }}px; top: {{ $wall->pos_y }}px;"></div>
                @endforeach

                @foreach ($plants as $plant)
                    <div class="plant" data-id="{{ $plant->id }}"
                        style="left: {{ $plant->pos_x }}px; top: {{ $plant->pos_y }}px;"><i class="fas fa-leaf"></i></div>
                @endforeach

                @foreach ($areas as $area)
                    <div class="area-label" data-id="{{ $area->id }}"
                        style="left: {{ $area->pos_x }}px; top: {{ $area->pos_y }}px;">{{ $area->name }}</div>
                @endforeach
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(function() {
            $(".table-wrapper, .wall, .plant, .area-label").draggable({
                containment: "#table-area",
                stop: function(event, ui) {
                    let $this = $(this);
                    let id = $this.data("id");
                    let position = ui.position;

                    let type = $this.hasClass("wall") ? 'wall' :
                        $this.hasClass("plant") ? 'plant' :
                        $this.hasClass("area-label") ? 'area' : 'table';

                    // Use the Laravel route helper
                    let url = "{{ route('update.position', ['type' => 'TYPE_PLACEHOLDER']) }}".replace(
                        'TYPE_PLACEHOLDER', type);

                    $.ajax({
                        url: url,
                        type: 'POST',
                        data: {
                            id: id,
                            pos_x: Math.round(position.left), // round to integer
                            pos_y: Math.round(position.top)
                        },
                        // headers: {
                        //     'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        // },
                        success: function(res) {
                            if (res.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Saved!',
                                    text: `${type.charAt(0).toUpperCase() + type.slice(1)} position updated.`,
                                    toast: true,
                                    position: 'top-end',
                                    showConfirmButton: false,
                                    timer: 1500,
                                    timerProgressBar: true
                                });
                            }
                        },
                        error: function(xhr) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: xhr.responseJSON?.error ||
                                    'Failed to save position.'
                            });
                        }
                    });
                }
            });
        });

        let index = 1;
        $("#addRow").on("click", function() {
            let row = `<tr id="tr${index}">
                <td>${index}</td>
                <td><input name="name[]" class="form-control" required></td>
                <td>
                    <select name="location[]" class="form-control" required>
                        <option disabled selected>-- Locations --</option>
                        @foreach ($sellings as $selling)
                            <option value="{{ $selling->id }}">{{ $selling->location->name }}</option>
                        @endforeach
                    </select>
                </td>
                <td><button type="button" class="btn btn-danger removeRow" data-id="${index}"><i class="fa fa-trash-alt"></i></button></td>
            </tr>`;
            $("#tbody").append(row);
            index++;
        });

        $(document).on("click", ".removeRow", function() {
            $("#tr" + $(this).data("id")).remove();
        });

        $(document).on("click", ".delete-table-btn", function() {
            let id = $(this).data("id");
            Swal.fire({
                title: 'Delete table?',
                icon: 'warning',
                showCancelButton: true
            }).then(result => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `/table-destroy/${id}`,
                        type: 'DELETE',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            if (response.success) {
                                $(`.table-wrapper[data-id='${id}']`).remove();
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success!',
                                    html: `<div style="font-size:1.2rem; color:#155724; font-weight:500;">
                                                    {{ session()->get('success') }}
                                                </div>`,
                                    background: '#e6ffed',
                                    showConfirmButton: false,
                                    timer: 2500,
                                    timerProgressBar: true,
                                    position: 'top-end',
                                    toast: true,
                                    customClass: {
                                        popup: 'swal2-border-radius'
                                    }
                                });
                            }
                        },
                        error: function() {
                            Swal.fire('Error', 'Failed to delete table.', 'error');
                        }
                    });
                }
            });
        });
    </script>
@endsection
