@extends('layouts.master')

@section('content')
    <div class="container-fluid">
        @forelse ($groupedItems as $month => $items)
            <div class="card mb-4 shadow-sm">
                <div class="card-header bg-primary text-white">
                   Fast moving Products as per <strong>{{ \Carbon\Carbon::parse($month . '-01')->format('F Y') }}</strong>
                </div>
                <div class="card-body">
                    <table id="top-products" class="table table-bordered table-striped">
                        <thead class="thead-dark">
                            <tr>
                                <th><i class="fas fa-hashtag"></i></th>
                                <th><i class="fas fa-box"></i> Product</th>
                                <th><i class="fas fa-sort-amount-up"></i> Qty Sold</th>
                                <th><i class="fas fa-tag"></i> Price per Unit</th>
                                <th><i class="fas fa-dollar-sign"></i> Total Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($items as $index => $item)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $item->product }}</td>
                                    <td>{{ number_format($item->total_qty_sold) }} {{ $item->unit_name }}</td>
                                    <td>{{ number_format($item->price_per_unit, 2) }}</td>
                                    <td>{{ number_format($item->total_amount, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @empty
            <tr>
                <td colspan="5" class="text-center py-5">
                    <div class="d-flex flex-column align-items-center">
                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                            style="width: 80px; opacity: 0.5;">
                        <h5 class="mt-3 text-secondary font-weight-bold">No Units Found</h5>
                        <p class="text-muted mb-0">You haven't added any Units yet.<br>
                            <span class="small">Click <strong>Register Unit</strong> to get
                                started.</span>
                        </p>
                    </div>
                </td>
            </tr>
        @endforelse
    </div>
  @section('scripts')
        <script type="text/javascript">
            $(document).ready(function() {
                 $("#top-products").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');
            });
        </script>
    @endsection

@endsection

