@extends('layouts.master')

@section('content')

    <form action="{{ route('unload.vehicle.store') }}" method="POST">
        @csrf
        @method('POST')

        <div class="card table-responsive">

            <div class="card-header">
                   <h5>Unload vehicle <i class="fa-solid fa-truck-loading"></i></h5>
            </div>

            <div class="card-body">
                <div class="mb-4">
                    <div class="row align-items-center">
                        <div class="col-md-7 mb-2 mb-md-0">
                            <div class="input-group">
                                <span class="input-group-text bg-primary text-white">
                                    <i class="fas fa-barcode"></i>
                                </span>
                                <input type="search" id="search" class="form-control search"
                                    placeholder="Enter product name or barcode...">
                            </div>
                            <div id="list"
                                style="display:none; position: absolute; z-index: 10; width: 98%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);"
                                class="bg-white border border-primary">
                                <ol id="results" class="list-group list-group-flush"></ol>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="input-group shadow-sm">
                                <span class="input-group-text bg-info text-white">
                                    <i class="fas fa-store"></i>
                                </span>
                                <select name="area" id="area" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected>-- Choose Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <br>

                <div class="row">
                    <div class="col-9">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover align-middle shadow-sm"
                                style="background: #fff;">
                                <thead class="table-secondary text-center align-middle">
                                    <tr>
                                        <th style="width: 20%">Product</th>
                                        <th style="width:10%">Unit</th>
                                        <th style="width:12%">Price</th>
                                        <th style="width: 20%">Qty</th>
                                        <th style="width:12%">Amount</th>
                                        <th style="width:5%">Action</th>
                                    </tr>
                                </thead>

                                <tbody id="tbody">
                                    {{-- Dynamic JS rows --}}
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col">
                        <input type="date" name="date" value="{{ date('Y-m-d') }}" class="form-control"
                            style="text-align: center">

                        <input type="text" name="driver" id="driver" class="form-control" style="text-align: center"
                            placeholder="Driver" readonly>

                        <input type="text" name="salesman" id="salesman" class="form-control" style="text-align: center"
                            placeholder="Salesman" readonly>

                        <input type="number" name="loaded" id="loaded" class="form-control" style="text-align: center"
                            placeholder="loaded value" readonly>

                        <input type="number" name="unloaded" id="unloaded" class="form-control" style="text-align: center"
                            placeholder="Unloaded value" readonly>

                        <input type="number" name="discount" id="discount" class="form-control" style="text-align: center"
                            placeholder="Discount">

                        <input type="number" name="sold" id="sold" class="form-control" style="text-align: center"
                            placeholder="Sold value" readonly>

                        <input type="number" name="paid" id="paid" class="form-control" style="text-align: center"
                            placeholder="Paid" required>

                        <input type="number" name="due" id="due" class="form-control" style="text-align: center"
                            placeholder="Due balance" readonly>

                        <select name="account" id="account" class="form-control" style="text-align: center" required>
                            <option disabled selected value="">-- Account --</option>
                            @foreach ($accounts as $account)
                                <option value="{{ $account->name }}">-- {{ $account->type }} -
                                    {{ $account->selling->location->name }} --</option>
                            @endforeach
                        </select>

                        <select name="location" id="location" class="form-control" style="text-align: center" required>
                            <option disabled selected value="">-- Location --</option>
                            @foreach ($sellings as $selling)
                                @if ($selling->location->status != 'dynamic')
                                    <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                    </option>
                                @endif
                            @endforeach

                            @foreach ($storages as $storage)
                                <option value="{{ $storage->location_id }}">-- {{ $storage->location->name }} --
                                </option>
                            @endforeach
                        </select>

                        <input type="date" name="duedate" id="duedate" class="form-control"
                            style="text-align: center">

                        <select name="notification" id="notification" class="form-control" style="text-align: center">
                            <option disabled selected>-- Notification --</option>
                            <option value="7">-- Week Before --</option>
                            <option value="30">-- Month Before --</option>
                        </select>

                        <br>

                        <button class="btn btn-primary btn-block"><i class="fa fa-paper-plane"></i> Confirm</button>

                        <form action="" method="get">
                            <button class="btn btn-danger btn-block"><i class="fa fa-times"></i> Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </form>

@section('scripts')
    <script>
        $(document).ready(function() {

            $("#success").fadeIn("slow");
            setTimeout(function() {
                $("#success").fadeOut("slow")
            }, 3000);

            $("#location").focus();

            //Global variables
            var index = 0
            var query;
            var vehicle;
            var ajaxResults;
            var productId;
            var total;
            var price;
            var qty;
            var unit;
            var id;

            $("#vehicle").on("change", function() {
                vehicle = $(this).val();

                $.ajax({

                    url: "{{ route('total.value.loaded') }}",
                    method: "GET",
                    data: {
                        'vehicle': vehicle
                    },
                    success: function(data) {
                        $("#driver").val(data.driver);
                        $("#salesman").val(data.salesman);
                        $("#loaded").val(data.total);
                    }
                });

            });

            $("#search").on("keyup", function() {
                var ujumbe = "No suggestion..";
                var query = $(this).val();

                $.ajax({

                    url: "{{ route('get.vehicle.product') }}",
                    method: "get",
                    data: {
                        'query': query,
                        'vehicle': vehicle
                    },

                    success: function(data) {
                        console.log(data);
                        $("#results").empty();
                        ajaxResults = data;
                        console.log(ajaxResults);

                        if (query != "") {
                            if (ajaxResults.length == 0) {
                                $("#list").fadeIn("slow");
                                $("#results").append(
                                    '<li><button type="button" class="btn btn-secondary form-control items">' +
                                    ujumbe + '</button></li>');
                            }

                            for (var i = 0; i < ajaxResults.length; i++) {
                                $("#list").fadeIn("slow");
                                $("#results").append(
                                    '<li><button type="button" class="form-control items btn btn-secondary" id="' +
                                    [i] + '" >' +
                                    ajaxResults[i].product + ' | ' + ajaxResults[i].qty +
                                    ' ' + ajaxResults[i].unit +
                                    '</button></li>');
                            }
                        }
                    }
                });
            });

            $(document).on("click", ".items", function() {
                id = $(this).attr("id");
                var product = $(this).html();
                $("#search").val("");
                $("#list").fadeOut("slow");
                $("#search").focus();

                var units;
                var unitprice;

                for (var i = 0; i < ajaxResults[id].units.length; i++) {
                    units = units + '<option value="' + ajaxResults[id].units[i].unit + '">' + ajaxResults[
                        id].units[i].unit + '</option>';
                    unitprice = ajaxResults[id].units[0].selling;
                }

                var tr =

                    '<tr id="tr' + index + '">' +

                    '<td style="width:10%"><input type="hidden" name="id[]" value="' +
                    ajaxResults[id].id + '" id="id' + index +
                    '" class="form-control id" style="text-align: center" readonly></td>' +

                    '<td style="width:10%"><input type="text" name="product[]" value="' +
                    ajaxResults[id].product + '" id="product' + index +
                    '" class="form-control product" style="text-align: center" readonly></td>' +

                    '<td>' +
                    '<select class="form-control unit" style="text-align: center" name="unit[]" id="unit' +
                    index + '">' + units + '</select>' +
                    '</td>' +

                    '<td><input type="text" value="1" name="cont[]" id="cont' +
                    index +
                    '" class="form-control cont" style="text-align: center" readonly></td>' +

                    '<td><input type="text" name="price[]" value="' + unitprice +
                    '" id="price' +
                    index +
                    '" class="form-control price" style="text-align: center"></td>' +

                    '<td><input type="text" value="1" name="qty[]" id="qty' +
                    index +
                    '" class="form-control qty" style="text-align: center"></td>' +

                    '<td><input type="text" name="amount[]" value="' + unitprice +
                    '" id="amount' +
                    index +
                    '" class="form-control amount" style="text-align: center" readonly></td>' +

                    '<td><button type="button" id="' + index +
                    '" class="btn btn-danger removeRow">-</button></td>' +

                    '</tr>';

                $("#tbody").append(tr);
                index++;
                total();
                net();

                $(".removeRow").on("click", function() {
                    var id = $(this).attr("id");
                    $("#tr" + id).remove();
                    total();
                });

            });

            $(document).on("change", ".unit", function() {
                unit = $(this).val();
                id = $(this).attr("id").replace("unit", "");
                product = $("#product" + id).val();

                $.ajax({
                    url: "{{ route('unit.details') }}",
                    method: "get",
                    data: {
                        'unit': unit,
                        'product': product,
                        'location': vehicle,
                    },
                    success: function(data) {
                        //console.log(data);
                        $("#cont" + id).val(data.unitcont);
                        $("#price" + id).val(data.selling);
                        $("#amount" + id).val(data.selling);
                        total();
                        net();
                    }

                });
            });

            $(document).on("keyup", ".price", function() {
                price = $(this).val();
                id = $(this).attr("id").replace("price", "");
                qty = $("#qty" + id).val();
                $("#amount" + id).val(price * qty);
                total();

                var loaded = Number($("#loaded").val());
                var unloaded = Number($("#unloaded").val());
                var answer = loaded - unloaded;
                sold(loaded, unloaded, answer);

            });

            $(document).on("keyup", ".qty", function() {
                qty = $(this).val();
                id = $(this).attr("id").replace("qty", "");
                price = $("#price" + id).val();
                $("#amount" + id).val(price * qty);
                total();

                var loaded = Number($("#loaded").val());
                var unloaded = Number($("#unloaded").val());
                var answer = loaded - unloaded;
                sold(loaded, unloaded, answer);
            });

            function total() {

                var amount = 0;

                $(".amount").each(function() {
                    amount += Number($(this).val());
                    $("#unloaded").val(amount);

                });

            }

            $("#discount").on("keyup", function() {
                var loaded = Number($("#loaded").val());
                var unloaded = Number($("#unloaded").val());
                var discount = Number($(this).val());
                var answer = loaded - unloaded - discount;
                sold(loaded, unloaded, answer);
            });

            function sold(loaded, unloaded, answer) {
                $("#sold").val(answer);
            }

            $("#paid").on("keyup", function() {

                paid = $(this).val();
                sold = $("#sold").val();

                $("#due").val(sold - paid);

                if (paid == sold) {
                    $("#duedate").attr("required", false).fadeOut("slow");
                    $("#notification").attr("required", false).fadeOut("slow");
                } else {
                    $("#duedate").attr("required", true).fadeIn("slow");
                    $("#notification").attr("required", true).fadeIn("slow");
                }

                if (paid == 0) {
                    $("#account").attr("required", false).fadeOut("slow");
                } else {
                    $("#account").attr("required", true).fadeIn("slow");
                }
            });

            function net() {
                var loaded = $("#loaded").val()
                var unloaded = $("#unloaded").val()
                var answer = loaded - unloaded;
                $("#sold").val(answer);
            }

        });
    </script>
@endsection

@endsection
