@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            <h3 class="card-title">Upcoming resavation</h3>
        </div>

        <div class="card-body">
            <table class="table table-stripped table-hover"
                style="border: 1px solid #dee2e6; border-radius: 5px; box-shadow: 0 2px 4px rgba(0,0,0,0.1), 0 8px 16px rgba(0,0,0,0.1)">
                <thead style="background-color: #f8fafc; border-bottom: 2px solid #dee2e6">
                    <tr>
                        <th>Check-in date</th>
                        <th>Check-out date</th>
                        <th>Customer</th>
                        <th>Phone</th>
                        <th>Room</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody id="tbody">
                    @if ($bookings->count() > 0)
                        @foreach ($bookings as $booking)
                            <tr>
                                <td>{{ $booking->in_date }}</td>
                                <td>{{ $booking->out_date }}</td>
                                <td>{{ $booking->customer }}</td>
                                <td>{{ $booking->phone }}</td>
                                <td>{{ $booking->room->name }}</td>
                                <td>
                                    {{-- View more model --}}
                                    <button type="button" class="btn btn-outline-secondary" data-toggle="modal"
                                        data-target="#view-{{ $booking->id }}">
                                        <i class="fa fa-eye" aria-hidden="true"></i>
                                    </button>

                                    <div class="modal fade" id="view-{{ $booking->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                <div class="modal-header bg-info">
                                                    <h4 class="modal-title text-center text-white">
                                                        Customer booking details
                                                    </h4>
                                                </div>

                                                <div class="modal-body">
                                                    <table class="table table-stripped table-hover">
                                                        <thead>
                                                            <th>Heading</th>
                                                            <th>Description</th>
                                                        </thead>

                                                        <tbody>
                                                            <tr>
                                                                <td>check-in date</td>
                                                                <td>{{ $booking->in_date }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Check-out date </td>
                                                                <td>{{ $booking->out_date }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Customer</td>
                                                                <td>{{ $booking->customer }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Comment</td>
                                                                <td>{{ $booking->comment }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Room</td>
                                                                <td>{{ $booking->room->name }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Price</td>
                                                                <td>{{ number_format($booking->room->price) }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Total amount</td>
                                                                <td>{{ number_format($booking->total) }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Paid amount</td>
                                                                <td>{{ number_format($booking->paid) }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Due balance</td>
                                                                <td>{{ number_format($booking->due) }}</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Checkin button --}}
                                    <button class="btn btn-outline-success checkin" id="{{ $booking->id }}">
                                        <i class="fa fa-check" aria-hidden="true"></i>

                                        <form action="{{ route('booking.checkin', $booking->id) }}" method="POST"
                                            id="checkinform{{ $booking->id }}">
                                            @csrf
                                            @method('POST')
                                        </form>
                                    </button>

                                    {{-- Edit button --}}
                                    <button type="button" class="btn btn-outline-info" data-toggle="modal"
                                        data-target="#edit-{{ $booking->id }}">
                                        <i class="fa-solid fa-pen-to-square fa-lg"></i>
                                    </button>

                                    <div class="modal fade" id="edit-{{ $booking->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <form action="{{ route('booking.update', $booking->id) }}" method="POST"
                                                    class="was-validated">
                                                    @csrf
                                                    @method('PUT')

                                                    <div class="modal-header bg-info">
                                                        <h4 class="modal-title text-center text-white">
                                                            Update Customer Details
                                                        </h4>
                                                    </div>

                                                    <div class="modal-body">
                                                        <label for="in-date">In date</label>
                                                        <input type="date" name="in" id="in-date"
                                                            value="{{ $booking->in_date }}" class="form-control" required>

                                                        <label for="out-date">Out date</label>
                                                        <input type="date" name="out" id="out-date"
                                                            value="{{ $booking->in_date }}" class="form-control" required>

                                                        <label for="room">Room</label>
                                                        <input type="text" name="room" id="room"
                                                            value="{{ $booking->room->name }}" class="form-control"
                                                            readonly>

                                                        <label for="price ">Room Price</label>
                                                        <input type="text" name="price" id="price"
                                                            value="{{ $booking->room->price }}" class="form-control"
                                                            readonly>

                                                        <label for="customer">Customer</label>
                                                        <input type="text" name="customer" id="name"
                                                            class="form-control" value="{{ $booking->customer }}" required>

                                                        <label for="phone">Phone</label>
                                                        <input type="text" name="phone" id="phone"
                                                            class="form-control" value="{{ $booking->phone }}" required>

                                                        <label for="comment">Comment</label>
                                                        <input type="text" name="comment" id="comment"
                                                            value=" {{ $booking->comment }}" class="form-control">

                                                        <label for="paid">Paid amount</label>
                                                        <input type="number" name="paid" id="paid"
                                                            class="form-control" value="{{ $booking->paid }}">

                                                        <div id="account-div" style="display: none">
                                                            <label for="account">Account</label>
                                                            <select name="account" id="account" class="form-control">
                                                                <option disabled selected value="">
                                                                    {{ $booking->in_date }}
                                                                </option>
                                                                @foreach ($accounts as $account)
                                                                    <option value="{{ $account->id }}">
                                                                        {{ $account->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <label for="status">Status</label>
                                                        <select name="status" id="status" class="form-control"
                                                            required>
                                                            <option value="{{ $booking->status }}" selected>
                                                                {{ $booking->status == 1 ? 'Check-In' : 'Booking' }}
                                                            </option>
                                                            <option value="check-in">Check in</option>
                                                            <option value="booking">Booking</option>
                                                        </select>
                                                    </div>

                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-primary">Update</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- delete model --}}
                                    <button class="btn btn-outline-danger delete" id="{{ $booking->id }}">
                                        <i class="fa fa-trash-alt fa-lg" aria-hidden="true"></i>

                                        <form action="{{ route('booking.delete', $booking->id) }}" method="POST"
                                            id="deleteform{{ $booking->id }}">
                                            @csrf
                                            @method('DELETE')
                                        </form>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <center><h4>No Upcoming Bookings to display for now..</h4></center>
                    @endif
                </tbody>
            </table>
        </div>
    </div>

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script>
        $(function() {

            $("#customer").DataTable({

                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        }); //closing DataTables function

        $("#success").fadeIn("slow");
        setTimeout(function() {
            $("#success").fadeOut("slow")
        }, 3000);

        $("#paid").on("keyup", function() {
            let paid = $(this).val();
            let roomPrice = $("#price").val();
            if (paid > 0) {
                $("#account-div").fadeIn("slow");
                $("#account").attr("required", true);
            } else if (paid > 0 || paid === "") {
                $("#account-div").fadeOut("slow");
                $("#account").attr("required", false);
            }
        });

        $(".delete").on("click", function() {
            let id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("deleteform" + id).submit();
                }
            })
        });

        $(".checkin").on("click", function() {
            let id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You are about to check-in a customer",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, check-in!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("checkinform" + id).submit();
                }
            })
        });
    </script>
@endsection

@endsection
