    @extends('layouts.master')

    @section('content')

        <div class="card">

            <div class="card-header">
                <h5>Update product price</h5>
            </div>

            <div class="card-body">

                <div class="row mb-4">
                    <div class="col-md-7 mb-2 mb-md-0">
                        <div class="input-group">
                            <span class="input-group-text bg-primary text-white">
                                <i class="fas fa-barcode"></i>
                            </span>
                            <input type="search" id="search" class="form-control search"
                                placeholder="Enter product name or barcode...">
                        </div>
                        <div id="list"
                            style="display:none; position: absolute; z-index: 10; width: 100%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);"
                            class="bg-white border border-primary">
                            <ol id="results" class="list-group list-group-flush"></ol>
                        </div>
                    </div>
                    <div class="col-md-5">
                        @if ($sellingCount > 1)
                            <div class="input-group shadow-sm">
                                <span class="input-group-text bg-info text-white">
                                <i class="fas fa-map-pin"></i>
                                </span>
                                <select name="area" id="area" class="form-control" style="text-align: center" required>
                                    <option disabled selected>-- Choose Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        @else
                            <input type="hidden" name="area" id="area" class="form-control"
                                value="{{ $sellings[0]->location_id }}">
                            <div class="input-group shadow-sm">
                                <span class="input-group-text bg-info text-white">
                                   <i class="fas fa-map-pin"></i>
                                </span>
                                <input type="text" name="area-copy" id="area-copy" class="form-control"
                                    value="{{ $sellings[0]->location->name }}" style="text-align: center" readonly>
                            </div>
                        @endif
                    </div>
                </div>

                <br>

                <form action="{{ route('update.product.price') }}" method="get">
                    @csrf

                    <div class="row mb-4 col-md-12 units-area">
                        <div class="row col-md-12 mb-2 heading bg-light rounded py-2 align-items-center"
                            style="font-weight: 600; font-size: 1rem; border-bottom: 2px solid #17a2b8;">
                            <div class="col-md-1 text-center text-primary">Product</div>
                            <div class="col-md-1 text-center text-primary">Buy.P</div>
                            <div class="col-md-1 text-center text-info">Unit 1</div>
                            <div class="col-md-1 text-center text-info">Cont 1</div>
                            <div class="col-md-1 text-center text-info">Sell 1</div>
                            <div class="col-md-1 text-center text-success">Unit 2</div>
                            <div class="col-md-1 text-center text-success">Cont 2</div>
                            <div class="col-md-1 text-center text-success">Sell 2</div>
                            <div class="col-md-1 text-center text-warning">Unit 3</div>
                            <div class="col-md-1 text-center text-warning">Cont 3</div>
                            <div class="col-md-1 text-center text-warning">Sell 3</div>
                            <div class="col-md-1 text-center text-danger">Action</div>
                        </div>
                    </div>

                    <center>
                        <table>
                            <thead>
                                <th><input type="hidden" name="location" id="location" class="form-control"></th>
                                <th><button type="submit" class="btn btn-primary"> <i class="fas fa-paper-plane"></i> Save
                                        Changes</button></th>
                            </thead>
                        </table>
                    </center>
                </form>
            </div>

            <div class="card-footer">

            </div>
        </div>

    @section('scripts')
        <script>
            $(document).ready(function() {
                // ========================
                // Global Variables
                // ========================
                let index = 0;
                let area;
                let ajaxResults = [];
                const sellingCount = {{ $sellingCount }};

                // ========================
                // Initialization
                // ========================
                if (sellingCount > 1) {
                    $("#area").focus().on("change", function() {
                        area = $(this).val();
                        $("#location").val(area);
                    });
                } else {
                    area = $("#area").val();
                    $("#location").val(area);
                    $("#search").focus();
                }

                // ========================
                // Handle Barcode Scan / Enter
                // ========================
                $("#search").on("change", function() {
                    const barcode = $(this).val().trim();
                    if (!barcode) return;

                    $.ajax({
                        url: "{{ route('get.product.by.barcode') }}",
                        method: "GET",
                        data: {
                            barcode,
                            locationId: area
                        },
                        success: function(data) {
                            if (!data || data.length === 0) {
                                resetSearch();
                                return;
                            }

                            const product = data[0];
                            if (isProductAlreadyAdded(product.product)) {
                                showWarning("This product already exists.");
                                resetSearch();
                                return;
                            }

                            addProductRow(product);
                            resetSearch();
                        },
                        error: function() {
                            showWarning("Error retrieving product. Please try again.");
                            resetSearch();
                        }
                    });
                });

                // ========================
                // Live Search Suggestions
                // ========================
                $("#search").on("keyup", function() {
                    const query = $(this).val().trim();
                    $("#results").empty();

                    if (!query) {
                        $("#list").fadeOut("slow");
                        return;
                    }

                    $.ajax({
                        url: "{{ route('get.location.product') }}",
                        method: "GET",
                        data: {
                            query,
                            locationId: area
                        },
                        success: function(data) {
                            ajaxResults = data;
                            $("#results").empty();

                            if (ajaxResults.length === 0) {
                                $("#list").fadeIn("slow").append(
                                    `<li>
                                    <button type="button" class="btn btn-outline-secondary form-control items">
                                        No suggestions..
                                    </button>
                                </li>`
                                );

                                setTimeout(() => $("#list").fadeOut("slow").empty(), 2000);
                                return;
                            }

                            $("#list").fadeIn("slow");
                            ajaxResults.forEach((item, i) => {
                                $("#results").append(
                                    `<li>
                                    <button type="button" class="form-control items btn btn-outline-secondary" id="${i}">
                                        ${item.product}
                                    </button>
                                </li>`
                                );
                            });
                        },
                        error: function() {
                            showWarning("Error fetching suggestions.");
                        }
                    });
                });

                // ========================
                // Add Product from Suggestion Click
                // ========================
                $(document).on("click", ".items", function() {
                    const id = $(this).attr("id");
                    const product = ajaxResults[id];

                    if (isProductAlreadyAdded(product.product)) {
                        showWarning("This product already exists.");
                        resetSearch();
                        return;
                    }

                    addProductRow(product);
                    resetSearch();
                });

                // ========================
                // Utility Functions
                // ========================

                // Add row dynamically
                function addProductRow(product) {
                    let unitsHtml = "";

                    product.unit.forEach((unitData, i) => {
                        unitsHtml += `
                        <div class="col-md-1">
                            <select name="unit_${product.id}[]${i}" class="form-control text-center" required>
                                <option value="${unitData.unit.id}">${unitData.unit.name}</option>
                                @foreach ($units as $unit)
                                    <option value="{{ $unit->id }}">{{ $unit->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-1">
                            <input type="text" name="cont_${product.id}[]${i}" value="${unitData.unit_cont}" 
                                class="form-control text-center" required>
                        </div>

                        <div class="col-md-1">
                            <input type="text" name="sell_${product.id}[]${i}" value="${unitData.selling}" 
                                class="form-control text-center price" required>
                        </div>
                    `;
                    });

                    const newRow = `
                    <div class="row col-md-12 mb-3" id="row${index}">
                        <div class="col-md-1">
                            <input type="hidden" name="product[]" value="${product.product}" class="form-control" readonly required>
                            <h6>${product.product}</h6>
                        </div>

                        <div class="col-md-1">
                            <input type="text" name="buying[]" value="${product.buying}" class="form-control text-center" required>
                        </div>

                        ${unitsHtml}

                        <div class="col-md-1">
                            <button type="button" class="btn btn-outline-danger removeRow" id="${index}">
                                <i class="fa fa-trash-alt"></i>
                            </button>
                        </div>
                    </div>
                `;

                    $(".heading").after(newRow);

                    // Attach delete event
                    $(`#row${index} .removeRow`).on("click", function() {
                        $(`#row${$(this).attr("id")}`).remove();
                    });

                    index++;
                }

                // Reset the search input and suggestion list
                function resetSearch() {
                    $("#search").val("").focus();
                    $("#list").fadeOut("slow");
                }

                // Safely check if product is already added
                function isProductAlreadyAdded(productName) {
                    if (window.CSS && CSS.escape) {
                        return $(`input[name='product[]'][value='${CSS.escape(productName)}']`).length > 0;
                    }

                    // Fallback for older browsers
                    return $("input[name='product[]']").filter(function() {
                        return $(this).val() === productName;
                    }).length > 0;
                }

                // Show warning alerts
                function showWarning(message) {
                    Swal.fire({
                        icon: 'warning',
                        title: message,
                        showConfirmButton: false,
                        timer: 2000
                    });
                }
            });
        </script>
    @endsection

    @endsection
