@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            Update Product Details
        </div>

        <div class="card-body">
            <div class="row mb-4">
                <div class="col-md-7 mb-2 mb-md-0">
                    <div class="input-group">
                        <span class="input-group-text bg-primary text-white">
                            <i class="fas fa-barcode"></i>
                        </span>
                        <input type="search" id="search" class="form-control search"
                            placeholder="Enter product name or barcode...">
                    </div>
                    <div id="list"
                        style="display:none; position: absolute; z-index: 10; width: 100%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);"
                        class="bg-white border border-primary">
                        <ol id="results" class="list-group list-group-flush"></ol>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="input-group">
                        <span class="input-group-text bg-info text-white">
                            <i class="fas fa-map-pin"></i>
                        </span>
                        <select name="area" id="area" class="form-control text-center" required>
                            <option disabled selected value="">-- Choose Location --</option>
                            @foreach ($sellings as $selling)
                                <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                </option>
                                @foreach ($selling->storage as $storage)
                                    <option value="{{ $storage->location_id }}">
                                        -- {{ $storage->location->name }} --
                                    </option>
                                @endforeach
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            <form action="{{ route('update.product') }}" onsubmit="showSpinner()" method="POST"
                enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <div class="table-responsive">
                    <table class="table table-bordered table-hover" id="productsTable">
                        <thead class="thead-dark text-center">
                            <tr>
                                <th>Image</th>
                                <th>Barcode</th>
                                <th>Product</th>
                                <th>Buying Price</th>
                                <th>Category</th>
                                <th>Total Stock</th>
                                <th>
                                    @if ($batchStatus == 0)
                                        Units ⏷
                                    @else
                                        Stock ⏷ | Units ⏷
                                    @endif
                                </th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="units-area" id="tbody">
                            <!-- Product rows will be appended here dynamically -->
                        </tbody>
                    </table>
                </div>

                <div class="card-footer">
                    <center>
                        <table>
                            <thead>
                                <th><input type="hidden" name="location" id="location" class="form-control"></th>
                                <th><button type="submit" class="btn btn-info btn-sm"><i class="fas fa-paper-plane"></i>
                                        Save
                                        Changes </button></th>
                            </thead>
                        </table>
                    </center>
                </div>
            </form>
        </div>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {

            $("#location").focus();

            //Global variables
            let units = @json($units);
            let batchStatus = @json($batchStatus);
            let index = 0; // global row index
            let ajaxResponse = []; // store ajax search response
            let displayedIds = []; // to prevent duplicate suggestions
            var query;
            var location;
            var productId;
            var paid;
            var net;
            var total;
            var discount;
            var price;
            var qty;
            var unit;
            var id;

            // Keep #location synced with #area select
            $("#area").on("change", function() {
                $("#location").val($(this).val());
            });

            // Keep counters for units and batches per product
            let unitCounters = {};
            let batchCounters = {};

            // =========================
            // 1️⃣ Autocomplete / Name Search with barcode detection
            // =========================
            let lastKeyTime = 0;
            let barcodeBuffer = "";

            function fetchProducts(query, isBarcode = false) {
                let area = $("#area").val();
                if (!query || !area) {
                    $("#results").empty();
                    $("#list").hide();
                    return;
                }

                $.ajax({
                    url: "{{ route('get.location.product') }}",
                    method: "GET",
                    data: {
                        query: isBarcode ? null : query,
                        barcode: isBarcode ? query : null,
                        locationId: area
                    },
                    success: function(response) {
                        ajaxResponse = response;
                        console.log("Ajax Response:", ajaxResponse);

                        $("#results").empty();
                        displayedIds = [];

                        // Barcode scan result (expect only 1 product)
                        if (isBarcode && response.length === 1) {
                            addProductToTable(response[0]);
                            $("#search").val("").focus();
                            $("#list").fadeOut("slow");
                            return;
                        }

                        // Manual typing: show suggestions
                        if (!isBarcode) {
                            if (response.length === 0) {
                                $("#results").append(
                                    '<li class="list-group-item text-center text-muted">No suggestions...</li>'
                                );
                            } else {
                                response.forEach((item, i) => {
                                    if (!displayedIds.includes(item.id)) {
                                        displayedIds.push(item.id);
                                        $("#results").append(
                                            `<li class="list-group-item product-items" data-index="${i}" style="cursor:pointer;">
                                    ${item.product} | Stock: ${item.totalQty} ${item.unit[0]?.name ?? ''}
                                </li>`
                                        );
                                    }
                                });
                            }

                            $("#list").fadeIn("fast");
                        }
                    }
                });
            }

            // Manual typing search (keyup)
            $("#search").on("keyup", function(e) {
                let query = $(this).val();

                // 🚫 Skip keyup if Enter pressed (barcode handled separately)
                if (e.which === 13) return;

                // 🚫 Ignore very fast typing (likely barcode in progress)
                const currentTime = new Date().getTime();
                if (currentTime - lastKeyTime < 30) return;

                lastKeyTime = currentTime;

                if (query.length > 0) {
                    fetchProducts(query, false); // manual search
                }
            });

            // Barcode scan detection (Enter key)
            $("#search").on("keydown", function(e) {
                const currentTime = new Date().getTime();
                const char = e.key;

                // Build barcode buffer if keys are fast
                if (currentTime - lastKeyTime < 30) {
                    barcodeBuffer += char;
                } else {
                    barcodeBuffer = char;
                }
                lastKeyTime = currentTime;

                if (e.key === "Enter") {
                    e.preventDefault();
                    let barcode = $(this).val().trim();
                    if (barcode !== "") {
                        fetchProducts(barcode, true); // barcode search
                    }
                    barcodeBuffer = "";
                }
            });

            const formatPrice = (num) => num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");

            // Add product row
            $(document).on("click", ".product-items", function() {
                const index = $(this).data("index");
                addProductToTable(ajaxResponse[index], index);
                $("#search").val("");
                $("#list").fadeOut("slow");
            });

            // Function to add product row
            function addProductToTable(product) {
                const rowId = `row_${Date.now()}`; // unique row ID
                const productId = product.id;
                const barcode = product.barcode ?? '';
                const productBuying = product.buying ?? 0;
                const formattedBuying = formatPrice(productBuying);
                const productName = product.product;
                const categoryId = product.category?.id ?? '';
                const categoryName = product.category?.name ?? 'Null';
                const totalStock = product.totalQty ?? 0;

                // Initialize counters
                unitCounters[rowId] = product.unit?.length || 0;
                batchCounters[rowId] = product.batches?.length || 0;

                const batchesId = `batches_${rowId}`;
                const unitsId = `units_${rowId}`;

                // Batches table
                let batchesTable = `
                                    <table class="table table-sm table-bordered mb-2 text-center" id="batchesTable_${rowId}">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Batch No</th>
                                                <th>Exp Date</th>
                                                <th>Qty</th>
                                                <th>
                                                    <button type="button" class="btn btn-success btn-sm mb-2 addBatch" data-rowid="${rowId}" data-productid="${productId}">
                                                        <i class="fas fa-plus-circle"></i>
                                                    </button>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        ${product.batches?.map(batch => `
                                                                                                                <tr>
                                                                                                                    <td><input type="text" name="batch_no[${productId}][]" value="${batch.batch_no}" class="form-control form-control-sm"></td>
                                                                                                                    <td><input type="date" name="exp[${productId}][]" value="${batch.exp}" class="form-control form-control-sm"></td>
                                                                                                                    <td><input type="text" name="qty[${productId}][]" value="${batch.qty}" class="form-control form-control-sm"></td>
                                                                                                                    <td> 
                                                                                                                        <button type="button" class="btn btn-danger btn-sm removeBatch">
                                                                                                                            <i class="fas fa-minus-circle"></i>
                                                                                                                        </button>
                                                                                                                    </td>
                                                                                                                </tr>
                                                                                                            `).join('')}
                                        </tbody>
                                    </table>
                                `;

                // Units table
                let unitsTable = `
                                    <table class="table table-sm table-bordered mb-2 text-center" id="unitsTable_${rowId}">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Unit</th>
                                                <th>Unit Cont</th>
                                                <th>Selling Price</th>
                                                <th> 
                                                    <button type="button" class="btn btn-success btn-sm mb-2 addUnit" 
                                                        data-rowid="${rowId}" data-productid="${productId}">
                                                        <i class="fas fa-plus-circle"></i>
                                                    </button>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            ${product.unit?.map(u => `
                                                                                        <tr>
                                                                                            <td>
                                                                                                <select name="unit_id[${productId}][]" class="form-control form-control-sm">
                                                                                                    ${units.map(opt => `
                                                                <option value="${opt.id}" ${u.id == opt.id ? 'selected' : ''}>
                                                                    ${opt.name}
                                                                </option>
                                                            `).join('')}
                                                                                                </select>
                                                                                            </td>
                                                                                            <td>
                                                                                                <input type="text" name="unit_cont[${productId}][]" value="${u.unit_cont}" 
                                                                                                    class="form-control form-control-sm">
                                                                                            </td>
                                                                                            <td>
                                                                                                <input type="text" name="selling[${productId}][]" value="${formatPrice(u.selling)}" 
                                                                                                    class="form-control form-control-sm price-input">
                                                                                            </td>
                                                                                            <td>
                                                                                                <button type="button" class="btn btn-danger btn-sm removeUnit">
                                                                                                    <i class="fas fa-minus-circle"></i>
                                                                                                </button>
                                                                                            </td>
                                                                                        </tr>
                                                                                    `).join('')}
                                        </tbody>
                                    </table>
                                `;

                // Main product row
                const row = `
                                <tr data-rowid="${rowId}">
                                    <td>
                                        <div class="form-group text-center">
                                            <input type="file" name="image[]" accept="image/*" class="form-control-file mb-1" id="image${rowId}" onchange="previewImage(this, '${rowId}')">
                                            <input type="hidden" name="id[]" value="${productId}">
                                            <div class="preview-container">
                                                <img src="${product.image || ''}" id="preview${rowId}" class="img-thumbnail" style="max-height: 80px; display: ${product.image ? 'block' : 'none'};">
                                            </div>
                                        </div>
                                    </td>
                                    <td><input style="text-align:center" type="text" name="barcode[]" value="${barcode}" class="form-control form-control-sm"></td>
                                    <td><input type="text" name="product[]" value="${productName}" class="form-control form-control-sm" required></td>
                                    <td><input style="text-align:center" type="text" name="buying[]" value="${formattedBuying}" class="form-control form-control-sm buying-input"></td>
                                    <td>
                                        <select style="text-align:center" name="category[]" class="form-control form-control-sm">
                                            <option value="${categoryId}" selected>${categoryName}</option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}">-- {{ $category->name }} --</option>
                                            @endforeach
                                        </select>
                                    </td>
                                    <td><input style="text-align:center" type="text" name="total_stock[]" value="${totalStock}" class="form-control form-control-sm"  ${batchStatus == 0 ? "" : "readonly"}></td>
                                    <td class="text-center">
                                        ${batchStatus != 0 
                                            ? `<button class="btn btn-sm btn-outline-info mb-1" type="button" data-toggle="collapse" data-target="#${batchesId}" aria-expanded="false" aria-controls="${batchesId}">Stock ⏷</button>` 
                                            : ""
                                        }
                                        
                                        <button class="btn btn-sm btn-outline-secondary mb-1" type="button" data-toggle="collapse" data-target="#${unitsId}" aria-expanded="false" aria-controls="${unitsId}">Units ⏷</button>

                                        ${batchStatus != 0 ? `<div class="collapse mt-2" id="${batchesId}">${batchesTable}</div>` : ""}

                                        <div class="collapse mt-2" id="${unitsId}">${unitsTable}</div>
                                    </td>

                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-sm removeRow">🗑️</button>
                                    </td>
                                </tr>
                            `;

                $("#tbody").append(row);
                $("#search").val("").focus();
            }

            // =====================
            // Event handlers
            // =====================

            // Remove product row
            $(document).on("click", ".removeRow", function() {
                const rowId = $(this).closest('tr').data('rowid');
                $(this).closest('tr').remove();
                delete unitCounters[rowId];
                delete batchCounters[rowId];
            });

            // Remove batch or unit row
            $(document).on("click", ".removeBatch, .removeUnit", function() {
                $(this).closest('tr').remove();
            });

            // Price formatting as user types
            $(document).on('input', '.price-input, .buying-input', function() {
                let val = $(this).val().replace(/,/g, '');
                if (!isNaN(val) && val !== '') {
                    val = parseInt(val).toLocaleString();
                    $(this).val(val);
                } else {
                    $(this).val('');
                }
            });

            // Add Unit
            $(document).on("click", ".addUnit", function() {
                const rowId = $(this).data('rowid');
                const productId = $(this).data('productid');
                unitCounters[rowId] = (unitCounters[rowId] || 0) + 1;

                const newUnitRow = `
                                        <tr>
                                            <td>
                                                <select name="unit_id[${productId}][]" class="form-control form-control-sm">
                                                    ${units.map(opt => `
                                                                                                <option value="${opt.id}">${opt.name}</option>
                                                                                            `).join('')}
                                                </select>
                                            </td>
                                            <td><input type="text" name="unit_cont[${productId}][]" class="form-control form-control-sm"></td>
                                            <td><input type="text" name="selling[${productId}][]" class="form-control form-control-sm price-input"></td>
                                            <td><button type="button" class="btn btn-danger btn-sm removeUnit"><i class="fas fa-minus-circle"></button></td>
                                        </tr>
                                    `;
                $(`#unitsTable_${rowId} tbody`).append(newUnitRow);
            });

            // Add Stock / Batch
            $(document).on("click", ".addBatch", function() {
                const rowId = $(this).data('rowid');
                const productId = $(this).data('productid');
                batchCounters[rowId] = (batchCounters[rowId] || 0) + 1;

                const newBatchRow = `
                                        <tr>
                                            <td><input type="text" name="batch_no[${productId}][]" class="form-control form-control-sm"></td>
                                            <td><input type="date" name="exp[${productId}][]" class="form-control form-control-sm"></td>
                                            <td><input type="text" name="qty[${productId}][]" class="form-control form-control-sm"></td>
                                            <td><button type="button" class="btn btn-danger btn-sm removeBatch"><i class="fas fa-minus-circle"></button></td>
                                        </tr>
                                    `;
                $(`#batchesTable_${rowId} tbody`).append(newBatchRow);
            });

        });

        function showSpinner() {
            // Show spinner to be called on form submission
            document.querySelector('.spinner').style.display = 'block';
        }

        window.addEventListener('load', function() {
            // hide the spinner after the page is loaded
            document.querySelector('.spinner').style.display = 'none';
        });
    </script>
@endsection

@endsection
