@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">

    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">
            <h5 class="card-header">User Roles</h5>

            <div class="card-body">

                <select name="role" class="form-control" id="role" style="text-align: center;">
                    <option>--Select role--</option>
                    @foreach ($roles as $role)
                        <option value="{{ $role->id }}">{{ $role->name }}</option>
                    @endforeach
                </select>

                <div class="container">

                    <div class="row">

                        <div class="col">

                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="checkall">
                                <label class="form-check-label" for="checkall">
                                    Check all permissions
                                </label>
                            </div>
                            <br>

                            @foreach ($permissions as $permission)
                                <div class="form-check">
                                    <input class="form-check-input selected" type="checkbox" value="{{ $permission->id }}"
                                        id="{{ $permission->id }}">
                                    <label class="form-check-label" for="{{ $permission->id }}">
                                        {{ $permission->name }}
                                    </label>
                                </div>
                            @endforeach

                        </div>

                    </div>

                </div>

                <button type="button" id="update" class="form-control btn btn-primary">Update</button>

            </div>

        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    <script type="text/javascript">
        $(document).ready(function() {

            var roleid;

            $("#role").on("change", function() {
                roleid = $(this).val();

                $.ajax({
                    url: "{{ route('get.permission') }}",
                    method: "GET",
                    data: {
                        'roleid': roleid
                    },
                    success: function(data) {

                        for (var i = 0; data.length > i; i++) {

                            var checkbox = $(".selected").attr("value")
                            console.log(checkbox);

                            {{--  if ($(".selected").attr("value", data[i].permission_id)) {
                                $(this).prop("checked", true);
                            } else{
                                $(this).prop("checked", false);
                            }  --}}

                        }

                    }
                });

            });

            $("#checkall").on("click", function() {
                if ($(this).is(':checked', true)) {
                    $(".selected").prop('checked', true);
                } else {
                    $(".selected").prop('checked', false);
                }
            });

            $("#update").on("click", function() {
                var selected = [];
                $(".selected:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {
                    alert("please select at least one items!!");
                } else {
                    if (confirm("Are you sure..")) {
                        $.ajax({
                            url: "{{ route('assign.permission') }}",
                            method: "GET",
                            data: {
                                'ids': selected,
                                'roleid': roleid
                            },
                            success: function(data) {
                                if (confirm("Permission successfully assigned..")) {
                                    window.location.reload(true);
                                }
                            }
                        });
                    }

                }

            });

        });
    </script>
@endsection

@endsection
