@extends('layouts.master')

@section('content')

    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5>Register Vehicles</h5>
            {{-- <div>
                <div class="btn-group" role="group">
                    <button type="button" id="deleteall" class="btn btn-danger btn-sm">
                        <i class="fas fa-trash-alt"></i> Delete All
                    </button>
                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                        data-target="#registerVehicleModal">
                        <i class="fas fa-plus"></i> Register Vehicle
                    </button>
                </div>
            </div> --}}
        </div>

        <!-- Register Vehicle Modal -->
        {{-- <div class="modal fade" id="registerVehicleModal" tabindex="-1" aria-labelledby="registerVehicleLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="{{ route('vehicle.store') }}" method="POST" class="was-validated">
                        @csrf
                        <div class="modal-header">
                            <h5 class="modal-title" id="registerVehicleLabel">Register Vehicle</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="vehicle-name">Vehicle</label>
                                <input type="text" name="name" class="form-control" id="vehicle-name"
                                    placeholder="Enter vehicle name & plate no..." required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary btn-block">
                                <i class="fas fa-paper-plane"></i> Register
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div> --}}

        <div class="card-body table-responsive">
            <table class="table table-striped table-hover" id="example1">
                <thead class="thead-dark">
                    <tr>
                        <th style="width: 3%;" class="text-center"><input type="checkbox" id="checkall"></th>
                        <th style="width: 3%" class="text-center">S/N</th>
                        <th class="text-center">Vehicle</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($vehicles as $vehicle)
                        <tr>
                            <td class="text-center"><input type="checkbox" class="selected" value="{{ $vehicle->id }}">
                            </td>
                            <td class="text-center">{{ $loop->iteration }}</td>
                            <td class="text-center"><i class="fas fa-truck"></i> {{ $vehicle->name }}</td>
                            {{-- <td class="text-center">
                                <div class="btn-group" role="group">
                                    <!-- Edit button -->
                                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                        data-target="#editVehicleModal-{{ $vehicle->id }}">
                                        <i class="fas fa-pen"></i> Edit
                                    </button>

                                    <!-- Delete button -->
                                    <form action="{{ route('vehicle.destroy', $vehicle->id) }}" method="POST"
                                        class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm">
                                            <i class="fas fa-trash-alt"></i> Delete
                                        </button>
                                    </form>
                                </div>
                            </td> --}}
                        </tr>

                        <!-- Edit Vehicle Modal -->
                        {{-- <div class="modal fade" id="editVehicleModal-{{ $vehicle->id }}" tabindex="-1"
                            aria-labelledby="editVehicleLabel-{{ $vehicle->id }}" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <form action="{{ route('vehicle.update', $vehicle->id) }}" method="POST"
                                        class="was-validated">
                                        @csrf
                                        @method('PUT')
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="editVehicleLabel-{{ $vehicle->id }}">Update Vehicle
                                                Details</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="vehicle-name-{{ $vehicle->id }}">Name</label>
                                                <input type="text" name="name" class="form-control"
                                                    value="{{ $vehicle->name }}" id="vehicle-name-{{ $vehicle->id }}"
                                                    required>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary btn-block">
                                                <i class="fas fa-paper-plane"></i> Update
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div> --}}
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>


@section('scripts')
    <script>
        $("#example1").DataTable();

        $("#success").fadeIn("slow");
        setTimeout(function() {
            $("#success").fadeOut("slow")
        }, 3000);

        $("#checkall").on("click", function() {
            if ($(this).is(':checked', true)) {
                $(".selected").prop('checked', true);
            } else {
                $(".selected").prop('checked', false);
            }
        });

        $("#deleteall").on("click", function() {
            var selected = [];
            $(".selected:checked").each(function() {
                selected.push($(this).attr("id"));
            });

            if (selected.length == 0) {

                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Select atleast one item!!',
                });

            } else {

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: "{{ route('vehicle.bulk.delete') }}",
                            method: "GET",
                            data: {
                                'ids': selected
                            },
                            success: function(data) {
                                window.location.reload(true);
                            }
                        });

                        $(document).ready(function() {
                            Swal.fire({
                                icon: 'success',
                                title: 'deleted successfully!!',
                                showConfirmButton: false,
                                timer: 2000
                            });
                        });
                    }
                });

            }

        });

        $(".delete").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("deleteform" + id).submit();
                }
            })
        });
    </script>
@endsection

@endsection
