@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">
        {{-- <center>
            <h5 class="text-black-50">Venue booking</h5>
        </center> --}}
    </div>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">

            <form action="{{ route('venue.booking.index') }}" method="get">

                <div class="card-header">

                    <table>
                        <thead>
                            <th> <input type="date" name="date" id="" class="form-control" required
                                    style="text-align: center"></th>
                            <th> <select name="pax" id="pax" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected value="">--Select Pax--</option>
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5</option>
                                </select></th>
                            <th><button type="submit" class="btn btn-primary">Search</button></th>
                        </thead>
                    </table>

                </div>

            </form>


            <div class="card-body">

                <table class="table table-stripped" id="customer">
                    <thead>
                        <tr>
                            <th>S/N</th>
                            <th>Venue</th>
                            <th>Pax</th>
                            <th>Price</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    @foreach ($venues as $venue)
                        <tr>
                            <td>{{ $loop->index + 1 }}</td>
                            <td>{{ $venue->name }}</td>
                            <td>{{ $venue->pax }}</td>
                            <td>{{ $venue->price }}</td>
                            <td>
                                {{-- Booking trigger model --}}

                                <button type="button" class="btn btn-success" data-toggle="modal"
                                    data-target="#booking-{{ $venue->id }}">
                                    Book venue
                                </button>

                                <div class="modal fade" id="booking-{{ $venue->id }}" role="dialog"
                                    aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">

                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Booking Venue</h5>
                                                <button type="button" class="btn btn-danger" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>

                                            <form action="{{ route('venue.booking.store', $venue->name) }}" method="post">
                                                @csrf

                                                <div class="modal-body">

                                                    <label for="date">Date</label>
                                                    <input type="text" value="{{ $date }}" name="date"
                                                        class="form-control" id="date" required readonly>

                                                    <label for="name">Full name</label>
                                                    <input type="text" name="customer" class="form-control"
                                                        id="name" required>

                                                    <label for="phone">Phone</label>
                                                    <input type="text" name="phone" class="form-control" id="phone"
                                                        required>

                                                    <label for="from">Start time </label>
                                                    <input type="text" name="from" class="form-control" id="from"
                                                        required>

                                                    <label for="to">End Time</label>
                                                    <input type="text" name="to" class="form-control" id="to"
                                                        required>

                                                    <label for="comment">Comment</label>
                                                    <input type="text" name="comment" class="form-control" id="comment"
                                                        required>

                                                    <label for="venue">Venue</label>
                                                    <input type="text" name="venue" value="{{ $venue->name }}"
                                                        class="form-control" id="venue" readonly required>

                                                    <label for="Pax">Pax</label>
                                                    <input type="text" name="pax" class="form-control" id="pax"
                                                        value="" required>

                                                    <label for="vprice">Venue price</label>
                                                    <input type="number" name="vprice" value="{{ $venue->price }}"
                                                        class="form-control" id="vprice" readonly required>

                                                    <label for="event">Event</label>
                                                    <select name="event" id="event" class="form-control" required>
                                                        <option disabled selected value="">Choose event</option>
                                                        @foreach ($events as $event)
                                                            <option value="{{ $event->name }}">{{ $event->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>

                                                    <label for="eprice">Event price</label>
                                                    <input type="number" name="eprice" class="form-control"
                                                        id="eprice" readonly required>

                                                    <label for="total">Total amount</label>
                                                    <input type="number" name="total" class="form-control"
                                                        id="total" readonly required>

                                                    <label for="discount">Discount</label>
                                                    <input type="number" name="discount" class="form-control"
                                                        id="discount" required>

                                                    <label for="net">Net amount</label>
                                                    <input type="number" name="net" class="form-control"
                                                        id="net" readonly>

                                                    <label for="paid">Paid amount</label>
                                                    <input type="number" name="paid" class="form-control"
                                                        id="paid" required>

                                                    <label for="account">Account</label>
                                                    <select name="account" id="account" class="form-control" required>
                                                        <option disabled selected value="">--Select account--
                                                        </option>
                                                        @foreach (App\Models\Account::all() as $account)
                                                            <option value="{{ $account->name }}">{{ $account->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>

                                                    <label for="due">Due balance</label>
                                                    <input type="number" name="due" class="form-control"
                                                        id="due" readonly required>

                                                    <label for="status">Status</label>
                                                    <select name="status" id="status" class="form-control" required>
                                                        <option selected disabled value="">Choose status</option>
                                                        <option value=" Booking">Booking</option>
                                                        <option value="Checking">Checking</option>
                                                    </select>

                                                </div>

                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>

                                            </form>

                                        </div>
                                    </div>
                                </div>

                            </td>
                        </tr>
                    @endforeach

                    <tfoot>
                        <tr>
                            <th>S/N</th>
                            <th>Venue</th>
                            <th>Pax</th>
                            <th>Price</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>

                </table>

            </div>

        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script>
        $("#customer").DataTable({
            "pageLength": 100,
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        $("#success").fadeIn("slow");
        setTimeout(function() {
            $("#success").fadeOut("slow")
        }, 3000);

        var total = $("#total").val();
        $("#net").val(total);

        $("#event").on("change", function() {
            var event = $(this).val();

            $.ajax({

                url: "{{ route('get.event.price') }}",
                method: "get",
                data: {
                    'event': event,
                },

                success: function(data) {
                    console.log(data);
                    var vprice = $("#vprice").val();
                    $("#eprice").val(data.price);
                    var total = Number(vprice) + Number(data.price)
                    $("#total").val(total);
                    $("#net").val(total);

                }

            });
        });

        $("#discount").on("keyup", function() {
            var discount = $(this).val();
            var total = $("#total").val();

            var results = total - discount;

            $("#net").val(results);

        });

        $("#paid").on("keyup", function() {

            var paid = $(this).val();
            if (paid == 0) {
                $("#account").attr("required", false).fadeOut("slow")
            } else {
                $("#account").attr("required", true).fadeIn("slow")
            }
            var net = $("#net").val();

            var results = net - paid;

            $("#due").val(results);

        });
    </script>
@endsection

@endsection
