@extends('layouts.master')

@section('content')

    {{-- Content Header (Page header) --}}
    <div class="content-header">
        {{-- <center>
            <h5 class="text-black-50">Venues</h5>
        </center> --}}
    </div>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">

            <div class="card-header">

                <button type="button" class="btn btn-danger" id="deleteall">Delete selected</button>

                <!-- Large modal -->
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target=".customer">Register
                    venue</button>

                <div class="modal fade customer" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">

                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Register Venue</h5>
                                <button type="button" class="btn btn-danger" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>

                            <form action="{{ route('venue.store') }}" method="post">
                                @csrf

                                <div class="modal-body">

                                    <label for="name">Venue</label>
                                    <input type="text" name="name" class="form-control" id="name" required>

                                    <label for="pax">Pax</label>
                                    <input type="number" name="pax" class="form-control" id="pax" required>

                                    <label for="price">Price</label>
                                    <input type="number" name="price" class="form-control" id="price" required>

                                    <label for="description">Description</label>
                                    <textarea name="description" id="description" cols="10" rows="5" class="form-control" required></textarea>

                                </div>

                                <div class="modal-footer">
                                        <button class="btn btn-info btn-block">Register</button>
                                </div>

                            </form>


                        </div>
                    </div>
                </div>

            </div>

            <div class="card-body">

                <table class="table table-stripped" id="customer">
                    <thead>

                        <tr>
                            <th style="width: 2%;"><input type="checkbox" id="checkall"></th>
                            <th style="width: 10%;">S/N</th>
                            <th style="width: 15%;">Venue</th>
                            <th style="width:15%">Pax</th>
                            <th style="width: 15%">Price</th>
                            <th>Description</th>
                            <th style="width: 15%">Action</th>
                        </tr>
                    </thead>

                    @foreach ($venues as $venue)
                        <tr>
                            <td><input type="checkbox" class="selected" id="{{ $venue->id }}"></td>
                            <td> {{ $loop->index + 1 }}</td>
                            <td>{{ $venue->name }}</td>
                            <td>{{ $venue->pax }}</td>
                            <td>{{ $venue->price }}</td>
                            <td>{{ $venue->features }}</td>
                            <td>

                                {{-- Block venue --}}
                                <button type="button" class="btn btn-secondary" data-toggle="modal"
                                    data-target="#block-{{ $venue->id }}" id="block">
                                    @if ($venue->block == 'Blocked')
                                        Unblock
                                    @else
                                        Block
                                    @endif
                                </button>

                                <div class="modal fade" id="block-{{ $venue->id }}" tabindex="-1">
                                    <div class="modal-dialog">
                                        <div class="modal-content">

                                            <form action="{{ route('venue.block', $venue->id)}}" method="get">
                                                @csrf

                                                <div class="modal-body">
                                                    <label for="reason">Block reason</label>
                                                    <select name="reason" id="reason" class="form-control"
                                                        style="text-align: center">
                                                        <option value="">--Select reason--</option>
                                                        <option value="construction">Construction</option>
                                                        <option value="cleaning">Cleaning</option>
                                                    </select>
                                                </div>

                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-primary"
                                                        id="confirmblock">Submit</button>
                                                </div>

                                            </form>

                                        </div>
                                    </div>
                                </div>

                                {{-- edit trigger model --}}

                                <button type="button" class="btn btn-info" data-toggle="modal"
                                    data-target="#edit-{{ $venue->id }}">
                                    <i class="fa-solid fa-pen-to-square fa-lg"></i>
                                </button>

                                <div class="modal fade" id="edit-{{ $venue->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">

                                            <form action="{{ route('venue.update', $venue->id) }}" method="get">

                                                <div class="modal-header">

                                                    <button type="button" class="btn btn-danger" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>

                                                </div>

                                                <div class="modal-body">

                                                    <label for="name">Venue</label>
                                                    <input type="text" name="name" class="form-control"
                                                        value="{{ $venue->name }}" id="name">

                                                    <label for="pax">Pax</label>
                                                    <input type="number" name="pax" class="form-control"
                                                        value="{{ $venue->pax }}" id="pax">

                                                    <label for="Price">Price</label>
                                                    <input type="number" name="price" class="form-control"
                                                        value="{{ $venue->price }}" id="price">

                                                    <label for="description">Description</label>
                                                    <input type="text" name="description" id="description"
                                                        class="form-control" value="{{ $venue->features }}">

                                                </div>

                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                </div>

                                            </form>

                                        </div>
                                    </div>
                                </div>

                                {{-- delete model --}}

                                <button class="btn btn-danger delete" id="{{ $venue->id }}">
                                    <i class="fa fa-trash fa-lg" aria-hidden="true"></i>

                                    <form action="{{ route('venue.destroy', $venue->id) }}" method="GET"
                                        id="deleteform{{ $venue->id }}">
                                    </form>
                                </button>

                            </td>
                        </tr>
                    @endforeach

                    <tfoot>
                        <tr>
                            <th><input type="checkbox" id="checkall"></th>
                            <th>S/N</th>
                            <th>Venue</th>
                            <th>Pax</th>
                            <th>Price</th>
                            <th>Description</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>

                </table>

            </div>

        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script>
        $("#customer").DataTable({
            "pageLength": 100,
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        $("#success").fadeIn("slow");
        setTimeout(function() {
            $("#success").fadeOut("slow")
        }, 3000);

        $("#checkall").on("click", function() {
            if ($(this).is(':checked', true)) {
                $(".selected").prop('checked', true);
            } else {
                $(".selected").prop('checked', false);
            }
        });


        $("#deleteall").on("click", function() {
            var selected = [];
            $(".selected:checked").each(function() {
                selected.push($(this).attr("id"));
            });

            if (selected.length == 0) {

                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Select atleast one item!!',
                });

            } else {

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: "{{ route('venues.bulk.delete') }}",
                            method: "GET",
                            data: {
                                'ids': selected
                            },
                            success: function(data) {
                                window.location.reload(true);
                            }
                        });

                        $(document).ready(function() {
                            Swal.fire({
                                icon: 'success',
                                title: 'deleted successfully!!',
                                showConfirmButton: false,
                                timer: 2000
                            });
                        });
                    }
                });

            }

        });

        $(".delete").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("deleteform" + id).submit();
                }
            })
        });
    </script>
@endsection

@endsection
