@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">
        <center>
            <h5 class="text-black-50">Vehicles</h5>
        </center>
    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        @php
            $sale = App\Models\Sale::find($id);
        @endphp

        <div class="page-content container">

            <div id="printarea">
                <div class="page-header text-blue-d2">
                    <h1 class="page-title text-secondary-d1">
                        Invoice
                        <small class="page-info">
                            <i class="fa fa-angle-double-right text-80"></i>
                            ID: #{{ $sale->id }}
                        </small>
                    </h1>

                    <div class="page-tools">
                        <div class="action-buttons">
                            <button class="btn bg-white btn-light mx-1px text-95" data-title="Print" id="print"
                                onclick="printPageArea('printarea')">
                                <i class="mr-1 fa fa-print text-primary-m1 text-120 w-2"></i>
                                Print
                            </button>
                            <a class="btn bg-white btn-light mx-1px text-95" href="#" data-title="PDF">
                                <i class="mr-1 fa fa-file-pdf-o text-danger-m1 text-120 w-2"></i>
                                Export
                            </a>
                        </div>
                    </div>
                </div>

                <div class="container px-0">
                    <div class="row mt-4">
                        <div class="col-12 col-lg-12">

                            <div class="row">
                                <div class="col-sm-6">

                                    @php
                                        $sale = App\Models\Sale::find($id);
                                        $waiter = App\Models\Waiter::where('name', $sale->waiter)->first();
                                        $vatstatus = App\Models\BusinessProfile::select('vat')->first();
                                    @endphp

                                    <div>
                                        <span class="text-sm text-grey-m2 align-middle">To:</span>
                                        <span class="text-600 text-110 text-blue align-middle">{{ $waiter->name }}</span>
                                    </div>
                                    <div class="text-grey-m2">
                                        <div class="my-1">
                                            {{ $waiter->address }}
                                        </div>
                                        <div class="my-1">
                                            Tanzania
                                        </div>
                                        <div class="my-1"><i class="fa fa-phone fa-flip-horizontal text-secondary"></i> <b
                                                class="text-600">{{ $waiter->phone }}</b></div>
                                    </div>

                                </div>
                                <!-- /.col -->

                                <div class="text-95 col-sm-6 align-self-start d-sm-flex justify-content-end">
                                    <hr class="d-sm-none" />
                                    <div class="text-grey-m2">

                                        <div class="mt-1 mb-2 text-secondary-m1 text-600 text-125">
                                            Invoice
                                        </div>

                                        <div class="my-2"><i class="fa fa-circle text-blue-m2 text-xs mr-1"></i> <span
                                                class="text-600 text-90">ID:</span> #{{ $sale->id }}</div>

                                        <div class="my-2"><i class="fa fa-circle text-blue-m2 text-xs mr-1"></i> <span
                                                class="text-600 text-90">Issue Date:</span> {{ $sale->date }}</div>

                                        <div class="my-2"><i class="fa fa-circle text-blue-m2 text-xs mr-1"></i> <span
                                                class="text-600 text-90">Status:</span>
                                            @if ($sale->due == 0)
                                                <span class="badge badge-success badge-pill px-25">Paid</span>
                                            @else
                                                <span class="badge badge-warning badge-pill px-25">Unpaid</span>
                                            @endif
                                        </div>

                                    </div>
                                </div>
                                <!-- /.col -->
                            </div>

                            <div class="mt-4">

                                <div class="row text-600 text-white bgc-default-tp1 py-25">
                                    <div class="d-none d-sm-block col-1">#</div>
                                    <div class="col-9 col-sm-5">Description</div>
                                    <div class="d-none d-sm-block col-4 col-sm-2">Qty</div>
                                    <div class="d-none d-sm-block col-sm-2">Unit Price</div>
                                    <div class="col-2">Amount</div>
                                </div>

                                <div class="text-95 text-secondary-d3">
                                    @php
                                        $items = App\Models\SoldItem::where('sale_id', $id)->get();
                                    @endphp

                                    @foreach ($items as $item)
                                        <div class="row mb-2 mb-sm-0 py-25">
                                            <div class="d-none d-sm-block col-1"> {{ $loop->index + 1 }}</div>
                                            <div class="col-9 col-sm-5">{{ $item->product }}</div>
                                            <div class="d-none d-sm-block col-2">
                                                {{ $item->qty }}({{ $item->unit }}({{ $item->cont }}))</div>
                                            <div class="d-none d-sm-block col-2 text-95">{{ $item->buying }}</div>
                                            <div class="col-2 text-secondary-d2">{{ $item->amount }}</div>
                                        </div>
                                    @endforeach
                                </div>

                                <div class="row border-b-2 brc-default-l2"></div>

                                <!-- or use a table instead -->
                                <div class="row mt-3">
                                    <div class="col-12 col-sm-7 text-grey-d2 text-95 mt-2 mt-lg-0">
                                        Extra note such as company or payment information...
                                    </div>

                                    <div class="col-12 col-sm-5 text-grey text-90 order-first order-sm-last">
                                        <div class="row my-2">
                                            <div class="col-7 text-right">
                                                SubTotal
                                            </div>
                                            <div class="col-5">
                                                <span class="text-120 text-secondary-d1">{{ $sale->total }}</span>
                                            </div>
                                        </div>

                                        @if ($vatstatus->vat == 'Inclusive')
                                            <div class="row my-2">
                                                <div class="col-7 text-right">
                                                    - Tax (18%)
                                                </div>
                                                <div class="col-5">
                                                    <span class="text-110 text-secondary-d1">{{ $sale->vat }}</span>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="row my-2">
                                            <div class="col-7 text-right">
                                                - Discount
                                            </div>
                                            <div class="col-5">
                                                <span class="text-110 text-secondary-d1">{{ $sale->discount }}</span>
                                            </div>
                                        </div>

                                        <div class="row my-2">
                                            <div class="col-7 text-right">
                                                + Transport
                                            </div>
                                            <div class="col-5">
                                                <span class="text-110 text-secondary-d1">{{ $sale->transport }}</span>
                                            </div>
                                        </div>

                                        <div class="row my-2">
                                            <div class="col-7 text-right">
                                                Net amount
                                            </div>
                                            <div class="col-5">
                                                <span class="text-120 text-secondary-d1">{{ $sale->net }}</span>
                                            </div>
                                        </div>

                                        <div class="row my-2">
                                            <div class="col-7 text-right">
                                                - Paid amount
                                            </div>
                                            <div class="col-5">
                                                <span class="text-110 text-secondary-d1">{{ $sale->paid }}</span>
                                            </div>
                                        </div>

                                        <div class="row my-2 align-items-center bgc-primary-l3 p-2">
                                            <div class="col-7 text-right">
                                                Due amount
                                            </div>
                                            <div class="col-5">
                                                <span class="text-150 text-success-d3 opacity-2">{{ $sale->due }}</span>
                                            </div>
                                        </div>

                                    </div>
                                </div>



                                <hr />

                                <div>
                                    <span class="text-secondary-d1 text-105">Thank you for your business</span>

                                    @if ($sale->due > 0)
                                        <button type="button" class="btn btn-info btn-bold px-4 float-right mt-3 mt-lg-0"
                                            data-toggle="modal" data-target="#deposite">
                                            Pay now
                                        </button>

                                        <div class="modal fade" id="deposite" tabindex="-1">
                                            <div class="modal-dialog">
                                                <div class="modal-content">

                                                    <div class="modal-header">
                                                        <strong>
                                                            <h4>Pay now...</h4>
                                                        </strong>
                                                    </div>

                                                    <form action="{{ route('pay.customer.debt', $sale->id) }}"
                                                        method="get">
                                                        @csrf

                                                        <div class="modal-body">

                                                            <label for="date">Date</label>
                                                            <input type="date" name="date" class="form-control"
                                                                id="date" value="{{ date('Y-m-d') }}" required>

                                                            <label for="waiter">Customer</label>
                                                            <input type="text" name="waiter" class="form-control"
                                                                id="waiter" value="{{ $sale->waiter }}" readonly>

                                                            <label for="due">Due amount</label>
                                                            <input type="text" name="due" class="form-control"
                                                                id="due" value="{{ $sale->due }}" readonly>

                                                            <label for="paid">Paid amount</label>
                                                            <input type="text" name="paid" class="form-control"
                                                                id="3" required>

                                                            <label for="account"> Account Name</label>
                                                            <select name="account" class="form-control" id="account">
                                                                <option value=>--Choose Account--</option>
                                                                @foreach (App\Models\Account::all() as $account)
                                                                    <option value="{{ $account->name }}">
                                                                        {{ $account->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>

                                                        </div>

                                                        <div class="modal-footer">

                                                            <input type="submit" value="Confirm payment"
                                                                class="btn btn-primary">
                                                        </div>

                                                    </form>

                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <style type="text/css">
            .text-secondary-d1 {
                color: #728299 !important;
            }

            .page-header {
                margin: 0 0 1rem;
                padding-bottom: 1rem;
                padding-top: .5rem;
                border-bottom: 1px dotted #e2e2e2;
                display: -ms-flexbox;
                display: flex;
                -ms-flex-pack: justify;
                justify-content: space-between;
                -ms-flex-align: center;
                align-items: center;
            }

            .page-title {
                padding: 0;
                margin: 0;
                font-size: 1.75rem;
                font-weight: 300;
            }

            .brc-default-l1 {
                border-color: #dce9f0 !important;
            }

            .ml-n1,
            .mx-n1 {
                margin-left: -.25rem !important;
            }

            .mr-n1,
            .mx-n1 {
                margin-right: -.25rem !important;
            }

            .mb-4,
            .my-4 {
                margin-bottom: 1.5rem !important;
            }

            hr {
                margin-top: 1rem;
                margin-bottom: 1rem;
                border: 0;
                border-top: 1px solid rgba(0, 0, 0, .1);
            }

            .text-grey-m2 {
                color: #888a8d !important;
            }

            .text-success-m2 {
                color: #86bd68 !important;
            }

            .font-bolder,
            .text-600 {
                font-weight: 600 !important;
            }

            .text-110 {
                font-size: 110% !important;
            }

            .text-blue {
                color: #478fcc !important;
            }

            .pb-25,
            .py-25 {
                padding-bottom: .75rem !important;
            }

            .pt-25,
            .py-25 {
                padding-top: .75rem !important;
            }

            .bgc-default-tp1 {
                background-color: rgba(121, 169, 197, .92) !important;
            }

            .bgc-default-l4,
            .bgc-h-default-l4:hover {
                background-color: #f3f8fa !important;
            }

            .page-header .page-tools {
                -ms-flex-item-align: end;
                align-self: flex-end;
            }

            .btn-light {
                color: #757984;
                background-color: #f5f6f9;
                border-color: #dddfe4;
            }

            .w-2 {
                width: 1rem;
            }

            .text-120 {
                font-size: 120% !important;
            }

            .text-primary-m1 {
                color: #4087d4 !important;
            }

            .text-danger-m1 {
                color: #dd4949 !important;
            }

            .text-blue-m2 {
                color: #68a3d5 !important;
            }

            .text-150 {
                font-size: 150% !important;
            }

            .text-60 {
                font-size: 60% !important;
            }

            .text-grey-m1 {
                color: #7b7d81 !important;
            }

            .align-bottom {
                vertical-align: bottom !important;
            }
        </style>

    </div>
    {{-- /.content --}}

@section('scripts')
    <script>
        $("#success").fadeIn("slow");
        setTimeout(function() {
            $("#success").fadeOut("slow")
        }, 3000);

        function printPageArea(areaID) {
            var printContent = document.getElementById(areaID);
            var WinPrint = window.open('', '', 'width=900,height=650');
            WinPrint.document.write(printContent.innerHTML);
            WinPrint.document.close();
            WinPrint.focus();
            WinPrint.print();
            WinPrint.close();
        }
    </script>
@endsection
@endsection
