@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            Waiters and table bill.
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover shadow-sm rounded">
                    <thead class="thead-primary text-center bg-primary text-white">
                        <tr>
                            <th><i class="fas fa-user-tie mr-1"></i> Waiters</th>

                            @foreach ($tables as $table)
                                <th><i class="fas fa-chair mr-1"></i> {{ $table->name }}</th>
                            @endforeach

                            <th><i class="fas fa-coins mr-1"></i> Total</th>
                        </tr>
                    </thead>

                    <tbody class="text-center align-middle">
                        @foreach ($waiters as $waiter)
                            <tr>
                                <th class="text-center text-primary" style="white-space: nowrap;">
                                    <i class="fas fa-user mr-1"></i> {{ $waiter->name }}
                                </th>

                                @php $waiterTotal = 0; @endphp

                                @foreach ($tables as $table)
                                    @php
                                        $count = App\Models\Sale::where([
                                            ['status', 'credit'],
                                            ['due', '>', 0],
                                            ['waiter_id', $waiter->id],
                                        ])
                                            ->where('table_id', $table->id)
                                            ->sum('due');

                                        $waiterTotal += $count;

                                        $sales = App\Models\Sale::where([
                                            ['status', 'credit'],
                                            ['due', '>', 0],
                                            ['waiter_id', $waiter->id],
                                        ])
                                            ->where('table_id', $table->id)
                                            ->get();
                                    @endphp

                                    <td>
                                        @foreach ($sales as $sale)
                                            <a href="#" data-toggle="modal" data-target=".sale-{{ $sale->id }}"
                                                class="text-dark font-weight-bold">
                                                {{ number_format($count) }}
                                            </a>

                                            <!-- Modal -->
                                            <div class="modal fade sale-{{ $sale->id }}" tabindex="-1" role="dialog"
                                                aria-hidden="true">
                                                <div class="modal-dialog modal-lg" role="document">
                                                    <div class="modal-content shadow">
                                                        <div class="card">
                                                            <div class="card-header bg-primary text-white text-center">
                                                                <h5 class="mb-1">
                                                                    <i class="fas fa-user-tie mr-1"></i> Waiter:
                                                                    <strong>{{ $sale->waiter->name }}</strong>
                                                                </h5>
                                                                <h6>
                                                                    <i class="fas fa-chair mr-1"></i> Table:
                                                                    <strong>{{ $sale->table->name }}</strong>
                                                                </h6>
                                                            </div>

                                                            <div class="card-body">
                                                                <table class="table table-striped text-center">
                                                                    <thead class="thead-light">
                                                                        <tr>
                                                                            <th>#</th>
                                                                            <th class="text-left">Product</th>
                                                                            <th>Unit</th>
                                                                            <th>Price</th>
                                                                            <th>Qty</th>
                                                                            <th>Amount</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        @php
                                                                            $items = App\Models\SoldItem::where(
                                                                                'sale_id',
                                                                                $sale->id,
                                                                            )
                                                                                ->with('unit', 'product')
                                                                                ->get();
                                                                            $waiterOrderTotal = 0;
                                                                        @endphp

                                                                        @foreach ($items as $item)
                                                                            @if ($item->product)
                                                                                @php $waiterOrderTotal += $item->amount; @endphp
                                                                                <tr>
                                                                                    <td>{{ $loop->iteration }}</td>
                                                                                    <td class="text-left">
                                                                                        {{ $item->product->product }}</td>
                                                                                    <td>{{ $item->unit->name }}</td>
                                                                                    <td>{{ number_format($item->price) }}
                                                                                    </td>
                                                                                    <td>{{ $item->qty }}</td>
                                                                                    <td>{{ number_format($item->price * $item->qty) }}
                                                                                    </td>
                                                                                </tr>
                                                                            @endif
                                                                        @endforeach

                                                                        <tr class="table-info font-weight-bold">
                                                                            <td colspan="4"></td>
                                                                            <td>Total</td>
                                                                            <td>{{ number_format($waiterOrderTotal) }}</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td colspan="4"></td>
                                                                            <td class="text-danger">- Paid</td>
                                                                            <td class="text-danger">
                                                                                ({{ number_format($sale->paid) }})
                                                                            </td>
                                                                        </tr>
                                                                        <tr class="table-warning font-weight-bold">
                                                                            <td colspan="4"></td>
                                                                            <td>Due</td>
                                                                            <td>{{ number_format($waiterOrderTotal - $sale->paid) }}
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>

                                                            <div class="card-footer text-center">
                                                                <div class="btn-group" role="group">
                                                                    <a href="{{ route('print.bill', ['sellingId' => $sale->selling_id, 'tableId' => $sale->table_id, 'waiterId' => $sale->waiter_id]) }}"
                                                                        class="btn btn-primary">
                                                                        <i class="fas fa-print"></i> Print Bill
                                                                    </a>
                                                                    <a href="{{ route('split.bill.view', ['sellingId' => $sale->selling_id, 'tableId' => $sale->table_id, 'waiterId' => $sale->waiter_id]) }}"
                                                                        class="btn btn-success">
                                                                        <i class="fas fa-code-branch mr-1"></i> Split Bill
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </td>
                                @endforeach

                                <th class="text-success font-weight-bold">{{ number_format($waiterTotal) }}</th>
                            </tr>
                        @endforeach
                    </tbody>

                    <tfoot class="bg-light font-weight-bold text-center">
                        <tr>
                            <th><i class="fas fa-user-tie mr-1"></i> Waiters</th>
                            @foreach ($tables as $table)
                                <th>
                                    {{ number_format(
                                        App\Models\Sale::where('status', 'credit')->where('due', '>', 0)->where('table_id', $table->id)->sum('total'),
                                    ) }}
                                </th>
                            @endforeach
                            <th>Total</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

@section('scripts')
    <script>
        $("#customer").DataTable({
            "pageLength": 50,
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');
    </script>
@endsection

@endsection
