@extends('layouts.master')

@section('content')
    <div class="card">
        <div class="card-header">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-danger btn-sm" id="deleteall"><i class="fa-solid fa-trash-alt"></i> Delete
                    Selected</button>

                <!-- Large modal -->
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target=".customer"><i
                        class="fa-solid fa-plus"></i>
                    New waiter</button>
            </div>

            <div class="modal fade customer" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">

                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Register new waiter</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <form action="{{ route('waiters.store') }}" method="post" class="was-validated">
                            @csrf

                            <div class="modal-body">
                                <label for="name">Name</label>
                                <input type="text" name="name" class="form-control" id="name" required>

                                <label for="phone">Phone</label>
                                <input type="text" name="phone" class="form-control" id="phone" required>

                                <label for="address">Address</label>
                                <input type="text" name="address" class="form-control" id="address" required>

                                <label for="password">Password</label>
                                <input type="text" name="password" class="form-control" id="password" required>

                                <label for="location">Location</label>
                                <select name="location" id="location" class="form-control" required>
                                    <option value="">-- Select Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->id }}">
                                            -- {{ $selling->location->name }} --
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary btn-block">
                                    <i class="fa-solid fa-paper-plane"></i> Register
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body table-responsive">
            <table id="customer" class="table table-striped table-hover table-bordered align-middle">
                <thead class="thead-dark text-center">
                    <tr>
                        <th style="width:5%">
                            <input type="checkbox" id="checkall">
                        </th>
                        <th style="width:5%"><i class="fas fa-hashtag"></i></th>
                        <th><i class="fas fa-user-tag me-1"></i> Name</th>
                        <th><i class="fas fa-phone me-1"></i> Phone</th>
                        <th><i class="fas fa-map-marker-alt me-1"></i> Address</th>
                        <th><i class="fas fa-location-arrow me-1"></i> Location</th>
                        <th style="width:15%"><i class="fas fa-cogs me-1"></i> Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($waiters as $waiter)
                        <tr id="tr{{ $waiter->id }}">
                            <td class="text-center">
                                <input type="checkbox" class="selected" id="{{ $waiter->id }}">
                            </td>
                            <td class="text-center">{{ $loop->iteration }}</td>

                            <td>
                                <i class="fas fa-user text-primary me-1"></i>
                                <strong>{{ $waiter->name }}</strong>
                            </td>

                            <td>
                                <i class="fas fa-phone-alt text-info me-1"></i>
                                <span class="badge badge-primary">{{ $waiter->phone }}</span>
                            </td>

                            <td>
                                <i class="fas fa-map text-muted me-1"></i>
                                <span class="text-muted">{{ $waiter->address }}</span>
                            </td>

                            <td>
                                <i class="fas fa-map-pin text-warning me-1"></i>
                                <span class="text-muted">{{ $waiter->selling->location->name }}</span>
                            </td>

                            <td>
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-sm btn-primary" data-toggle="modal"
                                        data-target="#edit-{{ $waiter->id }}" title="Edit">
                                        <i class="fas fa-edit"></i> Edit
                                    </button>

                                    <button type="button" class="btn btn-sm btn-danger delete" id="{{ $waiter->id }}"
                                        title="Delete">
                                        <i class="fas fa-trash-alt"></i> Delete
                                    </button>
                                </div>

                                <!-- Edit Modal -->
                                <div class="modal fade" id="edit-{{ $waiter->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="editWaiterLabel{{ $waiter->id }}" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <form action="{{ route('waiters.update', $waiter->id) }}" method="get"
                                                class="was-validated">
                                                <div class="modal-header bg-primary text-white">
                                                    <h5 class="modal-title" id="editWaiterLabel{{ $waiter->id }}">
                                                        <i class="fas fa-pen me-1"></i> Update Waiter Details
                                                    </h5>
                                                    <button type="button" class="close text-white" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>

                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label for="name-{{ $waiter->id }}"><i class="fas fa-user"></i>
                                                            Name</label>
                                                        <input type="text" name="name" class="form-control"
                                                            value="{{ $waiter->name }}" id="name-{{ $waiter->id }}"
                                                            required>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="phone-{{ $waiter->id }}"><i
                                                                class="fas fa-phone"></i> Phone</label>
                                                        <input type="text" name="phone"
                                                            id="phone-{{ $waiter->id }}" class="form-control"
                                                            value="{{ $waiter->phone }}" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="address-{{ $waiter->id }}"><i
                                                                class="fas fa-map"></i> Address</label>
                                                        <input type="text" name="address" class="form-control"
                                                            value="{{ $waiter->address }}"
                                                            id="address-{{ $waiter->id }}" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="password-{{ $waiter->id }}"><i
                                                                class="fas fa-key"></i> Password</label>
                                                        <input type="text" name="password"
                                                            id="password-{{ $waiter->id }}" class="form-control"
                                                            placeholder="Leave blank to keep current password">
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="location"><i class="fas fa-map-pin"></i>
                                                            Location</label>
                                                        <select name="location" id="location" class="form-control"
                                                            required>
                                                            <option value="">-- Select Location --</option>
                                                            @foreach ($sellings as $selling)
                                                                <option value="{{ $selling->id }}"
                                                                    {{ $waiter->selling_id == $selling->id ? 'selected' : '' }}>
                                                                    {{ $selling->location->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="modal-footer">
                                                    <button class="btn btn-success btn-block">
                                                        <i class="fas fa-paper-plane"></i> Save Update
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center bg-light">
                                <div class="py-5">
                                    <h4 class="text-secondary mb-3">
                                        <i class="fa-solid fa-folder-open fa-2x"></i>
                                    </h4>
                                    <h5 class="text-secondary">No waiters found</h5>
                                    <p class="text-muted">There are currently no waiters available. Click below to add one.
                                    </p>
                                    <button type="button" class="btn btn-primary btn-sm mt-2" data-toggle="modal"
                                        data-target=".customer">
                                        <i class="fa-solid fa-plus"></i> New Waiter
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>

        </div>
    </div>

    @section('scripts')
        <script>
            $(document).ready(function() {
                $("#customer").DataTable({
                    "responsive": true,
                    "lengthChange": false,
                    "autoWidth": false,
                    "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

                $("#checkall").on("click", function() {
                    if ($(this).is(':checked', true)) {
                        $(".selected").prop('checked', true);
                    } else {
                        $(".selected").prop('checked', false);
                    }
                });

                $("#deleteall").on("click", function() {
                    var selected = [];
                    $(".selected:checked").each(function() {
                        selected.push($(this).attr("id"));
                    });

                    if (selected.length === 0) {
                        Swal.fire({
                            title: 'Error',
                            text: 'Select at least one item!',
                            icon: 'error',
                            showConfirmButton: true
                        });
                    } else {
                        Swal.fire({
                            title: 'Are you sure?',
                            text: "You won't be able to revert this!",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: 'Yes, delete it!'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajax({
                                    url: "{{ route('waiters.bulk.delete') }}",
                                    method: "GET",
                                    data: {
                                        ids: selected
                                    },
                                    success: function(data) {
                                        selected.forEach(function(id) {
                                            $("#tr" + id).remove();
                                        });

                                        Swal.fire({
                                            icon: 'success',
                                            title: 'Success!',
                                            text: 'Deleted Successfully',
                                            background: '#e6ffed',
                                            showConfirmButton: false,
                                            timer: 2500,
                                            timerProgressBar: true,
                                            position: 'top-end',
                                            toast: true,
                                            customClass: {
                                                popup: 'swal2-border-radius'
                                            }
                                        });
                                    },
                                    error: function() {
                                        Swal.fire({
                                            icon: 'error',
                                            title: 'Oops...',
                                            text: 'Something went wrong!',
                                            background: '#ffe6e6',
                                            showConfirmButton: false,
                                            timer: 2500,
                                            timerProgressBar: true,
                                            position: 'top-end',
                                            toast: true,
                                            customClass: {
                                                popup: 'swal2-border-radius'
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });

                $(".delete").on("click", function(e) {
                    let id = $(this).attr("id");

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('waiters.destroy') }}", // Adjust if using named route
                                type: "DELETE",
                                data: {
                                    id: id,
                                    _token: $('meta[name="csrf-token"]').attr(
                                        'content') // Ensure CSRF token exists in <meta>
                                },
                                success: function(response) {
                                    if (response.success) {
                                        $("#tr" + id).remove(); // remove the row
                                        Swal.fire({
                                            icon: 'success',
                                            title: 'Success!',
                                            text: 'Deleted Successfully',
                                            background: '#e6ffed',
                                            showConfirmButton: false,
                                            timer: 2500,
                                            timerProgressBar: true,
                                            position: 'top-end',
                                            toast: true,
                                            customClass: {
                                                popup: 'swal2-border-radius'
                                            }
                                        });
                                    }
                                },
                                error: function(response) {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Oops...',
                                        text: response.message,
                                        background: '#ffe6e6',
                                        showConfirmButton: false,
                                        timer: 2500,
                                        timerProgressBar: true,
                                        position: 'top-end',
                                        toast: true,
                                        customClass: {
                                            popup: 'swal2-border-radius'
                                        }
                                    });
                                }
                            });
                        }
                    });
                });
            });
        </script>
    @endsection

@endsection
