<?php

use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
})->middleware('check.license');

Route::get('/opening/closing/stock', function () {
    return view('opening-and-closing');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified', 'check.license'])->name('dashboard');

Route::get('/payment/reminder', [App\Http\Controllers\HomeController::class, 'paymentReminder'])->name('payment.reminder');

Route::middleware('auth', 'check.license')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    # Dashboard routes
    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    Route::get('/madeni-ya-leo-wateja', [App\Http\Controllers\HomeController::class, 'madeniyaleowateja'])->name('madeni.ya.wateja');
    Route::get('/madeni-ya-leo-mawaiter', [App\Http\Controllers\HomeController::class, 'madeniyamawaiter'])->name('madeni.ya.mawaiter');
    Route::get('/bad-debts', [App\Http\Controllers\HomeController::class, 'badDebts'])->name('bad.debts');
    Route::get('/royalty-report', [App\Http\Controllers\HomeController::class, 'royalty'])->name('royalty.report');

    // Route::get('/payment-reminder', [App\Http\Controllers\HomeController::class, 'paymentReminder'])->name('payment.reminder');
    Route::GET('/ipcheck', [App\Http\Controllers\HomeController::class, 'ipcheck'])->name('ipcheck');
    Route::GET('/expired/products', [App\Http\Controllers\HomeController::class, 'expiredProducts'])->name('expired.products');
    Route::GET('/products/about/to/expire/{locationId}', [App\Http\Controllers\HomeController::class, 'productsAboutToExpire'])->name('products.about.to.expire');
    Route::GET('/minimum/level', [App\Http\Controllers\HomeController::class, 'minimumLevel'])->name('minimum.level.products');
    Route::GET('/items/missing/prices/{sellingId}', [App\Http\Controllers\HomeController::class, 'itemsMissingPrices'])->name('items.missing.prices');
    Route::GET('/todays/pending/purchase/view', [App\Http\Controllers\HomeController::class, 'todaysPendingPurchaseView'])->name('today.pending.purchase.view');
    Route::GET('/passed/pending/purchase/view', [App\Http\Controllers\HomeController::class, 'passedPendingPurchaseView'])->name('passed.pending.purchase.view');

    # Room routes
    Route::GET('/rooms', [App\Http\Controllers\RoomsController::class, 'index'])->name('rooms.index');
    Route::POST('/rooms/store', [App\Http\Controllers\RoomsController::class, 'store'])->name('rooms.store');
    Route::PUT('/room/update/{id}', [App\Http\Controllers\RoomsController::class, 'update'])->name('room.update');
    Route::GET('/update/room/price/view/{id}', [App\Http\Controllers\RoomsController::class, 'updateRoomPriceView'])->name('update.room.price.view');
    Route::GET('/update/room/price/{id}', [App\Http\Controllers\RoomsController::class, 'updateRoomPrice'])->name('update.room.price');
    Route::DELETE('/room/delete/{id}', [App\Http\Controllers\RoomsController::class, 'destroy'])->name('room.destroy');

    Route::get('/delete-room-price/{id}', [App\Http\Controllers\RoomsController::class, 'deleteRoomPrice'])->name('delete.room.price');
    Route::get('/room-transfer/{id}', [App\Http\Controllers\RoomsController::class, 'roomTransfer'])->name('room.transfer');
    Route::post('/room-block/{id}', [App\Http\Controllers\RoomsController::class, 'block'])->name('room.block');
    Route::get('/search-rooms', [App\Http\Controllers\RoomsController::class, 'searchRooms'])->name('room.search');
    Route::get('/dirty-rooms', [App\Http\Controllers\RoomsController::class, 'dirtyRooms'])->name('dirty.rooms');
    Route::get('/construction-rooms', [App\Http\Controllers\RoomsController::class, 'constructionRooms'])->name('construction.rooms');
    Route::get('/rooms-bulk-delete', [App\Http\Controllers\RoomsController::class, 'bulkDelete'])->name('rooms.bulk.delete');

    # Waiters routes
    Route::get('/waiters', [App\Http\Controllers\WaitersController::class, 'index'])->name('waiters.index');
    Route::post('/waiters/store', [App\Http\Controllers\WaitersController::class, 'store'])->name('waiters.store');
    Route::get('waiter/update/{id}', [App\Http\Controllers\WaitersController::class, 'update'])->name('waiters.update');
    Route::delete('waiter/delete', [App\Http\Controllers\WaitersController::class, 'destroy'])->name('waiters.destroy');
    Route::get('/waiters/bulk/delete', [App\Http\Controllers\WaitersController::class, 'bulkDelete'])->name('waiters.bulk.delete');

    # Location routes
    Route::get('/location', [App\Http\Controllers\LocationController::class, 'index'])->name('location.index');
    Route::post('/location-store', [App\Http\Controllers\LocationController::class, 'store'])->name('location.store');
    Route::get('location-update/{id}', [App\Http\Controllers\LocationController::class, 'update'])->name('location.update');
    Route::get('location-delete/{id}', [App\Http\Controllers\LocationController::class, 'destroy'])->name('location.delete');
    Route::get('/location-bulk-delete', [App\Http\Controllers\LocationController::class, 'bulkDelete'])->name('location.bulk.delete');
    Route::get('/location-status', [App\Http\Controllers\LocationController::class, 'locationStatus'])->name('location.status');

    # Booking routes
    Route::GET('/booking', [App\Http\Controllers\BookingController::class, 'index'])->name('booking.index');
    Route::POST('/booking/store/{id}', [App\Http\Controllers\BookingController::class, 'booking'])->name('booking.store');
    Route::GET('/booking/update/{id}', [App\Http\Controllers\BookingController::class, 'update'])->name('booking.update');
    Route::GET('/booking/delete/{id}', [App\Http\Controllers\BookingController::class, 'destroy'])->name('booking.delete');
    Route::GET('/upcoming/bookings', [App\Http\Controllers\BookingController::class, 'upcomingBookings'])->name('upcoming.bookings');
    Route::POST('/booking/checkin/{id}', [App\Http\Controllers\BookingController::class, 'bookingCheckin'])->name('booking.checkin');
    Route::GET('/inside/customers/{status}', [App\Http\Controllers\BookingController::class, 'insideCustomers'])->name('inside.customers');
    Route::GET('/check/out/view/{room}', [App\Http\Controllers\BookingController::class, 'checkoutView'])->name('checkout.view');
    Route::GET('/check/out/{id}', [App\Http\Controllers\BookingController::class, 'checkout'])->name('checkout');
    Route::GET('/customer/bookings', [App\Http\Controllers\BookingController::class, 'customerBookings'])->name('customer.bookings');
    Route::GET('/customer/check/out', [App\Http\Controllers\BookingController::class, 'customerCheckout'])->name('customer.checking.out');
    Route::GET('/booking/deposit/{id}', [App\Http\Controllers\BookingController::class, 'bookingDeposit'])->name('booking.deposit');

    # Customer routes
    Route::get('/customer', [App\Http\Controllers\CustomerController::class, 'index'])->name('customer.index');
    Route::post('/customer-store', [App\Http\Controllers\CustomerController::class, 'store'])->name('customer.store');
    Route::get('/customer-update/{id}', [App\Http\Controllers\CustomerController::class, 'update'])->name('customer.update');
    Route::get('/customer-delete/{id}', [App\Http\Controllers\CustomerController::class, 'destroy'])->name('customer.delete');
    Route::get('/get customer', [App\Http\Controllers\CustomerController::class, 'getCustomer'])->name('get.customer');
    Route::get('/customer-advance-payment/{id}', [App\Http\Controllers\CustomerController::class, 'advancePayment'])->name('customer.advance.payment');
    Route::get('/check-credit-limit', [App\Http\Controllers\CustomerController::class, 'creditLimit'])->name('check.credit.limit');
    Route::get('/customer-bulk-delete', [App\Http\Controllers\CustomerController::class, 'bulkDelete'])->name('customer.bulk.delete');
    Route::post('/upload-customer-excel', [App\Http\Controllers\CustomerController::class, 'uploadCustomerExcel'])->name('upload.customer.excel');

    # Customer Order Route.
    Route::GET('/customer/order', [App\Http\Controllers\CustomerOrderController::class, 'index'])->name('customer.order.index');
    Route::POST('/customer/order/store/{flag}/{id}', [App\Http\Controllers\CustomerOrderController::class, 'store'])->name('customer.order.store');
    Route::GET('/customer/order/update/{id}', [App\Http\Controllers\CustomerOrderController::class, 'update'])->name('customer.order.update');
    Route::GET('/customer/order/delete', [App\Http\Controllers\CustomerOrderController::class, 'destroy'])->name('customer.order.delete');
    Route::GET('/new/customer/order/{flag}/{id}', [App\Http\Controllers\CustomerOrderController::class, 'newCustomerOrder'])->name('new.customer.order');
    Route::GET('/customer/order/p&l', [App\Http\Controllers\CustomerOrderController::class, 'profitAndLoss'])->name('customer.order.profit.and.loss');
    Route::GET('/customer/order/payment/{id}', [App\Http\Controllers\CustomerOrderController::class, 'CustomerOrderPayment'])->name('customer.order.payment');

    # Vehicle routes
    Route::GET('/vehicle/index', [App\Http\Controllers\VehicleController::class, 'index'])->name('vehicle.index');
    Route::GET('/load/vehicle', [App\Http\Controllers\VehicleController::class, 'loadView'])->name('load.vehicle.view');
    Route::GET('/unload/vehicle', [App\Http\Controllers\VehicleController::class, 'unloadView'])->name('unload.vehicle.view');
    Route::POST('/load/vehicle/store', [App\Http\Controllers\VehicleController::class, 'loadVehicleStore'])->name('load.vehicle.store');
    Route::GET('/unload/vehicle/store', [App\Http\Controllers\VehicleController::class, 'unloadVehicleStore'])->name('unload.vehicle.store');
    Route::POST('/vehicle/store', [App\Http\Controllers\VehicleController::class, 'store'])->name('vehicle.store');
    Route::GET('/vehicle/update/{id}', [App\Http\Controllers\VehicleController::class, 'update'])->name('vehicle.update');
    Route::GET('/vehicle/destroy/{id}', [App\Http\Controllers\VehicleController::class, 'destroy'])->name('vehicle.destroy');
    Route::GET('/vehicle/bulk/delete', [App\Http\Controllers\VehicleController::class, 'bulkDelete'])->name('vehicle.bulk.delete');
    Route::GET('/total-value-loaded', [App\Http\Controllers\VehicleController::class, 'totalValueLoaded'])->name('total.value.loaded');
    Route::GET('/loaded-vehicle', [App\Http\Controllers\VehicleController::class, 'loadedVehicle'])->name('loaded.vehicle');
    Route::GET('/delete-loaded-vehicle/{id}', [App\Http\Controllers\VehicleController::class, 'deleteLoadedVehicle'])->name('delete.loaded.vehicle');
    Route::GET('/loaded-items-bulk-delete', [App\Http\Controllers\VehicleController::class, 'loadedItemsBulkDelete'])->name('loaded.items.bulk.delete');

    # Drivers routes
    Route::GET('/driver/index', [App\Http\Controllers\DriverController::class, 'index'])->name('driver.index');
    Route::POST('/driver/store', [App\Http\Controllers\DriverController::class, 'store'])->name('driver.store');
    Route::PUT('/driver/update/{id}', [App\Http\Controllers\DriverController::class, 'update'])->name('driver.update');
    Route::DELETE('/driver/destroy/{id}', [App\Http\Controllers\DriverController::class, 'destroy'])->name('driver.destroy');
    Route::POST('/drivers/bulk/delete', [App\Http\Controllers\DriverController::class, 'bulkDelete'])->name('drivers.bulk.delete');

    # Sales men routes
    Route::GET('/salesmen/index', [App\Http\Controllers\SalesmenController::class, 'index'])->name('salesmen.index');
    Route::POST('/salesmen/store', [App\Http\Controllers\SalesmenController::class, 'store'])->name('salesmen.store');
    Route::PUT('/salesmen/update/{id}', [App\Http\Controllers\SalesmenController::class, 'update'])->name('salesmen.update');
    Route::POST('/salesmen/delete/{id}', [App\Http\Controllers\SalesmenController::class, 'destroy'])->name('salesmen.destroy');
    Route::POST('/salesmen/bulk/delete', [App\Http\Controllers\SalesmenController::class, 'bulkDelete'])->name('salesmen.bulk.delete');

    # Supplier routes
    Route::GET('/supplier', [App\Http\Controllers\SupplierController::class, 'index'])->name('supplier.index');
    Route::POST('/supplier/store', [App\Http\Controllers\SupplierController::class, 'store'])->name('supplier.store');
    Route::PUT('/supplier/update/{id}', [App\Http\Controllers\supplierController::class, 'update'])->name('supplier.update');
    Route::GET('/supplier/delete/{id}', [App\Http\Controllers\SupplierController::class, 'destroy'])->name('supplier.delete');
    Route::GET('/supplier/advance-payment/{id}', [App\Http\Controllers\SupplierController::class, 'advancePayment'])->name('supplier.advance.payment');
    Route::GET('/get/supplier', [App\Http\Controllers\SupplierController::class, 'getSupplier'])->name('get.supplier');
    Route::GET('/get/supplier/advance', [App\Http\Controllers\SupplierController::class, 'getSupplierAdvance'])->name('get.supplier.advance');
    Route::GET('/supplier/bulk/delete', [App\Http\Controllers\SupplierController::class, 'bulkDelete'])->name('supplier.bulk.delete');
    Route::POST('/upload/supplier/excel', [App\Http\Controllers\SupplierController::class, 'uploadSupplierExcel'])->name('upload.supplier.excel');

    # Account routes
    Route::get('/account', [App\Http\Controllers\AccountController::class, 'index'])->name('account.index');
    Route::post('/account-store', [App\Http\Controllers\AccountController::class, 'store'])->name('account.store');
    Route::put('/account-update/{id}', [App\Http\Controllers\AccountController::class, 'update'])->name('account.update');
    Route::get('/account-delete/{id}', [App\Http\Controllers\AccountController::class, 'destroy'])->name('account.delete');
    Route::post('/cash-deposit', [App\Http\Controllers\AccountController::class, 'cashDeposite'])->name('cash.deposite');
    Route::post('/cash-transfer', [App\Http\Controllers\AccountController::class, 'cashTransfer'])->name('cash.transfer');
    Route::post('/cash-withdraw', [App\Http\Controllers\AccountController::class, 'cashWithdraw'])->name('cash.withdraw');
    Route::get('/get-account-balance', [App\Http\Controllers\AccountController::class, 'accountBalance'])->name('get.account.balance');
    Route::get('/account-bulk-delete', [App\Http\Controllers\AccountController::class, 'bulkDelete'])->name('account.bulk.delete');
    Route::get('/get-location-accounts', [App\Http\Controllers\AccountController::class, 'getLocationAccounts'])->name('get.location.accounts');
    Route::get('/accounts-balance-per-duration', [App\Http\Controllers\AccountController::class, 'AccountBalancePerDuration'])->name('accounts.balance.per.duration');

    # Expense category routes
    Route::get('/expense/category', [App\Http\Controllers\ExpenseCategoryController::class, 'index'])->name('expense.category.index');
    Route::post('/expense/category/store', [App\Http\Controllers\ExpenseCategoryController::class, 'store'])->name('expense.category.store');
    Route::get('/expense/category/delete/{id}', [App\Http\Controllers\ExpenseCategoryController::class, 'destroy'])->name('expense.category.destroy');
    Route::get('/expense/category/update/{id}', [App\Http\Controllers\ExpenseCategoryController::class, 'update'])->name('expense.category.update');
    Route::get('/expense/category/bulk-delete', [App\Http\Controllers\ExpenseCategoryController::class, 'bulkDelete'])->name('expense.category.bulk.delete');

    # Sale routes
    Route::GET('/sales/{id}/{status}', [App\Http\Controllers\SaleController::class, 'index'])->name('sale.index');
    Route::POST('/store/sales/{status}', [App\Http\Controllers\SaleController::class, 'store'])->name('store.sales');
    Route::post('/sales/{id}/cancel', [App\Http\Controllers\SaleController::class, 'cancel'])->name('sales.cancel');
    Route::GET('/print/receipt/{id}', [App\Http\Controllers\SaleController::class, 'receipt'])->name('print.receipt');
    Route::get('/sales/print-temp/{id}', [App\Http\Controllers\SaleController::class, 'printTemp'])->name('sales.print-temp');
    Route::GET('/split/bill/view/{sellingId}/{tableId}/{waiterId}', [App\Http\Controllers\SaleController::class, 'splitBillView'])->name('split.bill.view');
    Route::POST('/split/bill', [App\Http\Controllers\SaleController::class, 'splitBill'])->name('split.bill');
    Route::GET('/sales/return/view/index', [App\Http\Controllers\SaleController::class, 'returnView'])->name('sales.return.view.index');
    Route::post('/post/sales/return', [App\Http\Controllers\SaleController::class, 'salesReturn'])->name('post.sales.return');
    Route::GET('/sales/receipts', [App\Http\Controllers\SaleController::class, 'SalesReceipt'])->name('sales.reciept');
    Route::GET('/get/specific/sale/{id}', [App\Http\Controllers\SaleController::class, 'getSpecificSale'])->name('get.specific.sale');
    Route::POST('/sales/bulk/delete', [App\Http\Controllers\SaleController::class, 'bulkDelete'])->name('sales.bulk.delete');
    Route::GET('/change/sales/date', [App\Http\Controllers\SaleController::class, 'changeDate'])->name('change.sales.date');
    Route::POST('/pay/customer/debt/{id}', [App\Http\Controllers\SaleController::class, 'payCustomerDebt'])->name('pay.customer.debt');
    Route::POST('/pay/customer/debt/history/{customerId}', [App\Http\Controllers\SaleController::class, 'payCustomerDebtHistory'])->name('pay.customer.debt.history');
    Route::POST('/upload/sales/excel', [App\Http\Controllers\SaleController::class, 'uploadSalesExcel'])->name('upload.sales.excel');
    Route::GET('/solditems/missing/productid', [App\Http\Controllers\SaleController::class, 'itemsMissingProductId'])->name('solditems.missing.productid');
    Route::GET('/edit/customer/order/{id}', [App\Http\Controllers\SaleController::class, 'editCustomerOrder'])->name('edit.customer.order');
    Route::GET('/cancel/sales/{id}/{status}', [App\Http\Controllers\SaleController::class, 'cancelSale'])->name('cancel.sales');
    Route::GET('/customer/advance/checker/', [App\Http\Controllers\SaleController::class, 'advanceCheker'])->name('customer.advance.checker');

    # Proforma routes
    Route::get('/proforma-invoice-view', [App\Http\Controllers\ProfomaController::class, 'index'])->name('profoma.invoice.view');
    Route::get('/new-profoma-invoice', [App\Http\Controllers\ProfomaController::class, 'newProfomaInvoice'])->name('new.profoma.invoice');
    Route::post('/print-profoma-invoice/{status}', [App\Http\Controllers\ProfomaController::class, 'store'])->name('print.profoma.invoice');
    Route::get('/delete-profoma/{id}', [App\Http\Controllers\ProfomaController::class, 'destroy'])->name('profoma.delete');
    Route::get('/print-delivery/{id}', [App\Http\Controllers\ProfomaController::class, 'printDelivery'])->name('print.delivery');
    Route::get('/get-profoma/{id}', [App\Http\Controllers\ProfomaController::class, 'getProfoma'])->name('get.profoma.invoice');
    Route::get('/profoma-bulk-delete', [App\Http\Controllers\ProfomaController::class, 'bulkDelete'])->name('profoma.bulk.delete');
    Route::get('/cancel-profoma-invoice', [App\Http\Controllers\ProfomaController::class, 'cancelProfomaInvoice'])->name('cancel.profoma.invoice');

    # Purchase routes
    Route::get('/purchase/{id}/{status}', [App\Http\Controllers\PurchaseController::class, 'index'])->name('purchase.view');
    Route::post('/store-purchase', [App\Http\Controllers\PurchaseController::class, 'store'])->name('store.purchase');
    Route::get('/pay-invoice/{id}', [App\Http\Controllers\PurchaseController::class, 'payInvoice'])->name('pay.invoice');
    Route::get('/purchase-return-view', [App\Http\Controllers\PurchaseController::class, 'returnView'])->name('purchase.return.view');
    Route::post('/post-purchase-return', [App\Http\Controllers\PurchaseController::class, 'purchaseReturn'])->name('post.purchase.return');
    Route::post('/purchases-bulk-delete', [App\Http\Controllers\PurchaseController::class, 'bulkDelete'])->name('purchases.bulk.delete');
    Route::get('/purchased-items-missing-productid', [App\Http\Controllers\PurchaseController::class, 'itemsMissingProductId'])->name('purchased.items.missing.productid');
    Route::get('/pay-supplier-debt-history/{supplier_id}', [App\Http\Controllers\PurchaseController::class, 'paySupplierDebtHistory'])->name('pay.Supplier.debt.history');
    Route::get('/cancel-purchase', [App\Http\Controllers\PurchaseController::class, 'cancelPurchase'])->name('cancel.purchase');

    # Purchase order routes
    Route::get('/purchase-order', [App\Http\Controllers\PurchaseOrderController::class, 'index'])->name('purchase.order.view');
    Route::get('/get-purchase-order/{id}', [App\Http\Controllers\PurchaseOrderController::class, 'getPurchaseOrder'])->name('get.purchase.order');
    Route::get('/delete-purchase-order/{id}', [App\Http\Controllers\PurchaseOrderController::class, 'destroy'])->name('delete.purchase.order');
    Route::get('/purchase-order-bulk.delete', [App\Http\Controllers\PurchaseOrderController::class, 'bulkDelete'])->name('purchase.order.bulk.delete');
    Route::get('/new-purchase-order/{flag}', [App\Http\Controllers\PurchaseOrderController::class, 'newPurchaseOrder'])->name('new.purchase.order');
    Route::post('/print-purchase-order/{flag}/{id?}',  [App\Http\Controllers\PurchaseOrderController::class, 'store'])->name('print.purchase.order');

    Route::get('/edit-purchase-order/{id}/{flag}', [App\Http\Controllers\PurchaseOrderController::class, 'editPurchaseOrder'])->name('edit.purchase.order');
    Route::get('/clear-purchase-order', [App\Http\Controllers\PurchaseOrderController::class, 'clearPurchaseOrder'])->name('clear.purchase.order');

    # Requisition route
    Route::get('/index/requisition', [App\Http\Controllers\RequisitionController::class, 'index'])->name('requisitions');
    Route::get('/create/requisition', [App\Http\Controllers\RequisitionController::class, 'create'])->name('requisition.create');
    Route::post('/store/requisition', [App\Http\Controllers\RequisitionController::class, 'store'])->name('requisition.store');
    Route::delete('/delete/requisition', [App\Http\Controllers\RequisitionController::class, 'destroy'])->name('requisition.destroy');
    Route::get('update-/requisition', [App\Http\Controllers\RequisitionController::class, 'pendingRequisition'])->name('pending.requisition');
    Route::get('approve/requisition', [App\Http\Controllers\RequisitionController::class, 'updateStatus'])->name('approve.requisition');
    Route::put('/requisitions/{requisition}', [App\Http\Controllers\RequisitionController::class, 'update'])->name('requisition.update');
    Route::get('/requisitions/bulk/delete', [App\Http\Controllers\RequisitionController::class, 'bulkDelete'])->name('requisitions.bulk.delete');
    Route::get('/requisitions/print/{requisitionId}', [App\Http\Controllers\RequisitionController::class, 'print'])->name('requisitions.print');

    # Place oder routes
    Route::GET('/place/order/{status}', [App\Http\Controllers\PlaceOderController::class, 'index'])->name('place.oder.index');
    Route::GET('/validate/waiters/details/', [App\Http\Controllers\PlaceOderController::class, 'validateWaitersDetails'])->name('validate.waiters.details');
    Route::GET('/cancel/order/view', [App\Http\Controllers\PlaceOderController::class, 'cancelOrderView'])->name('cancel.order.view');
    Route::GET('/cancel/order', [App\Http\Controllers\PlaceOderController::class, 'cancelOrder'])->name('cancel.order');
    Route::GET('/waiters/oder', [App\Http\Controllers\PlaceOderController::class, 'waitersOder'])->name('waiters.oder');
    Route::GET('/pay/bill/view', [App\Http\Controllers\PlaceOderController::class, 'payBillView'])->name('pay.bill.view');
    Route::GET('/waiters/bill/view', [App\Http\Controllers\PlaceOderController::class, 'waitersBillView'])->name('waiters.bill.view');
    Route::GET('/order', [App\Http\Controllers\PlaceOderController::class, 'order'])->name('order');
    Route::POST('/store/bill', [App\Http\Controllers\PlaceOderController::class, 'store'])->name('store.bill');
    Route::GET('/recent/orders', [App\Http\Controllers\PlaceOderController::class, 'recentOrders']);
    Route::get('/orders/{cart}/modal', [App\Http\Controllers\PlaceOderController::class, 'renderModal']);
    Route::GET('/get/bill', [App\Http\Controllers\PlaceOderController::class, 'getBill'])->name('get.bill');
    Route::GET('/get/waiter/bill', [App\Http\Controllers\PlaceOderController::class, 'getWaiterBill'])->name('get.waiter.bill');
    Route::POST('/clear/bill', [App\Http\Controllers\PlaceOderController::class, 'clearBill'])->name('clear.bill');
    Route::GET('/print/bill/{sellingId}/{tableId}/{waiterId}', [App\Http\Controllers\PlaceOderController::class, 'printBill'])->name('print.bill');
    Route::GET('/qr/code/orders/{waiterId}/{password}', [App\Http\Controllers\PlaceOderController::class, 'qrCodeOrders'])->name('qr.code.orders');
    Route::GET('/mark/order/as/seen/{cartId}/', [App\Http\Controllers\PlaceOderController::class, 'markAsSeen'])->name('mark.order.as.seen');
    Route::get('/fetch/new/orders', [App\Http\Controllers\PlaceOderController::class, 'fetchNewOrders'])->name('fetch.new.orders');

    # Table routes
    Route::get('/table', [App\Http\Controllers\TableController::class, 'index'])->name('table.index');
    Route::post('/table-store', [App\Http\Controllers\TableController::class, 'store'])->name('table.store');
    Route::delete('/table-destroy/{id}', [App\Http\Controllers\TableController::class, 'destroy'])->name('table.destroy');
    Route::get('/table-update/{id}', [App\Http\Controllers\TableController::class, 'update'])->name('table.update');
    Route::get('/tables-bulk-delete', [App\Http\Controllers\TableController::class, 'bulkDelete'])->name('tables.bulk.delete');
    Route::post('/update/position/{type}', [App\Http\Controllers\TableController::class, 'updatePosition'])->name('update.position');
    Route::get('/incomming/table/reservation', [App\Http\Controllers\TableController::class, 'tableReservation'])->name('incomming.table.reservation');
    Route::post('/reservations/{reservation}/checkin', [App\Http\Controllers\TableController::class, 'checkIn'])->name('reservations.checkin');
    Route::post('/reservations/{reservation}/cancel', [App\Http\Controllers\TableController::class, 'cancelReservation'])->name('reservations.cancel');

    # Ingredients routes
    Route::GET('/ingredient', [App\Http\Controllers\IngredientsController::class, 'index'])->name('ingredient.index');
    Route::POST('/store/ingredients', [App\Http\Controllers\IngredientsController::class, 'store'])->name('ingredient.store');
    Route::POST('/upload/ingredients/excel', [App\Http\Controllers\IngredientsController::class, 'uploadIngredients'])->name('upload.ingredients.excel');
    Route::PUT('/ingredient/update/{id}', [App\Http\Controllers\IngredientsController::class, 'update'])->name('ingredient.update');
    Route::DELETE('/ingredient/delete/{id}', [App\Http\Controllers\IngredientsController::class, 'destroy'])->name('ingredient.delete');
    Route::GET('/ingredients/bulk/delete', [App\Http\Controllers\IngredientsController::class, 'bulkDelete'])->name('ingredients.bulk.delete');
    Route::GET('/get/ingredients', [App\Http\Controllers\IngredientsController::class, 'getIngredients'])->name('get.ingredients');
    Route::GET('/delete/menu/item/{id}', [App\Http\Controllers\IngredientsController::class, 'deleteMenuItem'])->name('delete.menu.item');

    # Menu routes
    Route::get('/menu/index', [App\Http\Controllers\MenuController::class, 'menuIndex'])->name('menu.index');
    Route::get('/drink/index', [App\Http\Controllers\MenuController::class, 'drinkIndex'])->name('drink.index');
    Route::POST('/menu/store', [App\Http\Controllers\MenuController::class, 'storeMenu'])->name('menu.store');
    Route::POST('/drink/store', [App\Http\Controllers\MenuController::class, 'storeDrink'])->name('drink.store');
    Route::PUT('/menu/update/{id}', [App\Http\Controllers\MenuController::class, 'updateMenu'])->name('menu.update');
    Route::PUT('/drink/update/{id}', [App\Http\Controllers\MenuController::class, 'updateDrink'])->name('drink.update');
    Route::DELETE('/menu/delete/{id}', [App\Http\Controllers\MenuController::class, 'destroyMenu'])->name('menu.delete');
    Route::GET('/drink/delete/{id}', [App\Http\Controllers\MenuController::class, 'destroyDrink'])->name('drink.delete');
    Route::GET('/menus/bulk/delete', [App\Http\Controllers\MenuController::class, 'bulkDelete'])->name('menus.bulk.delete');
    Route::GET('/assign/ingridients/view/{id}', [App\Http\Controllers\MenuController::class, 'assignIngridientsView'])->name('assign.ingridients.view');
    Route::GET('/assign/ingridients/{id}', [App\Http\Controllers\MenuController::class, 'assignIngridients'])->name('assign.ingridients');
    Route::post('/upload/Menu/excel', [App\Http\Controllers\MenuController::class, 'uploadMenus'])->name('upload.menus.excel');
    Route::GET('/get/category/menu', [App\Http\Controllers\MenuController::class, 'getMenuByCategory'])->name('get.menu.by.category');
    Route::GET('/get/menu/by/category', [App\Http\Controllers\MenuController::class, 'getCategoryMenu'])->name('get.category.menu');

    # Unit routes
    Route::get('/unit', [App\Http\Controllers\UnitController::class, 'index'])->name('unit.index');
    Route::post('/unit-store', [App\Http\Controllers\UnitController::class, 'store'])->name('unit.store');
    Route::get('/unit-delete/{id}', [App\Http\Controllers\UnitController::class, 'destroy'])->name('unit.destroy');
    Route::post('/unit-update/{id}', [App\Http\Controllers\UnitController::class, 'update'])->name('unit.update');
    Route::get('/units-bulk-delete', [App\Http\Controllers\UnitController::class, 'bulkDelete'])->name('units.bulk.delete');

    # Events routes
    Route::get('event', [App\Http\Controllers\EventsController::class, 'index'])->name('event.index');
    Route::post('/event-store', [App\Http\Controllers\EventsController::class, 'store'])->name('event.store');
    Route::get('/event-delete/{id}', [App\Http\Controllers\EventsController::class, 'destroy'])->name('event.destroy');
    Route::post('/event-update/{id}', [App\Http\Controllers\EventsController::class, 'update'])->name('event.update');
    Route::get('/events-bulk-delete', [App\Http\Controllers\EventsController::class, 'bulkDelete'])->name('events.bulk.delete');
    Route::get('/get-event-price', [App\Http\Controllers\EventsController::class, 'eventPrice'])->name('get.event.price');
    Route::get('/upcoming-events', [App\Http\Controllers\EventsController::class, 'upcomingEvents'])->name('upcoming.events');
    Route::get('/inprogress-events', [App\Http\Controllers\EventsController::class, 'inprogressEvents'])->name('inprogress.events');

    # Venue routes
    Route::GET('venue', [App\Http\Controllers\VenueController::class, 'index'])->name('venue.index');
    Route::POST('/venue/store', [App\Http\Controllers\VenueController::class, 'store'])->name('venue.store')->middleware('payment');
    Route::GET('/venue/delete/{id}', [App\Http\Controllers\VenueController::class, 'destroy'])->name('venue.destroy');
    Route::GET('/venue/update/{id}', [App\Http\Controllers\VenueController::class, 'update'])->name('venue.update');
    Route::GET('/venues/bulk-delete', [App\Http\Controllers\VenueController::class, 'bulkDelete'])->name('venues.bulk.delete');
    Route::GET('/venue/block/{id}', [App\Http\Controllers\VenueController::class, 'block'])->name('venue.block');
    Route::GET('/venue/checkout', [App\Http\Controllers\VenueController::class, 'venueCheckout'])->name('venue.checkout');

    # Booking routes
    Route::get('/venue-booking', [App\Http\Controllers\VenueBookingController::class, 'index'])->name('venue.booking.index');
    Route::post('/venue-booking-store', [App\Http\Controllers\VenueBookingController::class, 'store'])->name('venue.booking.store');
    Route::get('/venue-booking-update/{id}', [App\Http\Controllers\VenueBookingController::class, 'update'])->name('venue.booking.update');
    Route::get('/venue-booking-delete/{id}', [App\Http\Controllers\VenueBookingController::class, 'destroy'])->name('venue.booking.delete');
    // Route::get('/venue-upcomming-bookings', [App\Http\Controllers\VenueBookingController::class, 'upcommingBookings'])->name('venue.upcomming.bookings')->middleware('payment');
    // Route::get('/venue-booking-checkin/{id}', [App\Http\Controllers\VenueBookingController::class, 'bookingCheckin'])->name('venue.booking.checkin')->middleware('payment');
    // Route::get('/venue-inside-customers/{status}', [App\Http\Controllers\VenueBookingController::class, 'insideCustomers'])->name('venue.inside.customers')->middleware('payment');
    // Route::get('/venue-check-out-view/{room}', [App\Http\Controllers\VenueBookingController::class, 'checkoutView'])->name('venue.checkout.view')->middleware('payment');
    // Route::get('/venue-check-out/{id}', [App\Http\Controllers\VenueBookingController::class, 'checkout'])->name('venue.checkout')->middleware('payment');
    // Route::get('/venue-customer-bookings', [App\Http\Controllers\VenueBookingController::class, 'customerBookings'])->name('venue.customer.bookings')->middleware('payment');
    // Route::get('/venue-customer-check-out', [App\Http\Controllers\VenueBookingController::class, 'customerCheckout'])->name('venue.customer.checking.out')->middleware('payment');

    # Product category routes
    Route::GET('/product/category', [App\Http\Controllers\ProductCategoryController::class, 'index'])->name('product.category.index');
    Route::POST('/product/category/store', [App\Http\Controllers\ProductCategoryController::class, 'store'])->name('product.category.store');
    Route::GET('/product-category/delete/{id}', [App\Http\Controllers\ProductCategoryController::class, 'destroy'])->name('product.category.destroy');
    Route::PUT('/product/category/update/{id}', [App\Http\Controllers\ProductCategoryController::class, 'update'])->name('product.category.update');
    Route::GET('/product/category/bulk/delete', [App\Http\Controllers\ProductCategoryController::class, 'bulkDelete'])->name('product.category.bulk.delete');

    # Product routes
    Route::GET('/product', [App\Http\Controllers\ProductController::class, 'index'])->name('product.index');
    Route::GET('/stock/reset/view', [App\Http\Controllers\ProductController::class, 'stockResetView'])->name('stock.reset.view');
    Route::GET('/stock/reset', [App\Http\Controllers\ProductController::class, 'stockReset'])->name('stock.reset');
    Route::POST('/upload/product/excel', [App\Http\Controllers\ProductController::class, 'uploadProductExcel'])->name('upload.product.excel');
    Route::GET('/stock/tacking/view', [App\Http\Controllers\ProductController::class, 'stockTackingView'])->name('stock.tacking.view');
    Route::POST('/upload/stock/tacking/excel', [App\Http\Controllers\ProductController::class, 'uploadStockTackingExcel'])->name('upload.stock.tacking.excel');
    Route::GET('/download/stock/tacking/excel', [App\Http\Controllers\ProductController::class, 'downloadStockTackingExcel'])->name('download.stock.tacking.excel');
    Route::GET('/download/rejected/stock/excel', [App\Http\Controllers\ProductController::class, 'downloadRejectedStockExcel'])->name('download.rejected.stock.excel');
    Route::GET('/delete/duplicate/products', [App\Http\Controllers\ProductController::class, 'deleteDuplicateProducts'])->name('delete.duplicate.products');
    Route::POST('/product/store', [App\Http\Controllers\ProductController::class, 'store'])->name('product.store');
    Route::GET('/delete/product/view', [App\Http\Controllers\ProductController::class, 'deleteProductView'])->name('delete.product.view');
    Route::GET('/update/product/view', [App\Http\Controllers\ProductController::class, 'updateProductView'])->name('update.product.view');
    Route::GET('/update/product/price', [App\Http\Controllers\ProductController::class, 'updateProductPriceView'])->name('update.product.price.view');
    Route::GET('/update/product/price/view', [App\Http\Controllers\ProductController::class, 'updatePrice'])->name('update.product.price');
    Route::PUT('/update/product', [App\Http\Controllers\ProductController::class, 'updateProduct'])->name('update.product');
    Route::GET('/delete/product', [App\Http\Controllers\ProductController::class, 'deleteProduct'])->name('delete.product');
    Route::GET('/stock/transfer/view', [App\Http\Controllers\ProductController::class, 'stockTransferView'])->name('stock.transfer.view');
    Route::POST('/store/stock/transfer', [App\Http\Controllers\ProductController::class, 'storeStockTransfer'])->name('store.stock.transfer');
    Route::GET('/delete/stock/transfer', [App\Http\Controllers\ProductController::class, 'deleteStockTransfer'])->name('delete.stock.transfer');
    Route::GET('/damage/stock/view', [App\Http\Controllers\ProductController::class, 'damageStockView'])->name('damage.stock.view');
    Route::POST('/damage/stock/store', [App\Http\Controllers\ProductController::class, 'storeDamageStock'])->name('store.damage.stock');
    Route::GET('/delete/damage/stock', [App\Http\Controllers\ProductController::class, 'deleteDamageStock'])->name('delete.damage.stock');
    Route::GET('/unit/details', [App\Http\Controllers\ProductController::class, 'unitDetails'])->name('unit.details');
    Route::GET('/get/product', [App\Http\Controllers\ProductController::class, 'getProduct'])->name('get.product');
    Route::GET('/stock/list/view', [App\Http\Controllers\ProductController::class, 'stockListView'])->name('stock.list.view');
    Route::GET('/get/stock/list', [App\Http\Controllers\ProductController::class, 'getStockList'])->name('get.stock.list');
    Route::GET('/price/list/view', [App\Http\Controllers\ProductController::class, 'priceListView'])->name('price.list.view');
    Route::get('/get-location-product', [App\Http\Controllers\ProductController::class, 'searchProduct'])->name('get.location.product');
    Route::GET('/get/product/by/barcode', [App\Http\Controllers\ProductController::class, 'productBarcode'])->name('get.product.by.barcode');
    Route::GET('/get/vehicle/product', [App\Http\Controllers\ProductController::class, 'vehicleProduct'])->name('get.vehicle.product');
    Route::GET('/get/loaded/product', [App\Http\Controllers\ProductController::class, 'loadedProduct'])->name('get.loaded.product');
    Route::GET('/barcode', [App\Http\Controllers\ProductController::class, 'barcodeView'])->name('barcode.view');
    Route::GET('/barcode/generate', [App\Http\Controllers\ProductController::class, 'generateBarcode'])->name('barcode.generate');
    Route::GET('/units-update/{id}', [App\Http\Controllers\ProductController::class, 'unitsUpdates'])->name('units.update');
    Route::GET('/custom/pricelist', [App\Http\Controllers\ProductController::class, 'customPricelist'])->name('custom.pricelist');
    Route::POST('/products/update-barcode', [App\Http\Controllers\ProductController::class, 'updateBarcode'])->name('products.update.barcode');
    Route::get('/category/{id}/products', [ProductController::class, 'getByCategory'])->name('category.products');
    Route::post('/check/batch/status', [App\Http\Controllers\ProductController::class, 'checkBatchStatus'])->name('check.batch.status');

    # Inmage to excel controller
    Route::get('/ocr-upload', [App\Http\Controllers\OcrExcelController::class, 'uploadForm']);
    Route::post('/ocr-export', [App\Http\Controllers\OcrExcelController::class, 'extractAndExport'])->name('ocr.export');

    # Expense category routes.
    Route::GET('/post/expense', [App\Http\Controllers\PostExpenseController::class, 'index'])->name('post.expense.index');
    Route::POST('/post/expense/store', [App\Http\Controllers\PostExpenseController::class, 'store'])->name('post.expense.store');
    Route::GET('/expenses/bulk/delete', [App\Http\Controllers\PostExpenseController::class, 'bulkDelete'])->name('expenses.bulk.delete');
    Route::GET('/change/expenses/date', [App\Http\Controllers\PostExpenseController::class, 'changeDate'])->name('change.expenses.date');
    Route::POST('/upload/expense/excel', [App\Http\Controllers\PostExpenseController::class, 'uploadExpenseExcel'])->name('upload.expense.excel');

    # Report routes
    Route::GET('/customer/debts/report', [App\Http\Controllers\ReportController::class, 'customerDebts'])->name('customer.debts.report');
    Route::GET('/cleared/customer/debts/report', [App\Http\Controllers\ReportController::class, 'clearedCustomerDebts'])->name('cleared.customer.debts.report');
    Route::GET('/customer/statement/{customerId}/{sellingId}', [App\Http\Controllers\ReportController::class, 'customerStatement'])->name('customer.statement');
    Route::GET('/cancel/customer/debt/transaction/{debtId}', [App\Http\Controllers\ReportController::class, 'cancelCustomerDebtTransaction'])->name('cancel.customer.debt.transaction');
    Route::GET('/cancel/supplier/debt/transaction/{debtId}', [App\Http\Controllers\ReportController::class, 'cancelSupplierDebtTransaction'])->name('cancel.supplier.debt.transaction');
    Route::GET('/sold/items/{saleId}', [App\Http\Controllers\ReportController::class, 'soldItems'])->name('sold.items');
    Route::GET('/order/items/{orderId}', [App\Http\Controllers\ReportController::class, 'orderItems'])->name('order.items');
    Route::GET('/supplier/debts/report', [App\Http\Controllers\ReportController::class, 'supplierDebts'])->name('supplier.debts.report');
    Route::GET('/supplier/statement/{supplierId}/{sellingId}', [App\Http\Controllers\ReportController::class, 'supplierStatement'])->name('supplier.statement');
    Route::GET('/purchased/items/{purchaseId}', [App\Http\Controllers\ReportController::class, 'purchasedItems'])->name('purchased.items');
    Route::GET('/sales/report', [App\Http\Controllers\ReportController::class, 'sales'])->name('sales.report');
    Route::get('/generate-pdf/{personId}/{sellingId}/{duration}/{start}/{end}/{flag}/{saleId}/{entityType}', [App\Http\Controllers\ReportController::class, 'generatePdf'])->name('generate.pdf');
    Route::GET('/sales/report/pending/debts/{sellingId}/{duration}/{start}/{end}', [App\Http\Controllers\ReportController::class, 'salesReportPendingDebts'])->name('sales.report.pending.debts');
    Route::GET('/vehicle/report', [App\Http\Controllers\ReportController::class, 'vehicleReport'])->name('vehicles.report');
    Route::GET('/stock/tacking/report', [App\Http\Controllers\ReportController::class, 'stockTacking'])->name('stock.tacking.report');
    Route::GET('/fetch/sales', [App\Http\Controllers\ReportController::class, 'fetchSales'])->name('fetch.sales');
    Route::GET('/purchases/report/view', [App\Http\Controllers\ReportController::class, 'purchasesReportView'])->name('purchases.report.view');
    Route::GET('/get/purchases/report', [App\Http\Controllers\ReportController::class, 'getPurchasesReport'])->name('get.purchases.report');
    Route::GET('/fetch/purchases/{id}', [App\Http\Controllers\ReportController::class, 'fetchPurchases'])->name('fetch.purchases');
    Route::GET('/fetch/customer/debt/{id}', [App\Http\Controllers\ReportController::class, 'fetchCustomerDebt'])->name('fetch.customer.debt');
    Route::GET('/print/sale/invoice/{id}', [App\Http\Controllers\ReportController::class, 'printSaleInvoice'])->name('print.sale.invoice');
    Route::GET('/print/purchase/invoice/{id}', [App\Http\Controllers\ReportController::class, 'printPurchaseInvoice'])->name('print.purchase.invoice');
    Route::GET('/fetch/waiter/debt/{id}', [App\Http\Controllers\ReportController::class, 'fetchWaiterDebt'])->name('fetch.waiter.debt');
    Route::GET('/expense/report/view', [App\Http\Controllers\ReportController::class, 'expenseView'])->name('expense.report.view');
    Route::GET('/expense/report', [App\Http\Controllers\ReportController::class, 'expense'])->name('expense.report');
    Route::GET('/cash/movement/view', [App\Http\Controllers\ReportController::class, 'cashMovementView'])->name('cash.movement.view');
    Route::GET('/cash/movement/report', [App\Http\Controllers\ReportController::class, 'cashMovement'])->name('cash.movement.report');
    Route::GET('/loan/report', [App\Http\Controllers\ReportController::class, 'loanReport'])->name('loan.report.view');
    Route::GET('/loan/type/report', [App\Http\Controllers\ReportController::class, 'loanTypeReport'])->name('loan.type.report');
    Route::GET('/update/issued/loan/{id}', [App\Http\Controllers\ReportController::class, 'updateIssuedLoan'])->name('update.issued.loan');
    Route::GET('/delete/issued/loan/{id}', [App\Http\Controllers\ReportController::class, 'deleteIssuedLoan'])->name('delete.issued.loan');
    Route::GET('/income/report', [App\Http\Controllers\ReportController::class, 'incomeReport'])->name('income.report');
    Route::GET('/get/income/report', [App\Http\Controllers\ReportController::class, 'getIncomeReport'])->name('get.income.report');
    Route::GET('/get/sales/report', [App\Http\Controllers\ReportController::class, 'getSalesReport'])->name('get.sales.report');
    Route::GET('/customers/report', [App\Http\Controllers\ReportController::class, 'customersReport'])->name('customers.report');
    Route::GET('/stock/report', [App\Http\Controllers\ReportController::class, 'stockReport'])->name('stock.report');
    Route::GET('/stock/transfer/report', [App\Http\Controllers\ReportController::class, 'stockTransfer'])->name('stock.transfer.report');
    Route::GET('/damage/stock/report', [App\Http\Controllers\ReportController::class, 'damageStock'])->name('damage.stock.report');
    Route::GET('/fetch/balance/stock/report', [App\Http\Controllers\ReportController::class, 'stockBalance'])->name('fetch.balance.stock.report');
    Route::GET('/stock/movement/report', [App\Http\Controllers\ReportController::class, 'stockMovement'])->name('stock.movement.report');
    Route::GET('/fetch/stock/value/report', [App\Http\Controllers\ReportController::class, 'stockValue'])->name('fetch.stock.value.report');
    Route::GET('/fast/and/slow/moving/items', [App\Http\Controllers\ReportController::class, 'fastSlowProudcts'])->name('fast.and.slow.moving.products');
    Route::GET('/opening/closing/stock', [App\Http\Controllers\ReportController::class, 'openingClosingStock'])->name('opening-closing-stock');
    Route::GET('/balance/sheet', [App\Http\Controllers\ReportController::class, 'accountingOverview'])->name('accounting.overview');
    Route::GET('/settlement/report', [App\Http\Controllers\ReportController::class, 'settlementReport'])->name('settlement.report');

    # Business profile routes.
    Route::get('/business/profile', [App\Http\Controllers\BusinessProfileController::class, 'index'])->name('profile.view');
    Route::post('/edit-business/profile/{id}', [App\Http\Controllers\BusinessProfileController::class, 'updawebte'])->name('update.profile');
    Route::get('/pricing', [App\Http\Controllers\BusinessProfileController::class, 'pricing'])->name('pricing');

    # Subscription routes.
    Route::GET('/subscription', [App\Http\Controllers\SubscriptionController::class, 'index'])->name('subscription.index');
    Route::GET('/renew/subscription', [App\Http\Controllers\SubscriptionController::class, 'store'])->name('renew.subscription');
    Route::GET('/empty/tables', [App\Http\Controllers\SubscriptionController::class, 'emptyTable'])->name('empty.tables');
    Route::GET('/serial/number', [App\Http\Controllers\SubscriptionController::class, 'getSerialNumber'])->name('get.serial.number');

    # Ip routes.
    Route::get('/ip', [App\Http\Controllers\IpController::class, 'index'])->name('ip.view');
    Route::post('/ip-store', [App\Http\Controllers\IpController::class, 'store'])->name('store.ip');
    Route::get('/edit-ip/{id}', [App\Http\Controllers\IpController::class, 'update'])->name('update.ip');
    Route::get('/delete-ip/{id}', [App\Http\Controllers\IpController::class, 'destroy'])->name('delete.ip');

    # Services routes.
    Route::GET('/services', [App\Http\Controllers\ServiceController::class, 'index'])->name('service.index');
    Route::GET('/service/products/view/{id}', [App\Http\Controllers\ServiceController::class, 'serviceProductView'])->name('service.product.view');
    Route::POST('/service/store', [App\Http\Controllers\ServiceController::class, 'store'])->name('service.store');
    Route::POST('/assign/products/{id}', [App\Http\Controllers\ServiceController::class, 'assignProducts'])->name('assign.products');
    Route::GET('/service/delete/{id}', [App\Http\Controllers\ServiceController::class, 'destroy'])->name('service.delete');
    Route::PUT('/service/update/{id}', [App\Http\Controllers\ServiceController::class, 'update'])->name('service.update');
    Route::GET('/service/bulk/delete', [App\Http\Controllers\ServiceController::class, 'serviceBulkDelete'])->name('services.bulk.delete');
    Route::GET('/service/product/bulk/delete', [App\Http\Controllers\ServiceController::class, 'productBulkDelete'])->name('service.product.bulk.delete');
    //Route::post('generate-barcode',[App\Http\Controllers\ProductController::class,'generateBarcode'])->name('generate-barcode');

    # Session controller
    Route::post('/session/add', [App\Http\Controllers\SessionController::class, 'index'])->name('session.add');
    Route::post('/session/remove', [App\Http\Controllers\SessionController::class, 'destroy'])->name('session.remove');

    # Users routes.
    Route::GET('/user', [App\Http\Controllers\UserController::class, 'index'])->name('users.view');
    Route::POST('/user/store', [App\Http\Controllers\UserController::class, 'store'])->name('store.user');
    Route::GET('/user/delete/{id}', [App\Http\Controllers\UserController::class, 'destroy'])->name('delete.user');
    Route::PUT('/user/update/{id}', [App\Http\Controllers\UserController::class, 'update'])->name('update.user');
    Route::GET('/user/role', [App\Http\Controllers\UserController::class, 'roleIndex'])->name('user.role.index');
    Route::GET('edit/role/{id}', [App\Http\Controllers\UserController::class, 'editRoles'])->name('edit.role');
    Route::POST('update/role', [App\Http\Controllers\UserController::class, 'updateRoles'])->name('update.role');
    Route::POST('new/role', [App\Http\Controllers\UserController::class, 'newRole'])->name('new.role');
    Route::GET('delete/role/{id}', [App\Http\Controllers\UserController::class, 'deleteRole'])->name('delete.role');

    # time saving routes
    Route::get('dukamax-sales-upload', [App\Http\Controllers\SaleController::class, 'dukamaxSalesUpload'])->name('dukamax.sales.upload');
    Route::get('dukamax-solditems-upload', [App\Http\Controllers\SaleController::class, 'dukamaxSolditemsUpload'])->name('dukamax.solditems.upload');

    Route::get('/production/order', [App\Http\Controllers\ProductionController::class, 'index'])->name('production.order');
    Route::get('/cancel/production/order', [App\Http\Controllers\ProductionController::class, 'cancelProductionOrder'])->name('cancel.production.order');
    Route::post('/store/production/order', [App\Http\Controllers\ProductionController::class, 'store'])->name('store.production.order');
    Route::get('/production/order/progress/{flag}', [App\Http\Controllers\ProductionController::class, 'progress'])->name('production.order.progress');
    Route::get('/process/order/{order_id}/{stage}', [App\Http\Controllers\ProductionController::class, 'processOrder'])->name('process.order');
    Route::get('/postpond/order/{order_id}/', [App\Http\Controllers\ProductionController::class, 'postpondOrder'])->name('postpond.order');
    Route::get('/dispatch', [App\Http\Controllers\ProductionController::class, 'dispatchView'])->name('dispatch');
    Route::post('/process/dispatch/{order_id}', [App\Http\Controllers\ProductionController::class, 'processDispatch'])->name('process.dispatch');
    Route::get('/production/order/payment/{order_id}', [App\Http\Controllers\ProductionController::class, 'orderPayment'])->name('production.order.payment');
    Route::get('/process/stock/order/{orderId}', [App\Http\Controllers\ProductionController::class, 'processStockOrder'])->name('process.stock.order');
    Route::get('/cancel/production/order/{order_id}', [App\Http\Controllers\ProductionController::class, 'destroy'])->name('cancel.production.order');
    Route::get('/production/report', [App\Http\Controllers\ProductionController::class, 'report'])->name('production.report');


    # Asset routes
    Route::get('/asset/index', [App\Http\Controllers\AssetController::class, 'index'])->name('asset.index');
    Route::post('/asset/store', [App\Http\Controllers\AssetController::class, 'store'])->name('asset.store');
    Route::get('/asset/update/{id}', [App\Http\Controllers\AssetController::class, 'update'])->name('asset.update');
    Route::get('/asset/destroy/{id}', [App\Http\Controllers\AssetController::class, 'destroy'])->name('asset.destroy');

    # Loan routes
    Route::get('/creditor/index', [App\Http\Controllers\CreditorController::class, 'index'])->name('creditor.index');
    Route::post('/creditor/store', [App\Http\Controllers\CreditorController::class, 'store'])->name('creditor.store');
    Route::get('/creditor/update/{id}', [App\Http\Controllers\CreditorController::class, 'update'])->name('creditor.update');
    Route::get('/creditor/destroy/{id}', [App\Http\Controllers\CreditorController::class, 'destroy'])->name('creditor.destroy');
    Route::get('recieved/loan/index', [App\Http\Controllers\CreditorController::class, 'recievedLoanIndex'])->name('recieved.loan.index');
    Route::post('recieved/loan/store', [App\Http\Controllers\CreditorController::class, 'recievedLoanStore'])->name('recieved.loan.store');
    Route::get('/loan/payment', [App\Http\Controllers\CreditorController::class, 'loanPayment'])->name('loan.payment');
    Route::get('/update/loan/{id}', [App\Http\Controllers\CreditorController::class, 'updateLoan'])->name('update.loan');
    Route::post('/delete/loan/{id}', [App\Http\Controllers\CreditorController::class, 'destroyLoan'])->name('delete.loan');
    Route::post('/loan-payment/{id}', [App\Http\Controllers\CreditorController::class, 'loanPayment'])->name('loan.payment');

    # Debtors routes
    Route::get('/debtor/index', [App\Http\Controllers\DebtorController::class, 'index'])->name('debtor.index');
    Route::post('/debtor/store', [App\Http\Controllers\DebtorController::class, 'store'])->name('debtor.store');
    Route::get('/debtor/update/{id}', [App\Http\Controllers\DebtorController::class, 'update'])->name('debtor.update');
    Route::get('/debtor/destroy/{id}', [App\Http\Controllers\DebtorController::class, 'destroy'])->name('debtor.destroy');

    # Debtors routes
    Route::get('/games/index', [App\Http\Controllers\GamesController::class, 'index'])->name('game.index');
    Route::post('/games/store', [App\Http\Controllers\GamesController::class, 'store'])->name('game.store');
    Route::get('/games/update/{id}', [App\Http\Controllers\GamesController::class, 'update'])->name('game.update');
    Route::get('/games/destroy/{id}', [App\Http\Controllers\GamesController::class, 'destroy'])->name('game.destroy');
    Route::get('/games/bulk-delete', [App\Http\Controllers\CustomerController::class, 'bulkDelete'])->name('game.bulk.delete');
});

# Artisan commands route.
Route::get('/seed/confirmation', [App\Http\Controllers\SubscriptionController::class, 'seedConfirmation'])->name('seed.confirmation');
Route::get('/seed', [App\Http\Controllers\SubscriptionController::class, 'seed'])->name('seed');
Route::get('/migrate', [App\Http\Controllers\SubscriptionController::class, 'migrate'])->name('migrate');
Route::get('/optimize', [App\Http\Controllers\SubscriptionController::class, 'optimizeClear'])->name('optimize.clear');
Route::get('/merge', [App\Http\Controllers\SubscriptionController::class, 'merge'])->name('merge');
Route::get('/start-websockets', [App\Http\Controllers\SubscriptionController::class, 'startWebSocketServer']);
Route::get('/storage-link', [\App\Http\Controllers\SubscriptionController::class, 'createStorageLink'])->name('storage.link');
Route::get('/clean-expiry-not', [\App\Http\Controllers\SubscriptionController::class, 'cleanExpiryNot'])->name('clean.expiry.not');
Route::get('/default-batchno', [\App\Http\Controllers\SubscriptionController::class, 'assignDefaultBatchNumber'])->name('default.batchno ');
Route::get('/sync-sales-selling', [\App\Http\Controllers\SubscriptionController::class, 'syncSalesSellingId'])->name('sales.sync');
Route::get('/stocks/reset-negative', [\App\Http\Controllers\SubscriptionController::class, 'resetNegativeStocks'])->name('stocks.reset-negative');
Route::get('/get/sold/items/with/missing/sales', [\App\Http\Controllers\SubscriptionController::class, 'getSoldItemsWithMissingSales'])->name('get.sold.items.with.missing.sales');
Route::get('/cleaner', [\App\Http\Controllers\SubscriptionController::class, 'cleaner'])->name('cleaner');

# Payment route
Route::get('/payment', [App\Http\Controllers\SubscriptionController::class, 'payment'])->name('payment');

# HMS routes.
Route::get('/get-location-product', [App\Http\Controllers\ProductController::class, 'searchProduct'])->name('get.location.product');

// DPO Payment Gateway Routes
Route::post('/pay/dpo', [App\Http\Controllers\DpoController::class, 'initiatePayment'])->name('dpo.pay');
Route::get('/pay/dpo/callback', [App\Http\Controllers\DpoController::class, 'paymentCallback'])->name('dpo.callback');

require __DIR__ . '/auth.php';
