<?php $__env->startSection('content'); ?>

    
    <div class="content">
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0">📦 Products Missing Prices</h4>
            </div>

            <div class="card-body">
                <h5 class="mb-3 text-secondary">🛒 Products Missing Buying Prices</h5>

                <?php if($missingBuyingPrices->isEmpty()): ?>
                    <p class="text-success">✅ All products have buying prices.</p>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover table-bordered">
                            <thead class="bg-dark text-white">
                                <tr>
                                    <th>#</th>
                                    <th>Product</th>
                                    <th>Buying</th>
                                    <th>Location</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $missingBuyingPrices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td><?php echo e($product->product ?? 'N/A'); ?></td>
                                        <td class="text-danger font-weight-bold"><?php echo e($product->buying ?? 'N/A'); ?></td>
                                        <td><?php echo e($product->location->name ?? 'N/A'); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>

                <hr class="my-4">

                <h5 class="mb-3 text-secondary">💰 Products Missing Selling Prices</h5>

                <?php if($missingSellingPrices->isEmpty()): ?>
                    <p class="text-success">✅ All products have selling prices.</p>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover table-bordered">
                            <thead class="bg-dark text-white">
                                <tr>
                                    <th>#</th>
                                    <th>Product</th>
                                    <th>Unit</th>
                                    <th>Unit Content</th>
                                    <th>Selling</th>
                                    <th>Location</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $missingSellingPrices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($product->unit->isEmpty()): ?>
                                        <tr class="table-warning text-center">
                                            <td><?php echo e($index + 1); ?></td>
                                            <td><?php echo e($product->product ?? 'N/A'); ?></td>
                                            <td colspan="4" class="text-danger font-italic">No unit assigned</td>
                                        </tr>
                                    <?php else: ?>
                                        <?php $__currentLoopData = $product->unit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($index + 1); ?></td>
                                                <td><?php echo e($product->product ?? 'N/A'); ?></td>
                                                <td><?php echo e($unit->unit->name ?? 'N/A'); ?></td>
                                                <td><?php echo e($unit->unit_cont ?? 'N/A'); ?></td>
                                                <td class="text-danger font-weight-bold">Missing</td>
                                                <td><?php echo e($product->location->name ?? 'N/A'); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>

    </div>
    

<?php $__env->startSection('scripts'); ?>
    <script>
        $("#data-table").DataTable({
            "pageLength": 100,
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laraval\dukamax\resources\views/missing-prices.blade.php ENDPATH**/ ?>