<?php $__env->startSection('content'); ?>
    <input type="hidden" value="<?php echo e(Auth::user()->role); ?>" id="user">
    <div class="card">
        <div class="card-header">
            <p>Cash & Credit purchase</p>
        </div>

        <div class="card-body">
            <div class="mb-4">
                <div class="row align-items-center">
                    <div class="col-md-7 mb-2 mb-md-0">
                        <div class="input-group">
                            <span class="input-group-text bg-primary text-white">
                                <i class="fas fa-barcode"></i>
                            </span>
                            <input type="search" id="search" class="form-control search"
                                placeholder="Enter product name or barcode...">
                        </div>
                        <div id="list"
                            style="display:none; position: absolute; z-index: 10; width: 98%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);"
                            class="bg-white border border-primary">
                            <ol id="results" class="list-group list-group-flush"></ol>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <?php if($sellingCount > 1): ?>
                            <div class="input-group shadow-sm">
                                <span class="input-group-text bg-info text-white">
                                    <i class="fas fa-store"></i>
                                </span>
                                <select name="location" id="location" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected>-- Choose Location --</option>
                                    <?php $__currentLoopData = $sellings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($selling->location_id); ?>">-- <?php echo e($selling->location->name); ?> --
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        <?php else: ?>
                            <input type="hidden" name="location" id="location" class="form-control"
                                value="<?php echo e($sellings[0]->location_id); ?>">
                            <div class="input-group shadow-sm">
                                <span class="input-group-text bg-info text-white">
                                    <i class="fas fa-store"></i>
                                </span>
                                <input type="text" name="area-copy" id="area-copy" class="form-control"
                                    value="<?php echo e($sellings[0]->location->name); ?>" style="text-align: center" readonly>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <br>

            <form action="<?php echo e(route('store.purchase')); ?>" onsubmit="showSpinner()" method="post">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-10">
                        <table class="table table-bordered table-hover table-striped align-middle shadow-sm"
                            style="text-align: center; background-color: #fff;">
                            <thead class="thead-light">
                                <tr>
                                    <th style="width: 12%">Product</th>
                                    <th style="width: 8%">Unit</th>
                                    <th style="width:10%">B.Price</th>
                                    <th style="width:10%">Qty</th>
                                    <th style="width:10%">Amount</th>
                                    <th style="width:12%">Sell 1</th>
                                    <th style="width:10%">Sell 2</th>
                                    <th style="width:10%">Sell 3</th>
                                    <th style="width:10%">Sell 4</th>
                                    <th style="width:10%">Batch.No</th>
                                    <th style="width:2%">Exp</th>
                                    <th style="width:1%">Del</th>
                                </tr>
                            </thead>

                            <?php
                                $iteration = 200;
                            ?>

                            <tbody id="tbody">

                            </tbody>

                            <?php if(session('purchaseOrderItems')): ?>
                                <tbody id="tbody1">
                                    <?php $__currentLoopData = session('purchaseOrderItems'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $iteration++;
                                            // Pull product units (with selling prices)
                                            $units = $item->product->unit;
                                            $buying = number_format($item->price, 0);
                                            $amount = number_format($item->amount, 0);
                                        ?>

                                        <tr id="tr<?php echo e($iteration); ?>">
                                            
                                            <td>
                                                <input type="hidden" name="id[]" value="<?php echo e($item->product_id); ?>"
                                                    class="id">
                                                <input type="hidden" name="product[]" value="<?php echo e($item->product->product); ?>"
                                                    class="product">
                                                <?php echo e($item->product->product); ?>

                                            </td>

                                            
                                            <td>
                                                <select class="form-control unit" name="unit[]">
                                                    <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $uom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($uom->id); ?>"
                                                            <?php echo e($uom->id == $item->unit_id ? 'selected' : ''); ?>>
                                                            <?php echo e($uom->unit->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <input type="hidden" value="1" name="cont[]" class="cont">
                                            </td>

                                            
                                            <td>
                                                <input type="text" name="buying[]" value="<?php echo e($buying); ?>"
                                                    class="form-control buying text-center">
                                            </td>

                                            
                                            <td>
                                                <input type="text" value="<?php echo e($item->qty); ?>" name="qty[]"
                                                    class="form-control qty text-center" required>
                                            </td>

                                            
                                            <td>
                                                <input type="text" name="amount[]" value="<?php echo e($amount); ?>"
                                                    class="form-control amount text-center" readonly>
                                            </td>

                                            
                                            <?php for($i = 0; $i < 4; $i++): ?>
                                                <?php
                                                    $selling = isset($units[$i])
                                                        ? number_format($units[$i]->selling, 0)
                                                        : 0;
                                                ?>
                                                <td>
                                                    <input type="text" name="sell<?php echo e($item->id); ?>[]"
                                                        value="<?php echo e($selling); ?>"
                                                        class="form-control form-control-sm text-center sell<?php echo e($i + 1); ?>"
                                                        <?php echo e($selling == 0 ? 'readonly' : ''); ?>>
                                                </td>
                                            <?php endfor; ?>

                                            
                                            <td>
                                                <input type="text" name="batch[]" value="<?php echo e($item->batch ?? ''); ?>"
                                                    class="form-control batch text-center"
                                                    <?php echo e(empty($item->batch) ? 'readonly' : 'required'); ?>>
                                            </td>

                                            
                                            <td>
                                                <input type="date" name="exp[]" value="<?php echo e($item->exp ?? ''); ?>"
                                                    class="form-control exp text-center">
                                            </td>

                                            
                                            <td>
                                                <button type="button" class="btn btn-outline-danger removeRow">
                                                    <i class="fas fa-trash-alt"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            <?php endif; ?>
                        </table>
                    </div>

                    <div class="col was-validated">
                        <input type="date" name="date" id="date" value="<?php echo e(date('Y-m-d')); ?>"
                            class="form-control" style="text-align: center">

                        <input type="text" name="total" id="total" class="form-control"
                            style="text-align: center" placeholder="Total" readonly
                            value="<?php echo e(session('purchaseOrderData') ? session('purchaseOrderData')['total'] : ''); ?>">

                        <select name="type" id="type" required class="form-control" style="text-align: center">
                            <option disabled selected value="">-- Choose Type --
                            <option value="cash">-- Cash --</option>
                            <option value="credit">-- Credit --</option>
                            </option>
                        </select>

                        <input type="text" name="net" id="net" class="form-control"
                            style="text-align: center" placeholder="Net" readonly
                            value="<?php echo e(session('purchaseOrderData') ? session('purchaseOrderData')['total'] : ''); ?>">

                        <input type="text" name="paid" id="paid" class="form-control"
                            style="text-align: center" placeholder="Paid" required>

                        <input type="text" name="due" id="due" class="form-control"
                            style="text-align: center" placeholder="Due balance" readonly>

                        <select name="account" id="account" class="form-control" style="text-align: center"
                            required></select>

                        

                        <div id="suppliers-wrapper">
                            <input type="text" id="supplier" name="supplier" class="form-control supplier"
                                placeholder="Enter Supplier Name..." style="text-align: center" required>
                            <div id="supplier-list" style="display:none">
                                <ol id="suppliers"></ol> <!-- Keep this as 'suppliers' -->
                            </div>

                            <input type="text" id="phone" name="phone" class="form-control phone"
                                placeholder="Enter Supplier Contacts" style="text-align: center" required>

                            <input type="text" id="address" name="address" class="form-control phone"
                                placeholder="Enter Supplier Address" style="text-align: center" required>
                        </div>

                        <input type="number" name="invoice" id="invoice" class="form-control"
                            style="text-align: center" placeholder="Invoice #" readonly required>

                        <?php if($sellingCount > 1): ?>
                            <select name="storage" id="storage" class="form-control" style="text-align: center"
                                required>
                                <option disabled selected value="">-- Store Location --</option>
                                <?php $__currentLoopData = $sellings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($selling->location_id); ?>">-- <?php echo e($selling->location->name); ?> --
                                    </option>
                                    <?php $__currentLoopData = $selling->storage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $storage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($storage->location_id); ?>">
                                            -- <?php echo e($storage->location->name); ?> --</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        <?php else: ?>
                            <select name="storage" id="storage" class="form-control" style="text-align: center"
                                required>
                                <option disabled selected value="">-- Store Location --</option>
                                <option value="<?php echo e($sellings[0]->location_id); ?>">
                                    -- <?php echo e($sellings[0]->location->name); ?> --
                                </option>
                                <?php $__currentLoopData = $sellings[0]->storage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $storage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($storage->location_id); ?>">
                                        -- <?php echo e($storage->location->name); ?> ---</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        <?php endif; ?>

                        <input type="hidden" name="sehemu" id="location1" class="form-control"
                            style="text-align: center">

                        <br>
                        <button class="btn btn-info btn-block" id="confirm"><i class="fas fa-paper-plane fa-lg"></i>
                            Confirm</button>
                        <a href="<?php echo e(route('cancel.purchase')); ?>" class="btn btn-danger btn-block"><i
                                class="fas fa-times fa-lg"></i> Cancel</a>
                    </div>
                </div>
            </form>
        </div>
    </div>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            // Utility function for number formatting
            function formatNumber(number) {
                return new Intl.NumberFormat('en-US').format(number);
            }

            // Utility function to get raw value from a formatted input
            function getRawValue(selector) {
                const value = $(selector).val().replace(/,/g, '');
                return parseFloat(value) || 0;
            }

            // Utility function to set formatted value for display
            function setFormattedValue(selector, value) {
                $(selector).val(formatNumber(value));
            }

            // Initialize global variables
            let index = 0;
            let location;
            let response = []; // Initialize as an empty array
            let paid = 0;
            let batchStatus = 0;

            const sellingCount = <?php echo e($sellingCount); ?>; // Access the PHP variable in JavaScript

            function getRandomInt(min, max) {
                return Math.floor(Math.random() * (max - min + 1)) + min;
            }

            let invoiceNumber = getRandomInt(1000, 9999);
            let formattedInvoice = "00" + invoiceNumber;

            $('#invoice').val(formattedInvoice);

            function checkBatchStatus(location) {
                if (!location) return; // skip if no location selected

                $.ajax({
                    url: "<?php echo e(route('check.batch.status')); ?>", // ✅ route name
                    type: "POST",
                    data: {
                        _token: $('meta[name="csrf-token"]').attr("content"),
                        location_id: location
                    },
                    success: function(response) {
                        batchStatus = response.batch_no;
                    },
                    error: function(xhr) {
                        console.error("Error:", xhr.responseText);
                    }
                });
            }

            if (sellingCount > 1) {
                $("#location").focus().on("change", function() {
                    location = $(this).val();
                    locationAccounts(location);
                    checkBatchStatus(location);
                });
            } else {
                location = $("#location").val();
                locationAccounts(location);
                checkBatchStatus(location);
                $("#search").focus();
            }

            function locationAccounts(location) {
                $("#location1").val(location);
                $.ajax({
                    url: "<?php echo e(route('get.location.accounts')); ?>",
                    method: "GET",
                    data: {
                        'locationId': location
                    },
                    success: function(response) {
                        const selectElement = $('#account');
                        selectElement.empty().append(
                            '<option disabled selected value="">-- Account --</option>'
                        );
                        response.forEach(item => {
                            selectElement.append(
                                `<option value="${item.id}">-- ${item.type} - ${item.name} --</option>`
                            );
                        });
                    }
                });
            }

            function addProductRow(data, units, unitbuying, sell1, sell2, sell3, sell4, unit1, unit2, unit3,
                unit4, batchStatus) {
                console.log(batchStatus);

                let tr = `
                                <tr id="tr${index}">
                                    <td>
                                        <input type="hidden" name="id[]"  id="id${index}" value="${data.id}" class="id">
                                        <input type="hidden" name="product[]" value="${data.product}" class="product">
                                        ${data.product}
                                    </td>
                                    <td>
                                        <select id="unit${index}" class="form-control unit" name="unit[]">${units}</select>
                                        <input type="hidden" value="1" name="cont[]" id="cont${index}" class="cont">
                                    </td>
                                    <td><input type="text" name="buying[]"  id="buying${index}"  value="${formatNumber(unitbuying)}" class="form-control buying text-center"></td>
                                    <td><input type="text" name="qty[]"  id="qty${index}"  value="1" class="form-control qty text-center" required></td>
                                    <td><input type="text" name="amount[]"  id="amount${index}"  value="${formatNumber(unitbuying)}" class="form-control amount text-center" readonly></td>
                                    <td><input type="text" name="sell${data.id}[]" value="${formatNumber(sell1)}" class="form-control form-control-sm text-center sell1" ${sell1==0?'readonly':''}></td>
                                    <td><input type="text" name="sell${data.id}[]" value="${formatNumber(sell2)}" class="form-control form-control-sm text-center sell2" ${sell2==0?'readonly':''}></td>
                                    <td><input type="text" name="sell${data.id}[]" value="${formatNumber(sell3)}" class="form-control form-control-sm text-center sell3" ${sell3==0?'readonly':''}></td>
                                    <td><input type="text" name="sell${data.id}[]" value="${formatNumber(sell4)}" class="form-control form-control-sm text-center sell4" ${sell4==0?'readonly':''}></td>
                                    <td><input type="text" name="batch[]" class="form-control batch text-center"  ${batchStatus==0?'readonly':''} ${batchStatus==0?'':'required'}></td>
                                    <td><input type="date" name="exp[]" class="form-control exp text-center"></td>
                                    <td>
                                        <button type="button" class="btn btn-outline-danger removeRow"><i class="fas fa-trash-alt"></i></button>
                                    </td>
                                </tr>
                            `;

                $("#tbody").append(tr);
                index++;
                updateTotals(); // Keep your total calculation logic
                $("#search").val('').focus();
            }

            let lastKeyTime = 0;
            let barcodeBuffer = "";

            // =========================
            // Fetch products (manual or barcode)
            // =========================
            function fetchProducts(query, isBarcode = false) {
                const locationId = $("#location").val();
                if (!query || !locationId) {
                    $("#list").empty().hide();
                    return;
                }

                $.ajax({
                    url: "<?php echo e(route('get.location.product')); ?>",
                    method: "GET",
                    data: {
                        query: isBarcode ? null : query,
                        barcode: isBarcode ? query : null,
                        locationId
                    },
                    success: function(data) {
                        response = data;
                        $("#list").empty();

                        // Barcode scan (expect 1 product)
                        if (isBarcode && data.length === 1) {
                            const product = data[0];
                            const units = product.unit.map(u =>
                                `<option value="${u.id}">${u.name}</option>`).join('');
                            const sell1 = product.unit[0]?.selling ?? 0;
                            const sell2 = product.unit[1]?.selling ?? 0;
                            const sell3 = product.unit[2]?.selling ?? 0;
                            const sell4 = product.unit[3]?.selling ?? 0;
                            const unit1 = product.unit[0]?.name ?? '';
                            const unit2 = product.unit[1]?.name ?? '';
                            const unit3 = product.unit[2]?.name ?? '';
                            const unit4 = product.unit[3]?.name ?? '';
                            addProductRow(product, units, product.buying, sell1, sell2, sell3, sell4,
                                unit1, unit2, unit3, unit4, batchStatus);
                            $("#search").val('').focus();
                            return;
                        }

                        // Manual typing: show suggestions
                        if (!isBarcode) {
                            if (data.length === 0) {
                                $("#list").fadeIn("slow").append(
                                    '<button type="button" class="btn btn-outline-secondary form-control items">No suggestions..</button>'
                                );
                                setTimeout(() => $("#list").fadeOut("slow"), 2000);
                                return;
                            }

                            data.forEach((item, i) => {
                                $("#list").fadeIn("slow").append(
                                    `<button type="button" class="form-control items btn btn-outline-secondary" data-index="${i}">
                            ${item.product} | Stock: ${item.totalQty} ${item.unit[0]?.name ?? ''}
                        </button>`
                                );
                            });
                        }
                    }
                });
            }

            // =========================
            // Manual typing (keyup)
            // =========================
            $("#search").on("keyup", function(e) {
                const query = $(this).val();

                // Skip if Enter pressed (barcode handled separately)
                if (e.which === 13) return;

                // Ignore very fast typing (likely barcode)
                const currentTime = new Date().getTime();
                if (currentTime - lastKeyTime < 30) return;
                lastKeyTime = currentTime;

                if (query.length > 0) {
                    fetchProducts(query, false); // manual search
                }
            });

            // =========================
            // Barcode scan detection (Enter key)
            // =========================
            $("#search").on("keydown", function(e) {
                const currentTime = new Date().getTime();
                const char = e.key;

                // Build barcode buffer if keys are fast
                if (currentTime - lastKeyTime < 30) {
                    barcodeBuffer += char;
                } else {
                    barcodeBuffer = char;
                }
                lastKeyTime = currentTime;

                if (e.key === "Enter") {
                    e.preventDefault();
                    const barcode = $(this).val().trim();
                    if (barcode !== "") {
                        fetchProducts(barcode, true); // barcode search
                    }
                    barcodeBuffer = "";
                }
            });

            // =========================
            // Product click for manual selection
            // =========================
            $(document).on("click", ".items", function() {
                $("#list").fadeOut("slow");
                const indexSelected = $(this).data("index");
                const product = response[indexSelected];

                const units = product.unit.map(u => `<option value="${u.id}">${u.name}</option>`).join('');
                const sell1 = product.unit[0]?.selling ?? 0;
                const sell2 = product.unit[1]?.selling ?? 0;
                const sell3 = product.unit[2]?.selling ?? 0;
                const sell4 = product.unit[3]?.selling ?? 0;
                const unit1 = product.unit[0]?.name ?? '';
                const unit2 = product.unit[1]?.name ?? '';
                const unit3 = product.unit[2]?.name ?? '';
                const unit4 = product.unit[3]?.name ?? '';

                addProductRow(product, units, product.buying, sell1, sell2, sell3, sell4, unit1, unit2,
                    unit3, unit4, batchStatus);
            });

            $(document).on("click", ".removeRow", function() {
                $(this).closest("tr").remove(); // safer than using IDs
                updateTotals();
            });

            $(document).on("click", ".increment, .decrement", function() {
                const id = $(this).attr("id").replace(/(increment|decrement)/, "");
                const qtyInput = $(`#qty${id}`);
                let qty = parseInt(qtyInput.val().replace(/,/g, ''), 10);

                if ($(this).hasClass("increment")) {
                    qty += 1;
                } else if ($(this).hasClass("decrement") && qty > 1) {
                    qty -= 1;
                }

                qtyInput.val(formatNumber(qty));
                updateAmount(id);
            });

            function updateAmount(id) {
                const $row = $(`#tr${id}`);
                const qty = parseInt($row.find(".qty").val().replace(/,/g, ''), 10);
                const price = parseFloat($row.find(".buying").val().replace(/,/g, ''));

                if (isNaN(qty) || isNaN(price)) {
                    console.error(`Invalid values for qty or price: qty=${qty}, price=${price}`);
                    return;
                }

                const amount = qty * price;
                setFormattedValue($row.find(".amount"), amount);
                updateTotals();
            }

            $(document).on("change", ".unit", function() {
                const unitId = $(this).val();
                const id = $(this).attr("id").replace("unit", "");
                const productId = $(`#id${id}`).val();
                const qty = getRawValue(`#qty${id}`);
                const locationId = $("#location1").val();

                console.log(id, unitId, productId, qty, locationId);

                $.ajax({
                    url: "<?php echo e(route('unit.details')); ?>",
                    method: "GET",
                    data: {
                        unitId,
                        productId,
                        locationId
                    },
                    success: function(data) {
                        const productBuying = data.product.buying * data.unit_cont;
                        $(`#cont${id}`).val(data.unit_cont);
                        setFormattedValue(`#buying${id}`, productBuying);
                        setFormattedValue(`#amount${id}`, productBuying * qty);
                        updateTotals();
                    }
                });
            });

            $(document).on("keyup", ".qty, .buying, .sell1, .sell2, .sell3, .sell4", function() {
                const $row = $(this).closest("tr");
                const qty = getRawValue($row.find(".qty"));
                const price = getRawValue($row.find(".buying"));

                const sell1 = getRawValue($row.find(".sell1"));
                const sell2 = getRawValue($row.find(".sell2"));
                const sell3 = getRawValue($row.find(".sell3"));
                const sell4 = getRawValue($row.find(".sell4"));

                setFormattedValue($row.find(".buying"), price);
                setFormattedValue($row.find(".sell1"), sell1);
                setFormattedValue($row.find(".sell2"), sell2);
                setFormattedValue($row.find(".sell3"), sell3);
                setFormattedValue($row.find(".sell4"), sell4);
                setFormattedValue($row.find(".amount"), qty * price);

                updateTotals();
            });

            function updateTotals() {
                let amount = 0;
                $(".amount").each(function() {
                    amount += getRawValue(this);
                });
                setFormattedValue("#total", amount);
                setFormattedValue("#net", amount);


                savePurchaseState();
            }

            $("#paid").on("keyup", function() {
                paid = getRawValue(this);
                const net = getRawValue("#net");
                const balance = net - paid;
                setFormattedValue("#due", balance);
                setFormattedValue("#paid", paid);
            });

            $("#account").on("change", function() {
                $("#pay").prop("disabled", false);
                $("#paid").focus();
            });

            $("#type").on("change", function() {
                if ($(this).val() == 2) {
                    $("#paid").val(0).prop("readonly", true);
                    $("#pay").prop("disabled", false);
                } else {
                    $("#paid").val("").prop("readonly", false).focus();
                    $("#pay").prop("disabled", true);
                }
            });

            $("#supplier").on("keyup", function() {
                let query = $(this).val();
                let $supplierList = $("#supplier-list");
                let $suppliers = $("#suppliers");
                $suppliers.empty();

                if (!query) {
                    $("#phone, #address").val('');
                    $supplierList.fadeOut();
                    return;
                }

                $.ajax({
                    url: "<?php echo e(route('get.supplier')); ?>",
                    method: "GET",
                    data: {
                        query: query
                    },
                    success: function(response) {
                        if (response.length === 0) {
                            $supplierList.fadeIn("slow");
                            $suppliers.append(
                                '<li><button type="button" class="btn btn-outline-secondary items w-100">No suggestions...</button></li>'
                            );
                            setTimeout(() => {
                                $supplierList.fadeOut("slow", () => $suppliers.empty());
                            }, 2000);
                        } else {
                            response.forEach(supplier => {
                                $supplierList.fadeIn("slow");
                                $suppliers.append(
                                    `<li>
                            <button type="button" class="suppliernames btn btn-outline-secondary w-100" 
                                id="${supplier.id}" phone="${supplier.phone}" address="${supplier.address}">
                                ${supplier.name}
                            </button>
                        </li>`
                                );
                            });
                        }
                    }
                });
            });

            $(document).on("click", ".suppliernames", function() {
                let supplierId = $(this).attr('id');
                let supplierPhone = $(this).attr('phone');
                let supplierAddress = $(this).attr('address');
                let supplierName = $(this).text();
                let amount = parseFloat($("#net").val().replace(/,/g, '')) || 0;

                $("#supplier-list").fadeOut("slow");

                if (typeof account !== "undefined" && account == 0) {
                    checkCustomerAdvance(supplierId, amount).then(proceed => {
                        if (proceed) {
                            $("#supplier").val(supplierName);
                            $("#phone").val(supplierPhone);
                            $("#address").val(supplierAddress);
                        }
                    });
                } else {
                    $("#supplier").val(supplierName);
                    $("#phone").val(supplierPhone);
                    $("#address").val(supplierAddress);
                }
            });

            // Utility to safely parse numbers from formatted strings
            function parseNumber(value) {
                if (!value) return 0;
                return parseFloat(value.toString().replace(/,/g, '')) || 0;
            }

            // Save the current purchase state to localStorage
            function savePurchaseState() {
                let rows = [];
                $("#tbody tr").each(function() {
                    const $unit = $(this).find(".unit");
                    rows.push({
                        product_id: $(this).find(".id").val(),
                        product: $(this).find(".product").val(),
                        unit_id: $unit.val(), // selected unit
                        units: $unit.find("option").map(function() { // all units
                            return {
                                id: $(this).val(),
                                name: $(this).text()
                            };
                        }).get(),
                        buying: $(this).find(".buying").val(),
                        qty: $(this).find(".qty").val(),
                        amount: $(this).find(".amount").val(),
                        sell1: $(this).find(".sell1").val(),
                        sell2: $(this).find(".sell2").val(),
                        sell3: $(this).find(".sell3").val(),
                        sell4: $(this).find(".sell4").val(),
                        batch: $(this).find(".batch").val(),
                        exp: $(this).find(".exp").val()
                    });
                });

                const mainData = {
                    total: $("#total").val(),
                    net: $("#net").val(),
                    paid: $("#paid").val(),
                    due: $("#due").val(),
                    supplier: $("#supplier").val(),
                    phone: $("#phone").val(),
                    address: $("#address").val(),
                    location: $("#location").val(),
                    storage: $("#storage").val(),
                    type: $("#type").val(),
                    date: $("#date").val(),
                    account: $("#account").val()
                };

                localStorage.setItem('purchaseRows', JSON.stringify(rows));
                localStorage.setItem('purchaseMain', JSON.stringify(mainData));
            }

            // Load the purchase state from localStorage
            function loadPurchaseState() {
                const rows = JSON.parse(localStorage.getItem('purchaseRows') || '[]');
                const mainData = JSON.parse(localStorage.getItem('purchaseMain') || '{}');

                rows.forEach(item => {
                    const unitsOptions = item.units.map(u =>
                        `<option value="${u.id}" ${u.id == item.unit_id ? 'selected' : ''}>${u.name}</option>`
                    ).join('');

                    addProductRow({
                            id: item.product_id,
                            product: item.product,
                            buying: parseNumber(item.buying),
                            unit: item.units
                        },
                        unitsOptions,
                        parseNumber(item.buying),
                        parseNumber(item.sell1),
                        parseNumber(item.sell2),
                        parseNumber(item.sell3),
                        parseNumber(item.sell4),
                        "", "", "", "", // unit names placeholders
                        item.batch ? 1 : 0
                    );

                    // Restore remaining values
                    const $lastRow = $("#tbody tr").last();
                    $lastRow.find(".qty").val(item.qty);
                    $lastRow.find(".amount").val(item.amount);
                    $lastRow.find(".sell1").val(item.sell1);
                    $lastRow.find(".sell2").val(item.sell2);
                    $lastRow.find(".sell3").val(item.sell3);
                    $lastRow.find(".sell4").val(item.sell4);
                    $lastRow.find(".batch").val(item.batch);
                    $lastRow.find(".exp").val(item.exp);
                });

                // Restore main form inputs
                for (const key in mainData) {
                    if ($("#" + key).length) {
                        $("#" + key).val(mainData[key]);
                    }
                }

                updateTotals();
            }

            // Load state on page load
            loadPurchaseState();

            // Save state whenever any input/select changes
            // $(document).on("input change", "input, select", function() {
            //     savePurchaseState();
            // });

            // Clear saved state on form submit
            $("form").on("submit", function() {
                localStorage.removeItem('purchaseRows');
                localStorage.removeItem('purchaseMain');
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laraval\dukamax\resources\views/purchases.blade.php ENDPATH**/ ?>