<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="card-header">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-6">
                        <table>
                            <thead>
                                <tr>
                                    <th>
                                        <select name="duration" id="duration" class="form-control" style="text-align: center"
                                            required>
                                            <option disabled selected value="">-- Choose Duration --</option>
                                            <option value="today">-- Today --</option>
                                            <option value="set date">-- Set Date --</option>
                                            <option value="set duration">-- Set Duration --</option>
                                        </select>
                                    </th>
                                    <th>
                                        <input type="date" name="start" id="start" class="form-control"
                                            style="text-align: center; display:none" required>
                                    </th>
                                    <th>
                                        <input type="date" name="end" id="end" class="form-control"
                                            style="text-align: center; display:none" required>
                                    </th>
                                    <th>
                                        <button type="button" class="btn btn-success" id="search">
                                            <i class="fa-solid fa-search"></i> Search
                                        </button>
                                    </th>
                                </tr>
                            </thead>
                        </table>
                    </div>

                    <div class="col">
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                data-target="#accountModal">
                                <i class="fa-solid fa-plus"></i>
                                New account
                            </button>

                            <div class="modal fade" id="accountModal" tabindex="-1" role="dialog"
                                aria-labelledby="accountModalLabel" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="accountModalLabel">Add new account
                                            </h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <form action="<?php echo e(route('account.store')); ?>" onsubmit="showSpinner()" method="post"
                                            class="was-validated">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('POST'); ?>

                                            <div class="modal-body">
                                                <label for="name"> Account Name</label>
                                                <input type="text" name="name" class="form-control" id="name"
                                                    value="" required>

                                                <label for="type">Account Type </label>
                                                <input type="text" name="type" class="form-control" id="type"
                                                    value="" required>

                                                <label for="number">Account Number </label>
                                                <input type="number" name="number" class="form-control" id="number"
                                                    value="" required>

                                                <label for="balance">Balance</label>
                                                <input type="number" name="balance" class="form-control" id="balance"
                                                    value="" required>

                                                <label for="main">Main location</label>
                                                <select name="main" id="main" class="form-control" required>
                                                    <option disabled selected value="">-- Select Main
                                                        Location --
                                                    </option>
                                                    <?php $__currentLoopData = App\Models\Location::where('type', 'main')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mainLocation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($mainLocation->id); ?>">
                                                            -- <?php echo e($mainLocation->name); ?> --</option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>

                                                <label for="selling">Selling location</label>
                                                <select name="selling" id="selling" class="form-control" required>
                                                    <option disabled selected value="">-- Select
                                                        selling location --
                                                    </option>
                                                    <?php if($sellingCount > 1): ?>
                                                        <?php $__currentLoopData = $sellings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($selling->id); ?>">
                                                                -- <?php echo e($selling->location->name); ?> --
                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                        <option value="<?php echo e($sellings[0]->id); ?>">
                                                            -- <?php echo e($sellings[0]->location->name); ?> --</option>
                                                    <?php endif; ?>
                                                </select>
                                            </div>

                                            <div class="modal-footer">
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-secondary btn-sm"
                                                        data-dismiss="modal"><i class="fa-solid fa-xmark"></i>
                                                        Close</button>
                                                    <button type="submit" class="btn btn-primary btn-sm"><i
                                                            class="fa-solid fa-paper-plane"></i> Save
                                                        Account</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <button class="btn btn-danger btn-sm" id="deleteall">
                                <i class="fa-solid fa-trash-alt fa-lg"></i> Delete selected</button>

                            
                            <button type="button" class="btn btn-warning btn-sm" data-toggle="modal"
                                data-target="#deposite">
                                <i class="fa-solid fa-down-long fa-lg"></i>
                                Deposite.
                            </button>

                            <div class="modal fade" id="deposite" tabindex="-1">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Cash
                                                Deposite</h5>
                                            <button type="button" class="close" data-dismiss="modal"
                                                aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>

                                        <form action="<?php echo e(route('cash.deposite')); ?>" onsubmit="showSpinner()"
                                            method="post" class="was-validated">
                                            <?php echo csrf_field(); ?>

                                            <div class="modal-body">

                                                <label for="deposite-date">Date</label>
                                                <input type="date" name="date" value="<?php echo e(date('Y-m-d')); ?>"
                                                    class="form-control" id="deposite-date" value="" required>

                                                <label for="deposite-account"> Account Name</label>
                                                <select name="account" class="form-control" id="deposite-account"
                                                    required>
                                                    <option disabled selected value="">
                                                        -- Choose Account --
                                                    </option>
                                                    <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($account->id); ?>">
                                                            -- <?php echo e($account->type); ?> -
                                                            <?php echo e($account->name); ?> -
                                                            <?php echo e($account->selling->location->name); ?> --
                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>

                                                <label for="deposite-amount">Amount</label>
                                                <input type="number" name="amount" class="form-control"
                                                    id="deposite-amount" required>

                                                <label for="deposite-desc">Description</label>
                                                <textarea name="desc" id="deposite-desc" class="form-control" cols="10" rows="4"></textarea>
                                            </div>

                                            <div class="modal-footer">
                                                <button class="btn btn-primary btn-block"><i
                                                        class="fa-solid fa-paper-plane"></i> Confirm
                                                    deposite</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            
                            <button type="button" class="btn btn-secondary btn-sm" data-toggle="modal"
                                data-target="#transfer">
                                <i class="fa-solid fa-arrow-right-arrow-left"></i>
                                Transfer
                            </button>

                            <div class="modal fade" id="transfer" tabindex="-1">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Transfer
                                            </h5>
                                            <button type="button" class="close" data-dismiss="modal"
                                                aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>

                                        <form action="<?php echo e(route('cash.transfer')); ?>" onsubmit="showSpinner()"
                                            method="post" class="was-validated">
                                            <?php echo csrf_field(); ?>

                                            <div class="modal-body">
                                                <label for="transfer-date">Date</label>
                                                <input type="date" name="date" value="<?php echo e(date('Y-m-d')); ?>"
                                                    class="form-control" id="transfer-date" value="" required>

                                                <label for="transfer-from"> From Account</label>
                                                <select name="from" class="form-control" id="transfer-from" required>
                                                    <option disabled selected value="">
                                                        -- Choose Account --
                                                    </option>
                                                    <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($account->id); ?>">
                                                            -- <?php echo e($account->type); ?> -
                                                            <?php echo e($account->name); ?> -
                                                            <?php echo e($account->selling->location->name); ?> --
                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>

                                                <label for="transfer-to"> To Account</label>
                                                <select name="to" class="form-control" id="transfer-to" required>
                                                    <option disabled selected value="">
                                                        --Choose Account--
                                                    </option>
                                                    <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($account->id); ?>">
                                                            -- <?php echo e($account->type); ?> -
                                                            <?php echo e($account->name); ?> -
                                                            <?php echo e($account->selling->location->name); ?> --
                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>

                                                <label for="transfer-amount">Amount</label>
                                                <input type="number" name="amount" class="form-control"
                                                    id="transfer-amount" required>

                                                <label for="transfer-desc">Description</label>
                                                <textarea name="desc" id="transfer-desc" class="form-control" cols="10" rows="4"></textarea>
                                            </div>

                                            <div class="modal-footer">
                                                <button id="confirm-transafer" class="btn btn-primary btn-block"><i
                                                        class="fa-solid fa-paper-plane"></i> Confirm
                                                    Transfer</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            </th>

                            <th>
                                
                                <button type="button" class="btn btn-success" data-toggle="modal"
                                    data-target="#withdraw">
                                    <i class="fa-solid fa-up-long"></i>
                                    Withdraw
                                </button>

                                <div class="modal fade" id="withdraw" tabindex="-1">
                                    <div class="modal-dialog">
                                        <div class="modal-content">

                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">
                                                    Withdraw</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>

                                            <form action="<?php echo e(route('cash.withdraw')); ?>" onsubmit="showSpinner()"
                                                method="post" class="was-validated">
                                                <?php echo csrf_field(); ?>

                                                <div class="modal-body">
                                                    <label for="withdraw-date">Date</label>
                                                    <input type="date" name="date" class="form-control"
                                                        id="withdraw-date" value="<?php echo e(date('Y-m-d')); ?>" required>

                                                    <label for="withdraw-account"> Account</label>
                                                    <select name="account" class="form-control" id="withdraw-account"
                                                        required>
                                                        <option disabled selected value="">
                                                            -- Choose Account --
                                                        </option>
                                                        <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($account->id); ?>">
                                                                <?php echo e($account->type); ?> -
                                                                <?php echo e($account->name); ?> -
                                                                <?php echo e($account->selling->location->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>

                                                    <label for="withdraw-amount">Amount</label>
                                                    <input type="number" name="amount" class="form-control"
                                                        id="withdraw-amount" required>

                                                    <label for="withdraw-desc">Description</label>
                                                    <textarea name="desc" class="form-control" cols="10" rows="withdraw-desc" required></textarea>

                                                </div>

                                                <div class="modal-footer">
                                                    <button class="btn btn-primary btn-block"><i
                                                            class="fa-solid fa-paper-plane"></i> Confirm
                                                        withdarw</button>
                                                </div>

                                            </form>

                                        </div>
                                    </div>
                                </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body table-responsive">

            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle shadow-sm" id="data-table">
                    <thead class="thead-dark">
                        <tr>
                            <th style="width: 5%">
                                <input type="checkbox" id="checkall" title="Select All">
                            </th>
                            <th>A/c Name</th>
                            <th>A/c Type</th>
                            <th>A/c Number</th>
                            <th>Amount</th>
                            <th>Selling Location</th>
                            <th style="width: 20%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $currentDate = date('Y-m-d');
                                $cashIn = App\Models\Transaction::where('account_id', $account->id)
                                    ->where('date', $currentDate)
                                    ->where('status', 'In')
                                    ->sum('amount');
                                $cashOut = App\Models\Transaction::where('account_id', $account->id)
                                    ->where('date', $currentDate)
                                    ->where('status', 'Out')
                                    ->sum('amount');
                                $balance = $cashIn - $cashOut;
                            ?>
                            <tr>
                                <td>
                                    <input type="checkbox" class="selected" id="<?php echo e($account->id); ?>" title="Select">
                                </td>
                                <td>
                                    <span class="fw-bold text-primary"><?php echo e($account->name); ?></span>
                                </td>
                                <td>
                                    <span class="badge bg-info text-dark"><?php echo e($account->type); ?></span>
                                </td>
                                <td>
                                    <span class="text-monospace"><?php echo e($account->number); ?></span>
                                </td>
                                <td class="amount-column" data-account-id="<?php echo e($account->id); ?>">
                                    <span class="fw-bold text-success"><?php echo e(number_format($balance)); ?></span>
                                </td>
                                <td>
                                    <span class="text-secondary">
                                        <?php echo e($account->selling->location->name ?? '-'); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <!-- Edit Button -->
                                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                            data-target="#edit-<?php echo e($account->id); ?>" title="Edit">
                                            <i class="fa-solid fa-pen-to-square"></i> Edit
                                        </button>
                                        <!-- Edit Modal -->
                                        <div class="modal fade" id="edit-<?php echo e($account->id); ?>" tabindex="-1">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header bg-primary text-white">
                                                        <h5 class="modal-title">Edit Account Details</h5>
                                                        <button type="button" class="close text-white"
                                                            data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="<?php echo e(route('account.update', $account->id)); ?>"
                                                        onsubmit="showSpinner()" method="POST" class="was-validated">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PUT'); ?>
                                                        <div class="modal-body">
                                                            <div class="mb-2">
                                                                <label for="name-<?php echo e($account->id); ?>">Account Name</label>
                                                                <input type="text" name="name" class="form-control"
                                                                    id="name-<?php echo e($account->id); ?>"
                                                                    value="<?php echo e($account->name); ?>" required>
                                                            </div>
                                                            <div class="mb-2">
                                                                <label for="type-<?php echo e($account->id); ?>">Account Type</label>
                                                                <input type="text" name="type" class="form-control"
                                                                    id="type-<?php echo e($account->id); ?>"
                                                                    value="<?php echo e($account->type); ?>" required>
                                                            </div>
                                                            <div class="mb-2">
                                                                <label for="number-<?php echo e($account->id); ?>">Account
                                                                    Number</label>
                                                                <input type="number" name="number" class="form-control"
                                                                    id="number-<?php echo e($account->id); ?>"
                                                                    value="<?php echo e($account->number); ?>" required>
                                                            </div>
                                                            <div class="mb-2">
                                                                <label for="balance-<?php echo e($account->id); ?>">Balance</label>
                                                                <input type="number" name="balance" class="form-control"
                                                                    id="balance-<?php echo e($account->id); ?>"
                                                                    value="<?php echo e($account->balance); ?>" required>
                                                            </div>
                                                            <div class="mb-2">
                                                                <label for="main-<?php echo e($account->id); ?>">Main
                                                                    Location</label>
                                                                <select name="main" id="main-<?php echo e($account->id); ?>"
                                                                    class="form-control" required>
                                                                    <option disabled selected value="">--Select main
                                                                        location--</option>
                                                                    <?php $__currentLoopData = App\Models\main::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $main): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($main->id); ?>"
                                                                            <?php if($account->selling->main_id == $main->id): ?> selected <?php endif; ?>>
                                                                            <?php echo e($mainLocation->name); ?>

                                                                        </option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                            <div class="mb-2">
                                                                <label for="selling-<?php echo e($account->id); ?>">Selling
                                                                    Location</label>
                                                                <select name="selling" id="selling-<?php echo e($account->id); ?>"
                                                                    class="form-control" required>
                                                                    <option disabled selected value="">--Select
                                                                        selling location--</option>
                                                                    <?php $__currentLoopData = App\Models\Selling::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($selling->id); ?>"
                                                                            <?php if($account->selling_id == $selling->id): ?> selected <?php endif; ?>>
                                                                            <?php echo e($selling->location->name); ?>

                                                                        </option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button class="btn btn-primary btn-block">
                                                                <i class="fa-solid fa-paper-plane"></i> Save Updates
                                                            </button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Delete Button -->
                                        <button class="btn btn-danger btn-sm delete" id="<?php echo e($account->id); ?>"
                                            title="Delete">
                                            <i class="fa fa-trash-alt"></i> Delete
                                        </button>
                                        <!-- Hidden Delete Form -->
                                        <form action="<?php echo e(route('account.delete', $account->id)); ?>"
                                            onsubmit="showSpinner()" method="POST" id="deleteform<?php echo e($account->id); ?>"
                                            style="display:none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Accounts Found</h5>
                                        <p class="text-muted mb-0">You haven't added any locations yet.<br>
                                            <span class="small">Click <strong>Register Account</strong> to get
                                                started.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>

                    <thead class="thead-light">
                        <tr>
                            <th style="width: 5%">
                                <input type="checkbox" id="checkall" title="Select All">
                            </th>
                            <th>A/c Name</th>
                            <th>A/c Type</th>
                            <th>A/c Number</th>
                            <th>Amount</th>
                            <th>Selling Location</th>
                            <th style="width: 20%">Action</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

    <?php $__env->startSection('scripts'); ?>
        <script>
            //global variable
            var type = "";
            var start = "";
            var end = "";

            $("#start").on("change", function() {
                start = $(this).val();
            });

            $("#end").on("change", function() {
                end = $(this).val();
            });

            $("#duration").on("change", function() {
                type = $(this).val();

                if (type == "today") {
                    $("#start").attr("required", false).fadeOut("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set date") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set duration") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", true).fadeIn("slow");
                }
            });

            $("#search").on("click", function() {
                $.ajax({
                    url: "<?php echo e(route('accounts.balance.per.duration')); ?>",
                    method: "GET",

                    data: {
                        'type': type,
                        'start': start,
                        'end': end
                    },

                    success: function(data) {
                        // Assuming ajaxResponse is your received Ajax response
                        var ajaxResponse = data;

                        // Loop through all account elements in the table
                        $('.amount-column').each(function() {
                            // Get the account ID from the data-account-id attribute
                            var accountId = $(this).data('account-id');

                            // Check if the account ID exists in the Ajax response
                            if (ajaxResponse[accountId]) {
                                // If it exists, use the corresponding amount
                                var amount = ajaxResponse[accountId].amount;
                                $(this).text(amount);
                            } else {
                                // If it doesn't exist, set the amount to 0
                                $(this).text('0');
                            }
                        });
                    }
                });
            });

            $("#checkall").on("click", function() {
                if ($(this).is(':checked', true)) {
                    $(".selected").prop('checked', true);
                } else {
                    $(".selected").prop('checked', false);
                }
            });

            $("#deleteall").on("click", function() {
                var selected = [];
                $(".selected:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "<?php echo e(route('account.bulk.delete')); ?>",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success ',
                                    title: 'deleted successfully!!',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            });
                        }
                    });

                }

            });

            $("#transfer-amount").on("keyup", function() {
                let date = $("#transfer-date").val();
                let account = $("#transfer-from").val();
                let amount = $(this).val();

                $.ajax({
                    url: "<?php echo e(route('get.account.balance')); ?>",
                    method: "get",
                    data: {
                        'account': account,
                        'date': date,
                    },

                    success: function(data) {
                        if (parseInt(amount) > parseInt(data.balance)) {
                            Swal.fire({
                                icon: 'error',
                                title: data.account.name + ' has insufficient fund ',
                                text: date + ' current balance is ' + Intl.NumberFormat().format(
                                    data
                                    .balance) + ' Tzsh',
                                showCloseButton: true
                            });

                            $("#transfer-amount").val(0);
                        }
                    }
                });
            });

            $("#withdraw-amount").on("keyup", function() {
                let date = $("#withdraw-date").val();
                let account = $("#withdraw-account").val();
                let amount = $(this).val();

                $.ajax({
                    url: "<?php echo e(route('get.account.balance')); ?>",
                    method: "GET",
                    data: {
                        account: account,
                        date: date,
                    },
                    success: function(data) {
                        let balance = parseInt(data.balance);
                        let withdrawAmount = parseInt(amount);

                        if (withdrawAmount > balance) {
                            Swal.fire({
                                icon: 'error',
                                title: data.account.name + ' has insufficient funds',
                                text: date + ' Current balance is ' + Intl.NumberFormat().format(
                                        balance) +
                                    ' Tzsh',
                                showCloseButton: true
                            });

                            $("#withdraw-amount").val(0);
                        }
                    }
                });
            });

            $(".delete").on("click", function() {
                var id = $(this).attr("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                })
            });
        </script>
    <?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laraval\dukamax\resources\views/account.blade.php ENDPATH**/ ?>