<?php $__env->startSection('content'); ?>

    <div class="card">

        <div class="card-header">

            <div class="btn-group" role="group" aria-label="Supplier Actions">
                <button type="button" class="btn btn-danger btn-sm" id="deleteall">
                    <i class="fa fa-trash-alt"></i> Delete selected
                </button>
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target=".supplier">
                    <i class="fa fa-plus"></i> Register supplier
                </button>
            </div>

            <div class="modal fade supplier" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">

                        <div class="card">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Register new supplier</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>

                            <form action="<?php echo e(route('supplier.store')); ?>" onsubmit="showSpinner()" method="post"
                                class="was-validated">
                                <?php echo csrf_field(); ?>

                                <div class="card-body">
                                    <label for="name">Supplier</label>
                                    <input type="text" name="name" class="form-control" id="name" required>

                                    <label for="Address">Address</label>
                                    <input type="text" name="address" class="form-control" id="Address" required>

                                    <label for="phone">Phone number</label>
                                    <input type="text" name="phone" class="form-control" id="phone" required>

                                    <label for="email">Email</label>
                                    <input type="email" name="email" class="form-control" id="email">

                                    <label for="vrn">VRN</label>
                                    <input type="text" name="vrn" class="form-control" id="vrn">

                                    <label for="tin">TIN</label>
                                    <input type="text" name="tin" class="form-control" id="tin">

                                    <label for="opening">Opening Balance</label>
                                    <input type="number" name="opening" class="form-control" id="opening" required>

                                    <label for="location">Selling Location</label>
                                    <select name="location" id="location" class="form-control" required>
                                        <option disabled selected value="">-- Select Selling Location --
                                        </option>
                                        <?php $__currentLoopData = $sellings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($selling->id); ?>">
                                                -- <?php echo e($selling->location->name); ?> --</option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="card-footer">
                                    <center>
                                        <button class="btn btn-primary btn-sm btn-block"><i class="fa fa-paper-plane"></i>
                                            Save</button>
                                    </center>
                                </div>
                            </form>
                        </div>

                    </div>
                </div>
            </div>

            
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-bordered align-middle shadow-sm rounded" id="data-table" style="background: #fff;">
                    <thead class="thead-dark">
                        <tr>
                            <th style="width: 3%; text-align: center;">
                                <input type="checkbox" id="checkall">
                            </th>
                            <th>#</th>
                            <th>Name</th>
                            <th>Address</th>
                            <th>Phone</th>
                            <th>Email</th>
                            <th>VRN #</th>
                            <th>TIN #</th>
                            <th>Advance</th>
                            <th style="width: 15%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($suppliers->isEmpty()): ?>
                            <tr>
                                <td colspan="10" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Supplier Found</h5>
                                        <p class="text-muted mb-0">You haven't added any suppliers yet.<br>
                                            <span class="small">Click <strong>Register supplier</strong> to get started.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center">
                                        <input type="checkbox" class="selected" id="<?php echo e($supplier->id); ?>">
                                    </td>
                                    <td class="text-center"><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <span class="font-weight-bold"><?php echo e($supplier->name); ?></span>
                                    </td>
                                    <td><?php echo e($supplier->address); ?></td>
                                    <td>
                                        <span class="badge badge-info"><?php echo e($supplier->phone); ?></span>
                                    </td>
                                    <td>
                                        <?php if($supplier->email): ?>
                                            <span class="text-primary"><?php echo e($supplier->email); ?></span>
                                        <?php else: ?>
                                            <span class="text-muted">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($supplier->vrn): ?>
                                            <span class="badge badge-secondary"><?php echo e($supplier->vrn); ?></span>
                                        <?php else: ?>
                                            <span class="text-muted">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($supplier->tin): ?>
                                            <span class="badge badge-secondary"><?php echo e($supplier->tin); ?></span>
                                        <?php else: ?>
                                            <span class="text-muted">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($supplier->advance): ?>
                                            <span class="badge badge-success"><?php echo e(number_format($supplier->advance, 2)); ?></span>
                                        <?php else: ?>
                                            <span class="text-muted">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group" aria-label="Supplier Actions">
                                            <!-- Edit Button -->
                                            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                                data-target="#edit-<?php echo e($supplier->id); ?>" title="Edit">
                                                <i class="fa-solid fa-pen-to-square"></i> Edit
                                            </button>
                                            <!-- Edit Modal -->
                                            <div class="modal fade" id="edit-<?php echo e($supplier->id); ?>" tabindex="-1" role="dialog"
                                                aria-labelledby="editSupplierLabel<?php echo e($supplier->id); ?>" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header bg-primary text-white">
                                                            <h5 class="modal-title" id="editSupplierLabel<?php echo e($supplier->id); ?>">Update Supplier Details</h5>
                                                            <button type="button" class="close text-white" data-dismiss="modal"
                                                                aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="<?php echo e(route('supplier.update', $supplier->id)); ?>"
                                                            onsubmit="showSpinner()" method="get" class="was-validated">
                                                            <?php echo csrf_field(); ?>
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="name-<?php echo e($supplier->id); ?>">Name</label>
                                                                    <input type="text" name="name" class="form-control"
                                                                        value="<?php echo e($supplier->name); ?>" id="name-<?php echo e($supplier->id); ?>">
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="address-<?php echo e($supplier->id); ?>">Address</label>
                                                                    <input type="text" name="address" class="form-control"
                                                                        value="<?php echo e($supplier->address); ?>"
                                                                        id="address-<?php echo e($supplier->id); ?>">
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="phone-<?php echo e($supplier->id); ?>">Phone</label>
                                                                    <input type="text" name="phone" class="form-control"
                                                                        value="<?php echo e($supplier->phone); ?>"
                                                                        id="phone-<?php echo e($supplier->id); ?>">
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="email-<?php echo e($supplier->id); ?>">Email</label>
                                                                    <input type="email" name="email" class="form-control"
                                                                        value="<?php echo e($supplier->email); ?>"
                                                                        id="email-<?php echo e($supplier->id); ?>">
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="vrn-<?php echo e($supplier->id); ?>">VRN No.</label>
                                                                    <input type="text" name="vrn" class="form-control"
                                                                        value="<?php echo e($supplier->vrn); ?>" id="vrn-<?php echo e($supplier->id); ?>">
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="tin-<?php echo e($supplier->id); ?>">TIN No.</label>
                                                                    <input type="text" name="tin" class="form-control"
                                                                        value="<?php echo e($supplier->tin); ?>" id="tin-<?php echo e($supplier->id); ?>">
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="advance-<?php echo e($supplier->id); ?>">Advance</label>
                                                                    <input type="number" name="advance" class="form-control"
                                                                        value="<?php echo e($supplier->advance); ?>"
                                                                        id="advance-<?php echo e($supplier->id); ?>">
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="description-<?php echo e($supplier->id); ?>">Description</label>
                                                                    <input type="text" name="description" class="form-control"
                                                                        value="<?php echo e($supplier->description); ?>"
                                                                        id="description-<?php echo e($supplier->id); ?>">
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="opening-<?php echo e($supplier->id); ?>">Opening Balance</label>
                                                                    <input type="number" name="opening" class="form-control"
                                                                        value="<?php echo e($supplier->opening_balance); ?>"
                                                                        id="opening-<?php echo e($supplier->id); ?>" required>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="location-<?php echo e($supplier->name); ?>">Selling Location</label>
                                                                    <select name="location" id="location-<?php echo e($supplier->name); ?>"
                                                                        class="form-control" required>
                                                                        <option selected value="<?php echo e($supplier->selling_id); ?>">
                                                                            -- <?php echo e($supplier->selling->location->name); ?> --
                                                                        </option>
                                                                        <?php $__currentLoopData = $sellings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($selling->_id); ?>">
                                                                                -- <?php echo e($selling->location->name); ?> --
                                                                            </option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button class="btn btn-primary btn-block"><i
                                                                        class="fa fa-paper-plane"></i> Save Updates</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Delete Button -->
                                            <button class="btn btn-danger btn-sm delete" id="<?php echo e($supplier->id); ?>" title="Delete">
                                                <i class="fa fa-trash-alt"></i> Delete  
                                                <form action="<?php echo e(route('supplier.delete', $supplier->id)); ?>"
                                                    onsubmit="showSpinner()" method="GET" id="deleteform<?php echo e($supplier->id); ?>">
                                                </form>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                    <tfoot class="thead-light">
                        <tr>
                            <th><input type="checkbox" id="checkall"></th>
                            <th>#</th>
                            <th>Name</th>
                            <th>Address</th>
                            <th>Phone</th>
                            <th>Email</th>
                            <th>VRN #</th>
                            <th>TIN #</th>
                            <th>Advance</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

<?php $__env->startSection('scripts'); ?>
    <script>
        $("#2").on("change", function() {

            var account = $(this).val();
            var amount = $("#1").val();

            $.ajax({

                url: "<?php echo e(route('get.account.balance')); ?>",
                method: "get",
                data: {
                    'account': account,
                },
                success: function(data) {

                    console.log(data);

                    if (amount > data.balance) {

                        alert(account + " has insuficient fund " + (
                            data.balance));
                        $("#submit").fadeOut("slow");

                    } else {
                        $("#submit").fadeIn("slow");
                    }

                }
            });

        });

        $("#checkall").on("click", function() {
            if ($(this).is(':checked', true)) {
                $(".selected").prop('checked', true);
            } else {
                $(".selected").prop('checked', false);
            }
        });

        $("#deleteall").on("click", function() {
            var selected = [];
            $(".selected:checked").each(function() {
                selected.push($(this).attr("id"));
            });

            if (selected.length == 0) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Select atleast one item!!',
                });
            } else {
                if (confirm("Are you sure..")) {
                    $.ajax({
                        url: "<?php echo e(route('supplier.bulk.delete')); ?>",
                        method: "GET",
                        data: {
                            'ids': selected
                        },
                        success: function(data) {
                            window.location.reload(true);
                        }
                    });
                }

            }

        });

        $(".delete").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("deleteform" + id).submit();
                }
            })
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laraval\dukamax\resources\views/supplier.blade.php ENDPATH**/ ?>